/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class PageInfoResp<T>
implements Serializable {
    private static final long serialVersionUID = 2405172041950251807L;
    private int pageSize;
    private int pageNo;
    private int totalPages;
    private int totalRecords;
    private List<T> list;

    public PageInfoResp(int pageNo, int pageSize, int totalRecords, List<T> list) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.totalRecords = totalRecords;
        this.list = list;
        this.totalPages = (int)Math.ceil((double)totalRecords * 1.0 / (double)pageSize);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize > 0 ? pageSize : 10;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo <= 1 ? 1 : (pageNo > this.totalPages ? this.totalPages : pageNo);
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages() {
        this.totalPages = this.totalRecords % this.pageSize == 0 ? this.totalRecords / this.pageSize : this.totalRecords / this.pageSize + 1;
    }

    public int getTotalRecords() {
        return this.totalRecords;
    }

    public void setTotalRecords(int totalRecords) {
        this.totalRecords = totalRecords >= 0 ? totalRecords : 0;
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public void queryPager(int pageNo, int pageSize, List<T> list) {
        if (list != null && list.size() != 0) {
            this.setTotalRecords(list.size());
        } else {
            this.setTotalRecords(0);
        }
        this.setPageSize(pageSize);
        this.setTotalPages();
        this.setPageNo(pageNo);
        this.list = list != null && list.size() != 0 ? (pageNo == this.totalPages ? list.subList((pageNo - 1) * pageSize, this.totalRecords) : list.subList((pageNo - 1) * pageSize, pageNo * pageSize)) : new ArrayList();
    }

    public boolean isPrePage() {
        return this.pageNo > 1;
    }

    public boolean isNextPage() {
        return this.pageNo < this.totalPages;
    }

    public int getPrePageNo() {
        if (this.isPrePage()) {
            return this.pageNo - 1;
        }
        return this.pageNo;
    }

    public int getNextPageNo() {
        if (this.isNextPage()) {
            return this.pageNo + 1;
        }
        return this.pageNo;
    }

    @Generated
    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageInfoResp)) {
            return false;
        }
        PageInfoResp other = (PageInfoResp)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getPageNo() != other.getPageNo()) {
            return false;
        }
        if (this.getTotalPages() != other.getTotalPages()) {
            return false;
        }
        if (this.getTotalRecords() != other.getTotalRecords()) {
            return false;
        }
        List this$list = this.getList();
        List other$list = other.getList();
        return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PageInfoResp;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageSize();
        result = result * 59 + this.getPageNo();
        result = result * 59 + this.getTotalPages();
        result = result * 59 + this.getTotalRecords();
        List $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PageInfoResp(pageSize=" + this.getPageSize() + ", pageNo=" + this.getPageNo() + ", totalPages=" + this.getTotalPages() + ", totalRecords=" + this.getTotalRecords() + ", list=" + this.getList() + ")";
    }

    @Generated
    public PageInfoResp(int pageSize, int pageNo, int totalPages, int totalRecords, List<T> list) {
        this.pageSize = pageSize;
        this.pageNo = pageNo;
        this.totalPages = totalPages;
        this.totalRecords = totalRecords;
        this.list = list;
    }

    @Generated
    public PageInfoResp() {
    }
}

