/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.common.enums;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EventTypeEnum {
    BACK_TO_WORKBENCH_BUTTON_CLICK(Integer.valueOf(1), "backToWorkbenchButtonClick", "\u70b9\u51fb\u8fd4\u56de\u5de5\u4f5c\u53f0\u6309\u94ae"),
    SEARCH_MENU(Integer.valueOf(2), "searchMenu", "\u70b9\u51fb\u641c\u7d22\u680f"),
    TENANT_SWITCH_BUTTON_CLICK(Integer.valueOf(3), "tenantSwitchButtonClick", "\u70b9\u51fb\u79df\u6237\u5207\u6362\u6309\u94ae"),
    LOGIN_OUT_CLICK(Integer.valueOf(4), "loginOutClick", "\u70b9\u51fb\u767b\u51fa\u6309\u94ae"),
    LOGIN_OUT_CANCEL_CLICK(Integer.valueOf(5), "loginOutCancelClick", "\u70b9\u51fb\u53d6\u6d88\u767b\u51fa\u6309\u94ae"),
    LOGIN_OUT_CONFIRM_CLICK(Integer.valueOf(6), "loginOutConfirmClick", "\u767b\u51fa"),
    BACKGROUND_MENU_CLICK(Integer.valueOf(7), "backgroundMenuClick", "\u70b9\u51fb\u540e\u53f0\u83dc\u5355"),
    HOST_SEMC_URL(Integer.valueOf(8), "host_semc_url", "\u7ba1\u7406\u540e\u53f0\u770b\u662f\u5426\u6709\u4eba\u8bbf\u95eesemc\u7f51\u5740\u57cb\u70b9"),
    LOGIN_CLICK(Integer.valueOf(9), "loginClick", "\u767b\u5f55"),
    WORK_AUTHORIZATION(Integer.valueOf(10), "workAuthorization", "\u7ba1\u7406\u540e\u53f0\u8d4b\u6743"),
    THIRD_TODO_CLICK(Integer.valueOf(11), "thirdTodoClick", "\u67e5\u770b\u4e09\u65b9\u5f85\u529e"),
    THIRD_MESSAGE_CLICK(Integer.valueOf(12), "thirdMessageClick", "\u67e5\u770b\u4e09\u65b9\u6d88\u606f"),
    CUSTOM_PORTAL_CLICK(Integer.valueOf(13), "customPortalClick", "\u4f7f\u7528\u5de5\u4f5c\u53f0"),
    COMPONENT_CLICK(Integer.valueOf(14), "componentClick", "\u70b9\u51fb\u90e8\u4ef6");

    private final Integer eventType;
    private final String eventId;
    private final String desc;

    private EventTypeEnum(Integer eventType, String eventName, String desc) {
        this.eventType = eventType;
        this.eventId = eventName;
        this.desc = desc;
    }

    public static List<Integer> getAllEventType() {
        return Arrays.stream(EventTypeEnum.values()).map(EventTypeEnum::getEventType).collect(Collectors.toList());
    }

    public static List<String> getAllEventName() {
        return Arrays.stream(EventTypeEnum.values()).map(EventTypeEnum::getEventId).collect(Collectors.toList());
    }

    public static List<String> getWorkbenchEventName() {
        return Arrays.asList(LOGIN_OUT_CONFIRM_CLICK.getEventId(), LOGIN_CLICK.getEventId(), WORK_AUTHORIZATION.getEventId(), THIRD_TODO_CLICK.getEventId(), THIRD_MESSAGE_CLICK.getEventId(), CUSTOM_PORTAL_CLICK.getEventId(), COMPONENT_CLICK.getEventId());
    }

    public static List<String> getEventIdByEventType(List<Integer> eventTypes) {
        ArrayList eventNames = Lists.newArrayList();
        if (CollectionUtils.isEmpty(eventTypes)) {
            return eventNames;
        }
        eventTypes.forEach(eventType -> {
            for (EventTypeEnum eventTypeEnum : EventTypeEnum.values()) {
                if (!eventTypeEnum.getEventType().equals(eventType)) continue;
                eventNames.add(eventTypeEnum.getEventId());
                break;
            }
        });
        return eventNames;
    }

    public static Integer getEventTypeByEventId(String eventName) {
        for (EventTypeEnum eventTypeEnum : EventTypeEnum.values()) {
            if (!eventTypeEnum.getEventId().equals(eventName)) continue;
            return eventTypeEnum.getEventType();
        }
        return null;
    }

    public static String getDescByEventId(String eventName) {
        for (EventTypeEnum eventTypeEnum : EventTypeEnum.values()) {
            if (!eventTypeEnum.getEventId().equals(eventName)) continue;
            return eventTypeEnum.getDesc();
        }
        return null;
    }

    @Generated
    public Integer getEventType() {
        return this.eventType;
    }

    @Generated
    public String getEventId() {
        return this.eventId;
    }

    @Generated
    public String getDesc() {
        return this.desc;
    }
}

