/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.configuration;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.MongoClientImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;

@Configuration
public class MongoTemplateConfig {
    @Value(value="${spring.data.mongodb.uri}")
    private String uriLog;
    @Value(value="${spring.data.mongodb.database}")
    private String databaseLog;
    @Value(value="${spring.data.mongodb-applink.uri}")
    private String uriAppLink;
    @Value(value="${spring.data.mongodb-applink.database}")
    private String databaseAppLink;

    @Bean(value={"mongoTemplate"})
    public MongoTemplate mongoTemplate() {
        MongoClientImpl client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(this.uriLog)).build(), null);
        return new MongoTemplate((MongoClient)client, this.databaseLog);
    }

    @Bean(value={"appLinkMongoTemplate"})
    public MongoTemplate appLinkMongoTemplate() {
        MongoClientImpl client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(this.uriAppLink)).build(), null);
        return new MongoTemplate((MongoClient)client, this.databaseAppLink);
    }
}

