/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.configuration;

import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RedissonConfig {
    @Value(value="${spring.redis.host}")
    private String redisHost;
    @Value(value="${spring.redis.port}")
    private String redisPort;
    @Value(value="${spring.redis.password}")
    private String redisPassword;
    @Value(value="${spring.redis.database}")
    private Integer redisDatabase;

    @Bean
    public RedissonClient redissonClient() {
        Config config = new Config();
        SingleServerConfig singleServerConfig = config.useSingleServer();
        singleServerConfig.setAddress("redis://" + this.redisHost + ":" + this.redisPort);
        singleServerConfig.setDatabase(this.redisDatabase.intValue());
        if (StringUtils.isNotBlank((CharSequence)this.redisPassword)) {
            singleServerConfig.setPassword(this.redisPassword);
        }
        config.setNettyThreads(8);
        config.setThreads(8);
        return Redisson.create((Config)config);
    }
}

