/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.configuration;

import com.digiwin.athena.appcore.constant.ErrorTypeEnum;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.BizException;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ServiceException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@ControllerAdvice(annotations={RestController.class, Controller.class})
public class RestControllerExceptionHandler {
    private static Logger logger = LoggerFactory.getLogger(RestControllerExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    ResponseEntity<?> handleControllerException(HttpServletRequest request, Throwable ex) {
        String requestUrl = request.getRequestURL().toString();
        if (ex instanceof ServiceException) {
            ServiceException le = (ServiceException)ex;
            logger.warn("\u5168\u5c40ServiceException\u5f02\u5e38\uff1a{}", (Object)requestUrl, (Object)ex);
            return ResponseEntityWrapper.wrapperFail((int)le.getCode(), (String)le.getMessage());
        }
        if (ex instanceof BizException) {
            BizException le = (BizException)ex;
            logger.warn("\u5168\u5c40BizException\u5f02\u5e38\uff1a{}", (Object)requestUrl, (Object)ex);
            return ResponseEntityWrapper.wrapperFail((int)le.getCode(), (String)le.getMessage());
        }
        if (ex instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException e = (MethodArgumentNotValidException)ex;
            List errorList = e.getBindingResult().getAllErrors();
            StringBuffer errorMsg = new StringBuffer();
            errorList.forEach(x -> errorMsg.append(x.getDefaultMessage()).append(";"));
            String substring = StringUtils.isNotBlank((CharSequence)errorMsg) ? errorMsg.substring(0, errorMsg.length() - 1) : "";
            logger.warn("\u5168\u5c40\u53c2\u6570\u6821\u9a8c\u5f02\u5e38\uff1a{}\uff0c{}", new Object[]{requestUrl, substring, e});
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)substring);
        }
        logger.error("\u5168\u5c40Exception\u5f02\u5e38\uff1a{}", (Object)requestUrl, (Object)ex);
        BaseResultDTO result = new BaseResultDTO();
        result.setErrorType(ErrorTypeEnum.BUSINESS.getValue());
        result.setErrorCode(String.valueOf(ErrorCodeConstant.SYSTEM_ERROR));
        result.setErrorMessage((Object)"\u7cfb\u7edf\u5f02\u5e38");
        result.setStatus(Integer.valueOf(HttpStatus.INTERNAL_SERVER_ERROR.value()));
        result.setStatusDescription(HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase());
        result.setPath(requestUrl);
        result.setServerTime(Long.valueOf(System.currentTimeMillis()));
        result.setDebugInfo((Object)ex.getMessage());
        return ResponseEntity.ok((Object)result);
    }

    private HttpStatus getStatus(HttpServletRequest request) {
        Integer statusCode = (Integer)request.getAttribute("javax.servlet.error.status_code");
        if (statusCode == null) {
            return HttpStatus.INTERNAL_SERVER_ERROR;
        }
        return HttpStatus.valueOf((int)statusCode);
    }
}

