/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.configuration;

import com.digiwin.athena.semc.configuration.MdcTaskDecorator;
import com.digiwin.athena.semc.configuration.ThreadPoolConfig;
import com.jugg.agile.framework.core.util.concurrent.migration.JaTtlExecutors;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class ThreadPoolConfig
implements AsyncConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolConfig.class);

    @Bean(value={"semcAsyncExecutor"})
    public Executor asyncTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(8);
        executor.setMaxPoolSize(64);
        executor.setQueueCapacity(10000);
        executor.setKeepAliveSeconds(60);
        executor.setThreadNamePrefix("semc-async-");
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.setTaskDecorator((TaskDecorator)new MdcTaskDecorator());
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return JaTtlExecutors.getTtlExecutor((Executor)executor);
    }

    public Executor getAsyncExecutor() {
        return this.asyncTaskExecutor();
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return new MyAsyncExceptionHandler(null);
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }
}

