/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.configuration.mqtt;

import com.digiwin.athena.semc.configuration.mqtt.MqttProperties;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.integration.mqtt.core.DefaultMqttPahoClientFactory;
import org.springframework.integration.mqtt.core.MqttPahoClientFactory;
import org.springframework.stereotype.Component;

@Component
public class MqttConfig {
    @Autowired
    private MqttProperties mqttConfiguration;

    @Bean
    public MqttPahoClientFactory mqttClientFactory() {
        DefaultMqttPahoClientFactory factory = new DefaultMqttPahoClientFactory();
        MqttConnectOptions options = new MqttConnectOptions();
        options.setCleanSession(true);
        options.setConnectionTimeout(0);
        options.setKeepAliveInterval(90);
        options.setAutomaticReconnect(true);
        options.setUserName(this.mqttConfiguration.getUsername());
        options.setPassword(this.mqttConfiguration.getPassword().toCharArray());
        options.setServerURIs(new String[]{this.mqttConfiguration.getUrl()});
        options.setMaxInflight(this.mqttConfiguration.getMaxInflight().intValue());
        factory.setConnectionOptions(options);
        return factory;
    }
}

