/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.configuration.mqtt;

import com.digiwin.athena.semc.configuration.mqtt.MqttProperties;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.mqtt.core.MqttPahoClientFactory;
import org.springframework.integration.mqtt.outbound.MqttPahoMessageHandler;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;

@Configuration
public class MqttOutboundConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MqttOutboundConfiguration.class);
    private MqttProperties mqttConfig;
    private MqttPahoClientFactory factory;

    @Bean
    public MessageChannel mqttOutboundChannel() {
        return new DirectChannel();
    }

    @Bean
    @ServiceActivator(inputChannel="mqttOutboundChannel")
    public MessageHandler mqttOutbound() {
        MqttPahoMessageHandler messageHandler = new MqttPahoMessageHandler(this.mqttConfig.getServerName() + "_server_" + this.mqttConfig.getClientId() + "-" + UUID.randomUUID().toString(), this.factory);
        messageHandler.setDefaultQos(0);
        messageHandler.setAsync(true);
        messageHandler.setDefaultTopic(this.mqttConfig.getDefaultTopic());
        return messageHandler;
    }

    @Generated
    public MqttOutboundConfiguration(MqttProperties mqttConfig, MqttPahoClientFactory factory) {
        this.mqttConfig = mqttConfig;
        this.factory = factory;
    }
}

