/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.semc.dto.AuthReqDTO;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import io.swagger.v3.oas.annotations.Operation;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/semc/auth"})
public class AuthController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthController.class);
    @Resource
    private EnvProperties envProperties;
    @Resource
    private RestTemplate restTemplate;

    @Operation(method="verifyAppAuthorized", description="\u5e94\u7528\u6388\u6743\u8ba4\u8bc1\u6821\u9a8c")
    @PostMapping(value={"/verifyAppAuthorized"})
    public ResponseEntity<BaseResultDTO<Boolean>> check(@RequestBody @Valid AuthReqDTO authReqDTO) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        String url = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/tenants/" + tenantId + "/goods/" + authReqDTO.getGoodsCode();
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
            headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
            HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, Map.class, new Object[0]);
            log.debug("verify if the app is authorized, tenantId:{}, code:{}, result:{}", new Object[]{tenantId, authReqDTO.getGoodsCode(), JsonUtils.objectToString((Object)response)});
            if (response.getBody() != null && ((Map)response.getBody()).containsKey("purchaseId")) {
                return ResponseEntityWrapperUtil.wrapperOk((Object)true);
            }
        }
        catch (Exception e) {
            log.error("verify if the app is authorized occur error, tenantId:{}, code:{}", new Object[]{tenantId, authReqDTO.getGoodsCode(), e});
        }
        return ResponseEntityWrapperUtil.wrapperOk((Object)false);
    }
}

