/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.dto.common.TranslateReq;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/common"})
public class CommonController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonController.class);
    @Resource
    private TranslateService translateService;
    @Resource
    private MessageUtils messageUtils;

    @PostMapping(value={"/trans/translate"})
    public ResponseEntity<BaseResultDTO<JSONObject>> translate(@RequestBody TranslateReq translateReq) {
        try {
            JSONObject jsonObject = this.translateService.translateTextPackage(translateReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)jsonObject);
        }
        catch (Exception e) {
            log.error("CommonController translate text error. param:{}", (Object)translateReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/common/trans/translate, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @GetMapping(value={"/downFile"})
    public ResponseEntity<org.springframework.core.io.Resource> downFile(String path) throws IOException {
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new RuntimeException("\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        }
        Path filePath = Paths.get(path, new String[0]);
        UrlResource resource = new UrlResource(filePath.toUri());
        if (resource.exists() || resource.isReadable()) {
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Disposition", "attachment; filename=\"" + resource.getFilename() + "\"");
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength(resource.contentLength()).body((Object)resource);
        }
        throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u8bfb");
    }
}

