/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.eai.DigiSrvcode;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.eai.EAIService;
import com.digiwin.athena.semc.dto.DWEAIResultBean;
import com.digiwin.athena.semc.dto.EaiResp;
import com.digiwin.athena.semc.service.eai.EaiService;
import com.digiwin.athena.semc.util.ReqAndRespUtil;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc"})
public class EaiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EaiController.class);
    @Autowired
    private EaiService eaiService;

    @PostMapping(value={"/eai"})
    public EaiResp eai(@RequestBody(required=false) JSONObject eaiJSONObject, HttpServletRequest request, HttpServletResponse response) {
        log.info("EaiController.eai param:{}", (Object)JSONObject.toJSONString((Object)eaiJSONObject));
        String digiServiceStr = request.getHeader("digi-service");
        String digiType = request.getHeader("digi-type");
        if ("fasync".equals(digiType)) {
            eaiJSONObject.put("digi-reqid", (Object)request.getHeader("digi-reqid"));
        }
        eaiJSONObject.fluentPut("token", (Object)request.getHeader("token"));
        ReqAndRespUtil.putParasToResponseHeaders((HttpServletResponse)response);
        EaiResp eaiResp = this.invoke(JSON.parseObject((String)digiServiceStr), eaiJSONObject);
        return eaiResp;
    }

    private EaiResp invoke(JSONObject diGiService, JSONObject param) {
        String name = null;
        try {
            Method[] methods;
            name = diGiService.getString("name");
            Class<?> cls = this.eaiService.getClass();
            for (Method method : methods = cls.getDeclaredMethods()) {
                EAIService EAIService2;
                if (null == method.getDeclaredAnnotations() || !Objects.nonNull(EAIService2 = method.getAnnotation(EAIService.class)) || !EAIService2.id().equals(name)) continue;
                try {
                    log.info("EAIService invoke start name:{},param:{}", (Object)name, (Object)JSONObject.toJSONString((Object)param));
                    DWEAIResultBean resultBean = new DWEAIResultBean((DWEAIResult)method.invoke((Object)this.eaiService, param));
                    Map std_data = resultBean.getStd_data();
                    Object parameter = std_data.get("parameter");
                    return EaiResp.buildSucc(parameter);
                }
                catch (Exception e) {
                    log.error("EAIService invoke  error name:{},param:{},e:{}", new Object[]{name, JSONObject.toJSONString((Object)param), e});
                    return EaiResp.buildError((String)DigiSrvcode.failure.value(), (String)"-1", (String)ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
            }
            log.info("EAIService invoke service not find name:{},param:{}", (Object)name, (Object)JSONObject.toJSONString((Object)param));
            return EaiResp.buildError((String)DigiSrvcode.failure.value(), (String)"-1", (String)"\u670d\u52a1\u4e0d\u5b58\u5728");
        }
        catch (Exception ex) {
            log.error("EAIService.invoke error name:{},eaiParam:{}", new Object[]{name, JSONObject.toJSONString((Object)param), ex});
            String description = ExceptionUtils.getRootCauseMessage((Throwable)ex);
            return EaiResp.buildError((String)DigiSrvcode.failure.value(), (String)"-1", (String)description);
        }
    }

    @Generated
    public EaiController() {
    }
}

