/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.dto.config.TenantAttributeDto;
import com.digiwin.athena.semc.service.tenant.TenantAttributeService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import io.swagger.v3.oas.annotations.Operation;
import javax.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/tenant/attribute"})
public class TenantAttributeController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantAttributeController.class);
    @Resource
    private TenantAttributeService tenantAttributeService;
    @Resource
    private MessageUtils messageUtils;

    @Operation(method="\u83b7\u53d6\u79df\u6237\u5c5e\u6027\u503c\u63a5\u53e3", description="\u83b7\u53d6\u79df\u6237\u5c5e\u6027\u503c\u63a5\u53e3")
    @GetMapping(value={""})
    public ResponseEntity<BaseResultDTO<Object>> queryAttributeValue(@RequestParam(value="attributeCode") String attributeCode) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.tenantAttributeService.queryTenantAttributeByCode(attributeCode));
        }
        catch (Exception e) {
            log.error("TenantAttributeController.queryAttributeValue is error, attributeCode:{}", (Object)attributeCode, (Object)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @Operation(method="\u66f4\u65b0\u79df\u6237\u5c5e\u6027\u503c", description="\u66f4\u65b0\u79df\u6237\u5c5e\u6027\u503c")
    @PostMapping(value={"/update"})
    public ResponseEntity<BaseResultDTO<Object>> updateAttributeValue(@RequestBody TenantAttributeDto<Object> attribute) {
        try {
            return this.tenantAttributeService.updateAttributeValue(attribute);
        }
        catch (Exception e) {
            log.error("TenantAttributeController.queryAttributeValue is error, attributeCode:{}", null, (Object)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }
}

