/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.bench;

import com.alibaba.excel.util.StringUtils;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.entity.bench.JobBench;
import com.digiwin.athena.semc.service.bench.JobBenchService;
import com.digiwin.athena.semc.service.portal.LabelSystemAuthService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.bench.JobBenchSaveVO;
import com.digiwin.athena.semc.vo.bench.OrderBenchLaneVO;
import com.digiwin.athena.semc.vo.bench.OrderLaneJobVO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/job/bench/"})
public class JobBenchController {
    private static final Logger logger = LoggerFactory.getLogger(JobBenchController.class);
    @Autowired
    JobBenchService jobBenchService;
    @Resource
    private MessageUtils messageUtils;
    @Autowired
    LabelSystemAuthService labelSystemAuthService;

    @PostMapping(value={"/queryBenchList"})
    public ResponseEntity<BaseResultDTO<List<JobBench>>> queryBenchList() {
        try {
            ArrayList allSystemIdList = new ArrayList();
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.jobBenchService.queryAllBench(null, allSystemIdList));
        }
        catch (Exception e) {
            logger.error("queryBenchList exceptiona", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/job/bench/queryBenchList");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/queryTempBenchList"})
    public ResponseEntity<BaseResultDTO<List<JobBench>>> queryTempBenchList() {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.jobBenchService.queryTempBenchList());
        }
        catch (Exception e) {
            logger.error("queryTempBenchList exceptiona", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/job/bench/queryTempBenchList");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/queryAuthBenchList"})
    public ResponseEntity<BaseResultDTO<List<JobBench>>> queryAuthBenchList() {
        try {
            List customIdList = this.labelSystemAuthService.getSystemCustom();
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.jobBenchService.queryAuthAllBench(customIdList));
        }
        catch (Exception e) {
            logger.error("queryAuthBenchList exceptiona", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/job/bench/queryAuthBenchList");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/saveBenchLane"})
    public ResponseEntity<BaseResultDTO<Long>> saveBenchLane(@RequestBody JobBench req) {
        try {
            if (null == req.getLabelIndex()) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"labelIndex is not empty");
            }
            if (StringUtils.isEmpty((CharSequence)req.getName())) {
                String error = this.messageUtils.getMessage("error.message.job.bench.name.empty");
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)error);
            }
            if (req.getName().length() > 12) {
                String error = this.messageUtils.getMessage("error.message.job.bench.name.empty.length");
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)error);
            }
            List jobBenchList = this.jobBenchService.selectByName(req);
            if (!CollectionUtils.isEmpty((Collection)jobBenchList)) {
                String error = this.messageUtils.getMessage("error.message.job.bench.name.repeat");
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.jobBenchService.saveBench(req));
        }
        catch (Exception e) {
            logger.error("saveBenchLane exceptiona", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/job/bench/saveBenchLane");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/saveJobList"})
    public ResponseEntity<?> saveJobList(@RequestBody @Valid JobBenchSaveVO req) {
        try {
            this.jobBenchService.saveJobList(req);
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            logger.error("saveJobList exceptiona", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/job/bench/saveJobList");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/delBeanLane"})
    public ResponseEntity<?> delBeanLane(@RequestBody JobBenchSaveVO req) {
        try {
            if (null == req.getId()) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"id is not empty");
            }
            this.jobBenchService.delBeanLane(req.getId());
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            logger.error("delBeanLane exceptiona", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/job/bench/delBeanLane");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/delLaneJob"})
    public ResponseEntity<?> delLaneJob(@RequestBody @Valid JobBenchSaveVO req) {
        try {
            if (CollectionUtils.isEmpty((Collection)req.getSystemIdList())) {
                String error = this.messageUtils.getMessage("error.message.system.data.job.empty");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
            }
            this.jobBenchService.delLaneJob(req);
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            logger.error("delLaneJob exceptiona", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/job/bench/delLaneJob");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/orderBenchLane"})
    public ResponseEntity<?> orderBenchLane(@RequestBody @Valid OrderBenchLaneVO req) {
        try {
            this.jobBenchService.orderBenchLane(req);
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            logger.error("orderBenchLane exceptiona", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/job/bench/orderBenchLane");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/orderLaneJob"})
    public ResponseEntity<?> orderLaneJob(@RequestBody @Valid OrderLaneJobVO req) {
        try {
            this.jobBenchService.orderLaneJob(req);
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            logger.error("orderLaneJob exceptiona", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/job/bench/orderLaneJob");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

