/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.bench;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.entity.bench.JobBenchImport;
import com.digiwin.athena.semc.entity.portal.LabelSystemDataImport;
import com.digiwin.athena.semc.service.bench.JobBenchService;
import com.digiwin.athena.semc.service.bench.impl.JobBenchWriteHandler;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.bench.JobBenchExportVo;
import com.digiwin.athena.semc.vo.bench.JobBenchImportVo;
import com.digiwin.athena.semc.vo.portal.ImportExcelResp;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/job/bench/"})
public class JobBenchImportController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobBenchImportController.class);
    @Autowired
    JobBenchService jobBenchService;
    @Resource
    private MessageUtils messageUtils;

    @PostMapping(value={"/importReport"})
    public ResponseEntity<BaseResultDTO<ImportExcelResp>> importReport(@RequestBody LabelSystemDataImport req) {
        if (StringUtils.isEmpty((String)req.getFileId())) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"file code cannot be empty");
        }
        ImportExcelResp excelResp = new ImportExcelResp();
        try {
            List excelVoList = this.jobBenchService.readExcel(req.getFileId());
            if (CollectionUtils.isEmpty((Collection)excelVoList)) {
                String error = this.messageUtils.getMessage("error.message.import.cannot.be.empty");
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
            excelVoList = this.trimDataList(excelVoList);
            excelResp = this.jobBenchService.importReport(excelVoList);
            return ResponseEntityWrapperUtil.wrapperOk((Object)excelResp);
        }
        catch (Exception e) {
            log.error("JobBenchImportController import excel exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    public List<JobBenchImportVo> trimDataList(List<JobBenchImportVo> excelVoList) {
        for (JobBenchImportVo excelVo : excelVoList) {
            if (StringUtils.isNotEmpty((String)excelVo.getBenchName())) {
                excelVo.setBenchName(excelVo.getBenchName().trim());
            }
            if (StringUtils.isNotEmpty((String)excelVo.getJobName())) {
                excelVo.setJobName(excelVo.getJobName().trim());
            }
            if (!StringUtils.isNotEmpty((String)excelVo.getLaneName())) continue;
            excelVo.setLaneName(excelVo.getLaneName().trim());
        }
        return excelVoList;
    }

    @PostMapping(value={"/queryImportRecord"})
    public ResponseEntity<BaseResultDTO<PageInfoResp<JobBenchImport>>> queryImportRecord(@RequestBody @Valid QueryImportRecordReq queryImportRecordReq) {
        try {
            if (StringUtils.isNotBlank((String)queryImportRecordReq.getStartTime()) && !DateUtils.validateDate((String)queryImportRecordReq.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss") || StringUtils.isNotBlank((String)queryImportRecordReq.getEndTime()) && !DateUtils.validateDate((String)queryImportRecordReq.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss")) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-illegal"));
            }
            PageInfoResp pageInfoResp = this.jobBenchService.queryImportRecord(queryImportRecordReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)pageInfoResp);
        }
        catch (Exception e) {
            log.error("JobBenchImportController queryImportRecord exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @GetMapping(value={"/exportReport"})
    public void exportReport(HttpServletResponse response) {
        try {
            List excelVoList = this.jobBenchService.exportReport();
            String filename = "\u4f5c\u4e1a\u5de5\u4f5c\u53f0_" + LocalDate.now().toString().replace("-", "") + ".xlsx";
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            response.setHeader("Content-disposition", "attachment;filename=" + new String(filename.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
            ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), JobBenchExportVo.class).registerWriteHandler((WriteHandler)Utils.initHorizontalCell())).sheet("\u4f5c\u4e1a\u5de5\u4f5c\u53f0").relativeHeadRowIndex(Integer.valueOf(1))).registerWriteHandler((WriteHandler)new JobBenchWriteHandler())).doWrite((Collection)excelVoList);
        }
        catch (Exception e) {
            log.error("JobBenchImportController exportReport exception", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

