/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.bench;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.controller.BasicController;
import com.digiwin.athena.semc.dto.message.DeleteMessageConfigReq;
import com.digiwin.athena.semc.dto.message.QueryThirdMessageConfigReq;
import com.digiwin.athena.semc.entity.bench.ThirdJobConfig;
import com.digiwin.athena.semc.service.bench.ThirdJobConfigService;
import com.digiwin.athena.semc.service.menu.AuthService;
import com.digiwin.athena.semc.service.sso.IErpSsoInfoService;
import com.digiwin.athena.semc.service.sso.IThirdSsoInfoService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.SecurityLogUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/third/job"})
public class ThirdJobConfigController
extends BasicController<ThirdJobConfigService, ThirdJobConfig> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThirdJobConfigController.class);
    @Resource
    private ThirdJobConfigService thirdJobConfigService;
    @Autowired
    IErpSsoInfoService erpSsoInfoService;
    @Autowired
    IThirdSsoInfoService thirdSsoInfoService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private AuthService authService;

    @PostMapping(value={"/queryJobConfigPage"})
    public ResponseEntity<BaseResultDTO<PageInfoResp<ThirdJobConfig>>> queryJobConfigPage(@RequestBody @Valid QueryThirdMessageConfigReq queryImportRecordReq) {
        try {
            PageInfoResp pageInfoResp = this.thirdJobConfigService.queryConfigPage(queryImportRecordReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)pageInfoResp);
        }
        catch (Exception e) {
            log.error("query job config error, param:{}", (Object)queryImportRecordReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/third/job/queryJobConfigPage");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/saveApplication"})
    public ResponseEntity<BaseResultDTO<Boolean>> saveApplication(@RequestBody @Valid ThirdJobConfig req, HttpServletRequest request) {
        try {
            boolean flag;
            if (!this.authService.hasAuth("third-work")) {
                SecurityLogUtil.writeSecurityLog((HttpServletRequest)request, (String)JSON.toJSONString((Object)req));
            }
            if (Constants.DataGetTypeEnum.PULL.getFlag().equals(req.getDataGetType())) {
                if (req.getAppAccessModel() == null) {
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"the appAccessModel cannot be null");
                }
                if (Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal().equals(req.getAppAccessModel())) {
                    if (StringUtils.isBlank((String)req.getMiddleSystemName())) {
                        return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"the middleSystemName cannot be null");
                    }
                    if (StringUtils.isBlank((String)req.getMiddleSystemUid())) {
                        return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"the middleSystemUid cannot be null");
                    }
                } else if (StringUtils.isBlank((String)req.getDomain())) {
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"the domain cannot be null");
                }
            }
            if (flag = this.thirdJobConfigService.validJobConfigExist(req)) {
                String error = this.messageUtils.getMessage("error.message.app.repeat");
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
            this.thirdJobConfigService.saveThirdJob(req);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("saveApplication error:{}", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/third/job/saveApplication");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/delJobConfig"})
    public ResponseEntity<BaseResultDTO<Boolean>> delJobConfig(@RequestBody DeleteMessageConfigReq deleteMessageConfigReq) {
        try {
            if (CollectionUtils.isEmpty((Collection)deleteMessageConfigReq.getIdList())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)"idList is not empty");
            }
            this.thirdJobConfigService.delThirdJob(deleteMessageConfigReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("delJobConfig error. e:{}", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/third/job/delJobConfig");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/updateStatus"})
    public ResponseEntity<?> updateStatus(@RequestBody ThirdJobConfig req) {
        try {
            if (null == req.getId()) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)"id is Empty");
            }
            if (null == req.getValidStatus()) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)"validStatus is Empty");
            }
            ThirdJobConfig config = (ThirdJobConfig)this.thirdJobConfigService.getById((Serializable)req.getId());
            config.setValidStatus(req.getValidStatus());
            this.thirdJobConfigService.saveThirdJob(config);
            return ResponseEntityWrapper.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("/semc/third/job/updateStatus error:{}", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/third/job/updateStatus");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

