/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.config;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.semc.dto.config.MobilePortalCacheConfigParam;
import com.digiwin.athena.semc.service.cache.CommonConfigService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/common/config/"})
public class CommonConfigController {
    private final CommonConfigService commonConfigService;
    private final StringRedisTemplate stringRedisTemplate;

    @PostMapping(value={"/setCommonConfig"})
    public ResponseEntity<BaseResultDTO<Boolean>> setCommonConfig(@RequestBody JSONObject req) {
        String key = req.getString("key");
        Object value = req.get("value");
        if (StringUtils.isBlank((CharSequence)key) || value == null) {
            return ResponseEntityWrapperUtil.wrapperOk((Object)Boolean.FALSE);
        }
        String strValue = value instanceof String ? value.toString() : JSON.toJSONString((Object)value);
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.commonConfigService.setCommonConfig(key, strValue));
    }

    @PostMapping(value={"/getCommonConfig"})
    public ResponseEntity<BaseResultDTO<Object>> getCommonConfig(@RequestBody JSONObject req) {
        String dataType = req.getString("dataTyoe");
        String key = req.getString("key");
        if (StringUtils.isBlank((CharSequence)dataType) || "string".equals(dataType)) {
            String value = this.commonConfigService.getCommonConfig(key);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                try {
                    Object object = JSON.parse((String)value);
                    return ResponseEntityWrapperUtil.wrapperOk((Object)object);
                }
                catch (Exception e) {
                    return ResponseEntityWrapperUtil.wrapperOk((Object)value);
                }
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)"");
        }
        if ("set".equals(dataType)) {
            SetOperations setOperations = this.stringRedisTemplate.opsForSet();
            return ResponseEntityWrapperUtil.wrapperOk((Object)setOperations.members((Object)key));
        }
        return ResponseEntityWrapperUtil.wrapperOk((Object)"");
    }

    @PostMapping(value={"/removeCommonConfig"})
    public ResponseEntity<BaseResultDTO<Boolean>> removeCommonConfig(@RequestBody JSONObject req) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.commonConfigService.removeCommonConfig(req.getString("key")));
    }

    @PostMapping(value={"/setMobilePortalCacheConfigParam"})
    public ResponseEntity<BaseResultDTO<Boolean>> setMobilePortalCacheConfigParam(@RequestBody MobilePortalCacheConfigParam req) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.commonConfigService.setMobilePortalCacheConfigParam(req));
    }

    @Generated
    public CommonConfigController(CommonConfigService commonConfigService, StringRedisTemplate stringRedisTemplate) {
        this.commonConfigService = commonConfigService;
        this.stringRedisTemplate = stringRedisTemplate;
    }
}

