/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.device;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.annotate.MenuPermissionAuth;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.enums.FolderTypeEnum;
import com.digiwin.athena.semc.dto.device.DeviceAuthorizeVO;
import com.digiwin.athena.semc.dto.device.DeviceBindExportQueryDTO;
import com.digiwin.athena.semc.dto.device.DeviceBindExportVO;
import com.digiwin.athena.semc.dto.device.DeviceBindImportDTO;
import com.digiwin.athena.semc.dto.device.DeviceBindQueryDTO;
import com.digiwin.athena.semc.dto.device.DeviceBindRecordVO;
import com.digiwin.athena.semc.dto.device.DeviceBindSaveDTO;
import com.digiwin.athena.semc.dto.device.DeviceBindUpdateDTO;
import com.digiwin.athena.semc.dto.device.DeviceBindUpdateStatusDTO;
import com.digiwin.athena.semc.dto.device.DeviceDTO;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.service.device.DeviceBindDataWriteHandler;
import com.digiwin.athena.semc.service.device.DeviceBindHeadWriteHandler;
import com.digiwin.athena.semc.service.device.IDeviceAuthService;
import com.digiwin.athena.semc.service.device.IUserBindDeviceFileService;
import com.digiwin.athena.semc.service.device.IUserBindDeviceService;
import com.digiwin.athena.semc.service.portal.IImportRecordService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.common.ImportRecordResp;
import com.digiwin.athena.semc.vo.portal.ImportExcelResp;
import com.google.common.collect.Lists;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/device/bind"})
public class DeviceBindController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceBindController.class);
    public static final List<String> OS_TYPES = Lists.newArrayList((Object[])new String[]{"Windows", "macOS", "iOS", "Android", "Other"});
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private IUserBindDeviceService iUserBindDeviceService;
    @Resource
    private IDeviceAuthService iDeviceAuthService;
    @Resource
    private IUserBindDeviceFileService iUserBindDeviceFileService;
    @Resource
    private IImportRecordService importRecordService;

    @PostMapping(value={"/list"})
    public ResponseEntity<BaseResultDTO<PageInfoResp<DeviceBindRecordVO>>> list(@RequestBody DeviceBindQueryDTO request) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.iUserBindDeviceService.list(request));
    }

    @MenuPermissionAuth(code="account-device-bind")
    @PostMapping(value={"/save"})
    public ResponseEntity<BaseResultDTO<DeviceBindRecordVO>> save(@Valid @RequestBody DeviceBindSaveDTO record) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.iUserBindDeviceService.save(record));
    }

    @MenuPermissionAuth(code="account-device-bind")
    @PostMapping(value={"/update"})
    public ResponseEntity<BaseResultDTO<DeviceBindRecordVO>> update(@Valid @RequestBody DeviceBindUpdateDTO update) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.iUserBindDeviceService.update(update));
    }

    @MenuPermissionAuth(code="account-device-bind")
    @PostMapping(value={"/updateValidStatus"})
    public ResponseEntity<BaseResultDTO<Boolean>> updateValidStatus(@Valid @RequestBody DeviceBindUpdateStatusDTO update) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.iUserBindDeviceService.updateValidStatus(update));
    }

    @MenuPermissionAuth(code="account-device-bind")
    @PostMapping(value={"/delete"})
    public ResponseEntity<BaseResultDTO<Boolean>> delete(@RequestBody List<Long> ids) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.iUserBindDeviceService.delete(ids));
    }

    @MenuPermissionAuth(code="account-device-bind")
    @PostMapping(value={"/importReport"})
    public ResponseEntity<BaseResultDTO<ImportExcelResp>> importRecords(@RequestBody DeviceBindImportDTO req) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.iUserBindDeviceFileService.importRecords(req));
    }

    @PostMapping(value={"/exportReport"})
    public void exportReport(HttpServletResponse response, @RequestBody DeviceBindExportQueryDTO req) {
        try {
            List deviceBindRecords = this.iUserBindDeviceService.exportReport(req);
            String filename = "\u8bbe\u5907\u7ed1\u5b9a\u914d\u7f6e_" + LocalDate.now().toString().replace("-", "") + ".xlsx";
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            response.setHeader("Content-disposition", "attachment;filename=" + new String(filename.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
            ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), DeviceBindExportVO.class).sheet("\u8bbe\u5907\u7ed1\u5b9a\u914d\u7f6e").registerWriteHandler((WriteHandler)new DeviceBindHeadWriteHandler())).relativeHeadRowIndex(Integer.valueOf(1))).registerWriteHandler((WriteHandler)Utils.initHorizontalCell())).registerWriteHandler((WriteHandler)new DeviceBindDataWriteHandler())).doWrite((Collection)deviceBindRecords);
        }
        catch (Exception e) {
            log.error("FineReporterController export report excel exception", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @PostMapping(value={"/queryImportRecord"})
    public ResponseEntity<BaseResultDTO<PageInfoResp<ImportRecordResp>>> queryImportRecord(@RequestBody @Valid QueryImportRecordReq queryImportRecordReq) {
        try {
            if (StringUtils.isNotBlank((String)queryImportRecordReq.getStartTime()) && !DateUtils.validateDate((String)queryImportRecordReq.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss") || StringUtils.isNotBlank((String)queryImportRecordReq.getEndTime()) && !DateUtils.validateDate((String)queryImportRecordReq.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss")) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-illegal"));
            }
            PageInfoResp pageInfoResp = this.importRecordService.queryImportRecord(queryImportRecordReq, FolderTypeEnum.DEVICE_REPORT.getValue());
            return ResponseEntityWrapperUtil.wrapperOk((Object)pageInfoResp);
        }
        catch (Exception e) {
            log.error("DeviceBindImportRecordController queryImportRecord  exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @GetMapping(value={"/query"})
    public ResponseEntity<BaseResultDTO<List<DeviceBindRecordVO>>> query() {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.iUserBindDeviceService.queryUserDevice());
    }

    @PostMapping(value={"/authorize"})
    public ResponseEntity<BaseResultDTO<DeviceAuthorizeVO>> authorize(@RequestBody @Validated DeviceDTO device) {
        Pair check = this.check(device);
        if (Objects.nonNull(check)) {
            return ResponseEntityWrapperUtil.wrapperFail((int)((Integer)check.getKey()), (String)((String)check.getRight()));
        }
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.iDeviceAuthService.authorize(device));
    }

    @PostMapping(value={"/auto"})
    public ResponseEntity<BaseResultDTO<Boolean>> autoBind(@RequestBody @Validated DeviceDTO device) {
        Pair check = this.check(device);
        if (Objects.nonNull(check)) {
            return ResponseEntityWrapperUtil.wrapperFail((int)((Integer)check.getKey()), (String)((String)check.getRight()));
        }
        Boolean autoBind = this.iDeviceAuthService.autoBind(device);
        if (BooleanUtils.isTrue((Boolean)autoBind)) {
            return ResponseEntityWrapperUtil.wrapperOk((Object)autoBind);
        }
        return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
    }

    public Pair<Integer, String> check(DeviceDTO device) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)device.getHardwareUuid()) && device.getHardwareUuid().length() > 255) {
            device.setHardwareUuid(null);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)device.getMacAddress()) && device.getMacAddress().length() > 255) {
            device.setDeviceModel(null);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)device.getOsType()) && !OS_TYPES.contains(device.getOsType())) {
            device.setOsType(null);
        }
        return null;
    }
}

