/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.event;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.dto.event.EventTrackingReq;
import com.digiwin.athena.semc.dto.event.PageQueryEventTrackingDTO;
import com.digiwin.athena.semc.service.event.EventTrackingService;
import com.digiwin.athena.semc.service.portal.impl.SystemCustomWriteHandler;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.event.PageQueryEventTrackingVO;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/event"})
public class EventTrackingController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventTrackingController.class);
    private static final Logger logger = LoggerFactory.getLogger(EventTrackingController.class);
    @Resource
    private EventTrackingService eventTrackingService;
    @Resource
    private MessageUtils messageUtils;

    @PostMapping(value={"/saveTracking"})
    public ResponseEntity<?> saveTracking(@RequestBody EventTrackingReq req) {
        ResponseEntity responseEntity = ResponseEntityWrapperUtil.wrapperOk((Object)0);
        try {
            List eventCodes;
            if (req == null || req.getTs() == null && req.getCommon() == null && req.getUser() == null && req.getEvents() == null) {
                ((BaseResultDTO)responseEntity.getBody()).setErrorMessage((Object)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                return responseEntity;
            }
            if (StringUtils.isBlank((CharSequence)req.getTs())) {
                ((BaseResultDTO)responseEntity.getBody()).setErrorMessage((Object)"\u4e8b\u4ef6\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
                return responseEntity;
            }
            if (StringUtils.isNotBlank((CharSequence)req.getTs()) && !DateUtils.validateDate((String)req.getTs(), (String)"yyyy-MM-dd HH:mm:ss")) {
                ((BaseResultDTO)responseEntity.getBody()).setErrorMessage((Object)"\u4e8b\u4ef6\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
                return responseEntity;
            }
            if (CollectionUtils.isEmpty((Collection)req.getEvents())) {
                ((BaseResultDTO)responseEntity.getBody()).setErrorMessage((Object)"\u4e8b\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
                return responseEntity;
            }
            if (CollectionUtils.isNotEmpty((Collection)req.getEvents()) && CollectionUtils.isNotEmpty(eventCodes = req.getEvents().stream().filter(x -> StringUtils.isBlank((CharSequence)x.getEventCode())).collect(Collectors.toList()))) {
                ((BaseResultDTO)responseEntity.getBody()).setErrorMessage((Object)"\u4e8b\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a");
                return responseEntity;
            }
            ((BaseResultDTO)responseEntity.getBody()).setResponse((Object)this.eventTrackingService.saveTracking(req));
        }
        catch (Exception e) {
            logger.error("saveTracking exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/saveTracking");
            ((BaseResultDTO)responseEntity.getBody()).setErrorMessage((Object)error);
        }
        return responseEntity;
    }

    @PostMapping(value={"pageQuery"})
    public ResponseEntity<BaseResultDTO<PageInfoResp<PageQueryEventTrackingVO>>> pageQuery(@RequestBody PageQueryEventTrackingDTO pageQueryEventTrackingDTO) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.eventTrackingService.pageQuery(pageQueryEventTrackingDTO));
    }

    @PostMapping(value={"exportReport"})
    public void exportReport(@RequestBody PageQueryEventTrackingDTO pageQueryEventTrackingDTO, HttpServletResponse response) throws IOException {
        List pageQueryEventTrackingVOList = this.eventTrackingService.exportReport(pageQueryEventTrackingDTO);
        String fileName = "\u7528\u6237\u65e5\u5fd7_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) + ".xlsx";
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-disposition", "attachment;filename=" + new String(fileName.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
        ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), PageQueryEventTrackingVO.class).registerWriteHandler((WriteHandler)Utils.initHorizontalCell())).sheet("\u7528\u6237\u65e5\u5fd7").relativeHeadRowIndex(Integer.valueOf(1))).registerWriteHandler((WriteHandler)new SystemCustomWriteHandler())).doWrite((Collection)pageQueryEventTrackingVOList);
    }
}

