/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.fineReport;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.BizException;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.ServiceException;
import com.digiwin.athena.semc.dto.fineReport.FineReportConfigDTO;
import com.digiwin.athena.semc.dto.fineReport.SaveFineReportUserMappingConfigReq;
import com.digiwin.athena.semc.dto.portal.FineReportQueryReq;
import com.digiwin.athena.semc.entity.fineReport.FineReportUserMapping;
import com.digiwin.athena.semc.service.fineReport.FineReportManageService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import io.github.linpeilie.Converter;
import java.io.Serializable;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/tripartite/fineReport"})
public class FineReportManageController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FineReportManageController.class);
    @Resource
    private FineReportManageService fineReportManageService;
    @Resource
    private Converter converter;
    @Resource
    private MessageUtils messageUtils;

    @PostMapping(value={"/saveFineReportConfig"})
    public ResponseEntity<?> saveFineReportConfig(@RequestBody @Valid FineReportConfigDTO fineReportConfigDTO) {
        this.fineReportManageService.saveFineReportConfig(fineReportConfigDTO);
        return ResponseEntityWrapperUtil.wrapperOk((Object)true);
    }

    @PostMapping(value={"/queryUserMappingList"})
    public ResultPageBean queryUserMappingList(@Valid @RequestBody FineReportQueryReq req) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        try {
            return this.fineReportManageService.queryUserMappings(tenantId, req);
        }
        catch (BizException bizException) {
            return ResultPageBean.bizException((BizException)BizException.getDefaultBizException((Integer)ErrorCodeConstant.ADAPT_SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.report.open-error")));
        }
        catch (Exception e) {
            log.error("/semc/fineReport/pageQuery exception", (Throwable)e);
            ResultPageBean resultPageBean = ResultPageBean.sysException((ServiceException)new ServiceException(ErrorCodeConstant.SYSTEM_ERROR, this.messageUtils.getMessage("error.message.common.system-error")));
            return resultPageBean;
        }
    }

    @PostMapping(value={"/saveUserMapping"})
    public ResponseEntity<?> saveUserMapping(@RequestBody @Valid SaveFineReportUserMappingConfigReq req) {
        try {
            FineReportUserMapping fineReportUserMapping = (FineReportUserMapping)this.converter.convert((Object)req, FineReportUserMapping.class);
            String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
            fineReportUserMapping.setTenantId(tenantId);
            FineReportUserMapping result = this.fineReportManageService.saveUserMapping(fineReportUserMapping);
            return ResponseEntityWrapperUtil.wrapperOk((Object)result);
        }
        catch (Exception e) {
            log.error("/semc/fineReport/saveUserMapping exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)e.getMessage());
        }
    }

    @GetMapping(value={"/userMapping/{id}"})
    public ResponseEntity<?> queryUserMappingDetail(@PathVariable Long id) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.fineReportManageService.getById((Serializable)id));
    }

    @DeleteMapping(value={"/userMapping/{id}"})
    public ResponseEntity<?> deleteUserMapping(@PathVariable Long id) {
        try {
            this.fineReportManageService.deleteUserMapping(id);
            return ResponseEntityWrapperUtil.wrapperOk();
        }
        catch (Exception e) {
            log.error("delete /semc/fineReport/userMapping exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)e.getMessage());
        }
    }

    @GetMapping(value={"/queryAthenaUserList"})
    public ResponseEntity<?> queryAthenaUserList() {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.fineReportManageService.queryAthenaUserList());
    }

    @GetMapping(value={"/queryFrUser/{frUserId}"})
    public ResponseEntity<?> queryFrUser(@PathVariable String frUserId) {
        long count = this.fineReportManageService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FineReportUserMapping::getFrUserId, (Object)frUserId)).eq(FineReportUserMapping::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId()));
        return ResponseEntityWrapperUtil.wrapperOk((Object)count);
    }
}

