/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.homepage.upgrade;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.dto.homepage.AdvertisementDTO;
import com.digiwin.athena.semc.dto.homepage.ReadAdvertisementReq;
import com.digiwin.athena.semc.entity.homepage.ReadAdvertisement;
import com.digiwin.athena.semc.service.homepage.IAdvertisementService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import io.swagger.v3.oas.annotations.Operation;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/advertisement"})
public class AdvertisementController {
    private static final Logger logger = LoggerFactory.getLogger(AdvertisementController.class);
    @Autowired
    IAdvertisementService advertisementService;
    @Resource
    private MessageUtils messageUtils;
    public static final String AD_IMPORTANT_FLAG = "important";

    @Operation(summary="\u67e5\u8be2\u672a\u8bfb\u6570\u91cf")
    @GetMapping(value={"/queryUnreadCount"})
    public ResponseEntity<BaseResultDTO<JSONObject>> queryUnreadCount(@RequestParam String accessToken) {
        try {
            List advertisementDTOList = this.advertisementService.queryAdListFromEs(accessToken);
            long unReadCount = advertisementDTOList.stream().filter(x -> Boolean.FALSE.equals(x.getReadStatus())).count();
            long importUnReadCount = advertisementDTOList.stream().filter(x -> AD_IMPORTANT_FLAG.equals(x.getTriggerEvent()) && Boolean.FALSE.equals(x.getReadStatus())).count();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("unRead", (Object)unReadCount);
            jsonObject.put("importUnRead", (Object)importUnReadCount);
            return ResponseEntityWrapperUtil.wrapperOk((Object)jsonObject);
        }
        catch (Exception e) {
            logger.error("AdvertisementController | query unread count occur error. accessToken:{}", (Object)accessToken, (Object)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @Operation(summary="\u67e5\u8be2\u5e7f\u544a\u5217\u8868")
    @GetMapping(value={"/queryAdList"})
    public ResponseEntity<BaseResultDTO<List<AdvertisementDTO>>> queryAdList(@RequestParam String accessToken) {
        try {
            List advertisementDTOList = this.advertisementService.queryAdListFromEs(accessToken);
            return ResponseEntityWrapperUtil.wrapperOk((Object)advertisementDTOList);
        }
        catch (Exception e) {
            logger.error("AdvertisementController | query advertisement list occur error. accessToken:{}", (Object)accessToken, (Object)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @Operation(summary="\u8bb0\u5f55\u9605\u8bfb\u7684\u5e7f\u544a")
    @PostMapping(value={"/readAdNotice"})
    public ResponseEntity<BaseResultDTO<Boolean>> readAdNotice(@RequestBody @Valid ReadAdvertisementReq readAdvertisementReq) {
        try {
            if (!Arrays.asList(Constants.ReadAdPlatformEnum.ENTRANCE.getFlag(), Constants.ReadAdPlatformEnum.TBB.getFlag()).contains(readAdvertisementReq.getReadPlatform())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-illegal"));
            }
            Boolean readFlag = this.advertisementService.insertAdReadRecord(readAdvertisementReq);
            if (!readFlag.booleanValue()) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.UPDATE_FAILED, (String)this.messageUtils.getMessage("error.message.common.update-error"));
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)readFlag);
        }
        catch (Exception e) {
            logger.error("AdvertisementController | read advertisement occur error. param:{}", (Object)readAdvertisementReq, (Object)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @Operation(summary="\u67e5\u8be2\u5df2\u8bfb\u7684\u5e7f\u544a\u5217\u8868")
    @GetMapping(value={"/queryReadList"})
    public ResponseEntity<BaseResultDTO<List<ReadAdvertisement>>> queryReadList() {
        try {
            List readAdvertisementList = this.advertisementService.queryReadList();
            return ResponseEntityWrapperUtil.wrapperOk((Object)readAdvertisementList);
        }
        catch (Exception e) {
            logger.error("AdvertisementController | query read list occur error.", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }
}

