/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.homepage.upgrade;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.entity.homepage.BackGroundLogo;
import com.digiwin.athena.semc.service.homepage.IBackGroundLogoService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import io.swagger.v3.oas.annotations.Operation;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/background/"})
public class BackGroundLogoController {
    private static final Logger logger = LoggerFactory.getLogger(BackGroundLogoController.class);
    @Autowired
    IBackGroundLogoService backGroundLogoService;
    @Resource
    private MessageUtils messageUtils;

    @Operation(summary="\u83b7\u53d6\u79df\u6237\u9996\u9875\u80cc\u666f\u56fe\u63a5\u53e3")
    @PostMapping(value={"/image/getImage"})
    public ResponseEntity<BaseResultDTO<BackGroundLogo>> getImage() {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.backGroundLogoService.getBackGroundLogo());
        }
        catch (Exception e) {
            logger.error("getImage exceptiona", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/background/image/getImage");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(summary="\u4fdd\u5b58\u80cc\u666f\u56fe")
    @PostMapping(value={"/image/saveImage"})
    public ResponseEntity<BaseResultDTO<BackGroundLogo>> saveImage(@RequestBody BackGroundLogo req) {
        try {
            if (req.getImgType() == null) {
                req.setImgType(Integer.valueOf(1));
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.backGroundLogoService.saveBackGroundLogo(req));
        }
        catch (Exception e) {
            logger.error("saveImage exceptiona", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/background/image/saveImage");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

