/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.homepage.upgrade;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.common.ResultBean;
import com.digiwin.athena.semc.dto.homepage.HomeSearchReq;
import com.digiwin.athena.semc.service.homepage.IHomeSearchService;
import io.swagger.v3.oas.annotations.Operation;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tenant/semc/"})
public class HomeSearchController {
    private static final Logger logger = LoggerFactory.getLogger(HomeSearchController.class);
    @Autowired
    IHomeSearchService homeSearchService;

    @Operation(summary="\u9996\u9875\u641c\u7d22")
    @PostMapping(value={"/search/result"})
    public ResultBean homeSearch(@RequestBody HomeSearchReq homeSearchReq) {
        logger.info("search result param:" + JSON.toJSONString((Object)homeSearchReq));
        ResultBean resultBean = new ResultBean();
        List homeSearchDTOList = new ArrayList();
        resultBean.setResponse(homeSearchDTOList);
        if (StringUtils.isNotEmpty((String)homeSearchReq.getName())) {
            homeSearchReq.setName(homeSearchReq.getName().trim());
        }
        if (StringUtils.isEmpty((String)homeSearchReq.getName())) {
            return resultBean;
        }
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        if (null == user) {
            return resultBean;
        }
        try {
            homeSearchDTOList = this.homeSearchService.searchResult(homeSearchReq, user);
            resultBean.setResponse(homeSearchDTOList);
            return resultBean;
        }
        catch (Exception e) {
            logger.error("search result  error homeSearch:{}, userId:{}", new Object[]{JSON.toJSONString((Object)homeSearchReq), user.getTenantId(), e});
            return resultBean;
        }
    }

    @Operation(summary="\u83b7\u53d6KBS\u6587\u4ef6\u8be6\u60c5\u4fe1\u606f")
    @PostMapping(value={"/file/detail"})
    public ResultBean getKbsFileDetail(@RequestBody HomeSearchReq homeSearchReq) {
        logger.info("getKbsFileDetail param:" + JSON.toJSONString((Object)homeSearchReq));
        ResultBean resultBean = new ResultBean();
        JSONObject fileDTOList = new JSONObject();
        resultBean.setResponse((Object)fileDTOList);
        if (StringUtils.isEmpty((String)homeSearchReq.getFileId())) {
            return resultBean;
        }
        try {
            fileDTOList = this.homeSearchService.getKbsFileDetail(homeSearchReq.getFileId());
            resultBean.setResponse((Object)fileDTOList);
            return resultBean;
        }
        catch (Exception e) {
            logger.error("getKbsFileDetail  error req:{}, e:{}", (Object)JSON.toJSONString((Object)homeSearchReq), (Object)e);
            return resultBean;
        }
    }
}

