/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.homepage.upgrade;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.dto.homepage.UpgradeInfoReminderDTO;
import com.digiwin.athena.semc.service.cache.ICacheService;
import com.digiwin.athena.semc.service.homepage.IUpgradeInfoService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.homepage.UpgradeInfoDetailResp;
import com.digiwin.athena.semc.vo.homepage.UpgradeInfoResp;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.constraints.NotEmpty;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/homepage/upgrade"})
public class UpgradeInfoController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpgradeInfoController.class);
    @Resource
    private IUpgradeInfoService upgradeInfoService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private ICacheService cacheService;

    @GetMapping(value={"/reminder"})
    public ResponseEntity<BaseResultDTO<List<UpgradeInfoReminderDTO>>> reminder(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.upgradeInfoService.getReminder());
        }
        catch (Exception e) {
            log.error("UpgradeInfoController reminder error", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @PostMapping(value={"/closeImptReminder"})
    public ResponseEntity<?> closeImptReminder(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        this.upgradeInfoService.closeImptReminder();
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/closeUpgradeReminder"})
    public ResponseEntity<?> closeUpgradeReminder(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        this.upgradeInfoService.closeUpgradeReminder();
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/closeUpgradeStrongReminder"})
    public ResponseEntity<?> closeUpgradeStrongReminder(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        this.upgradeInfoService.closeUpgradeStrongReminder();
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/list"})
    public ResponseEntity<BaseResultDTO<List<UpgradeInfoResp>>> list() {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.upgradeInfoService.queryUpgradeInfoList());
        }
        catch (Exception e) {
            log.error("UpgradeInfoController query upgrade info list error", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @GetMapping(value={"/detail/{id}"})
    public ResponseEntity<BaseResultDTO<UpgradeInfoDetailResp>> detail(@PathVariable(value="id") @NotEmpty(message="\u7248\u66f4id\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u7248\u66f4id\u4e0d\u80fd\u4e3a\u7a7a") String id) {
        try {
            UpgradeInfoDetailResp upgradeInfoDetailResp = this.upgradeInfoService.queryUpgradeDetail(id);
            return ResponseEntityWrapperUtil.wrapperOk((Object)upgradeInfoDetailResp);
        }
        catch (Exception e) {
            log.error("UpgradeInfoController detail occur error, id:{}", (Object)id, (Object)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @GetMapping(value={"/deleteCache/{key}"})
    public ResponseEntity<?> deleteCache(@PathVariable(value="key") @NotEmpty(message="\u5220\u9664\u7f13\u5b58\u7684key\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u5220\u9664\u7f13\u5b58\u7684key\u4e0d\u80fd\u4e3a\u7a7a") String key) {
        try {
            this.cacheService.delete(key);
            this.cacheService.deleteByPrex(key);
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            log.error("UpgradeInfoController closeImptReminder error", (Throwable)e);
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }
}

