/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.homepage.upgrade;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.dto.homepage.SaveTenantPortalReq;
import com.digiwin.athena.semc.dto.homepage.SaveUserPortalReq;
import com.digiwin.athena.semc.entity.homepage.TenantPortalRecord;
import com.digiwin.athena.semc.entity.homepage.UserPortalRecord;
import com.digiwin.athena.semc.service.homepage.IUserPortalService;
import com.digiwin.athena.semc.service.homepage.TenantPortalRecordService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import io.swagger.v3.oas.annotations.Operation;
import java.time.LocalDateTime;
import java.util.Arrays;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/portal"})
public class UserPortalController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserPortalController.class);
    private static final Logger logger = LoggerFactory.getLogger(UserPortalController.class);
    @Autowired
    IUserPortalService userPortalService;
    @Resource
    private TenantPortalRecordService tenantPortalRecordService;
    @Resource
    private MessageUtils messageUtils;

    @Operation(summary="\u4fdd\u5b58\u5207\u6362\u7684\u95e8\u6237\u7c7b\u578b")
    @PostMapping(value={"/saveLatest"})
    public ResponseEntity<BaseResultDTO<Long>> saveLatestPortal(@RequestBody SaveUserPortalReq saveUserPortalReq) {
        logger.info("saveLatest param:" + JSONObject.toJSONString((Object)saveUserPortalReq));
        if (saveUserPortalReq.getPortalType() == null) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-missing"));
        }
        if (!Arrays.asList(Constants.PortalTypeEnum.SIMPLE.getFlag(), Constants.PortalTypeEnum.CONVENTIONAL.getFlag()).contains(saveUserPortalReq.getPortalType())) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-illegal"));
        }
        try {
            Long id = this.userPortalService.saveLatestUserPortal(saveUserPortalReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)id);
        }
        catch (Exception e) {
            logger.error("save latest portal type error. saveUserPortalReq:{},e:{}", (Object)saveUserPortalReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/portal/saveLatest, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(summary="\u67e5\u8be2\u7528\u6237\u5f53\u524d\u4f7f\u7528\u7684\u95e8\u6237\u7c7b\u578b")
    @GetMapping(value={"/queryLatest"})
    public ResponseEntity<BaseResultDTO<UserPortalRecord>> queryLatestPortal() {
        try {
            TenantPortalRecord tenantPortalRecord = this.tenantPortalRecordService.queryTenantPortal();
            if (tenantPortalRecord == null || Constants.USE_LATEST_FLAG_YES.equals(tenantPortalRecord.getUseLatestFlag())) {
                UserPortalRecord userPortalRecord = this.userPortalService.queryLatestUserPortal();
                return ResponseEntityWrapperUtil.wrapperOk((Object)userPortalRecord);
            }
            UserPortalRecord userPortalRecord = new UserPortalRecord();
            userPortalRecord.setPortalType(tenantPortalRecord.getPortalType());
            return ResponseEntityWrapperUtil.wrapperOk((Object)userPortalRecord);
        }
        catch (Exception e) {
            logger.error("query latest portal type error.", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/portal/queryLatest, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/tenant/queryTenantPortal"})
    public ResponseEntity<BaseResultDTO<TenantPortalRecord>> queryTenantPortal() {
        try {
            TenantPortalRecord tenantPortalRecord = this.tenantPortalRecordService.queryTenantPortal();
            return ResponseEntityWrapperUtil.wrapperOk((Object)tenantPortalRecord);
        }
        catch (Exception e) {
            logger.error("query tenant portal error.", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/tenant/portal/queryTenantPortal, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/tenant/saveTenantPortal"})
    public ResponseEntity<BaseResultDTO<Boolean>> saveTenantPortal(@RequestBody @Valid SaveTenantPortalReq saveTenantPortalReq) {
        try {
            this.tenantPortalRecordService.saveTenantPortal(saveTenantPortalReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            logger.error("save tenant portal error.", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/tenant/portal/saveTenantPortalReq, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

