/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.machine;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.entity.common.CompanyFactory;
import com.digiwin.athena.semc.entity.machine.UserCompanyFactory;
import com.digiwin.athena.semc.service.portal.CloudNavigationService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/cloudNavigation"})
public class CloudNavigationController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudNavigationController.class);
    private static final Logger logger = LoggerFactory.getLogger(CloudNavigationController.class);
    @Resource
    private CloudNavigationService cloudNavigationService;
    @Resource
    private MessageUtils messageUtils;

    @PostMapping(value={"/getCompanyFactoryList"})
    public ResponseEntity<BaseResultDTO<List<UserCompanyFactory>>> getCompanyFactoryList() {
        List response = this.cloudNavigationService.getCompanyFactoryList2();
        return ResponseEntityWrapperUtil.wrapperOk((Object)response);
    }

    @PostMapping(value={"/saveOrUpdateCompanyFactory"})
    public ResponseEntity<?> saveOrUpdateCompanyOrFactory(@RequestBody CompanyFactory companyFactoryVO) {
        if (!StringUtils.hasText((String)companyFactoryVO.getFactory())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"\u516c\u53f8\u522b\u4e0d\u53ef\u4e3a\u7a7a");
        }
        try {
            this.cloudNavigationService.saveOrUpdateCompanyOrFactory(companyFactoryVO);
        }
        catch (Exception e) {
            logger.error("/saveOrUpdateCompanyFactory exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/cloudNavigation/saveOrUpdateCompanyFactory");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
        return ResponseEntityWrapper.wrapperOk();
    }
}

