/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.machine;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.entity.mobile.MobileDatasourcePreset;
import com.digiwin.athena.semc.service.machine.TopicPresetService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.machine.TopicPresetJobResp;
import com.digiwin.athena.semc.vo.machine.TopicPresetResp;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/topic/"})
public class TopicPresetController {
    private static final Logger logger = LoggerFactory.getLogger(TopicPresetController.class);
    @Autowired
    TopicPresetService topicPresetService;
    @Resource
    private MessageUtils messageUtils;

    @PostMapping(value={"/queryUserAuth"})
    public ResponseEntity<BaseResultDTO<TopicPresetResp>> queryUserAuth() {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.topicPresetService.queryUserAuth());
        }
        catch (Exception e) {
            logger.error("queryUserAuth exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/topic/queryUserAuth");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/job/queryAllJob"})
    public ResponseEntity<BaseResultDTO<List<TopicPresetResp>>> queryAllJob(@RequestBody TopicPresetJobResp topicPresetJobResp) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.topicPresetService.queryAllJob(topicPresetJobResp.getCaseIdList()));
        }
        catch (Exception e) {
            logger.error("queryAllJob exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/topic/job/queryAllJob");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/initPresetData"})
    public ResponseEntity<BaseResultDTO<Integer>> initPresetData(@RequestBody MobileDatasourcePreset req) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.topicPresetService.initPresetData(req.getTenantId()));
        }
        catch (Exception e) {
            logger.error("initPresetData exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/topic/job/queryAllJob");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

