/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.menu;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.ServiceException;
import com.digiwin.athena.semc.dto.menu.DeleteMenuTemplateReq;
import com.digiwin.athena.semc.dto.menu.QueryMenuTemplateReq;
import com.digiwin.athena.semc.dto.menu.UpdateMenuTemplateReq;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuTemplate;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.service.menu.CustomizedMenuTemplateService;
import com.digiwin.athena.semc.service.portal.PortalInfoService;
import com.digiwin.athena.semc.service.tenant.TenantAppService;
import com.digiwin.athena.semc.service.workbench.constant.PublishSourceEnum;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.portal.PortalUserAuthResp;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/customized/template"})
public class CustomizedMenuTemplateController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomizedMenuTemplateController.class);
    @Resource
    private CustomizedMenuTemplateService customizedMenuTemplateService;
    @Resource
    private PortalInfoService portalInfoService;
    @Resource
    private TenantAppService tenantAppService;
    @Resource
    private MessageUtils messageUtils;

    @PostMapping(value={"/queryMenuTemplateList"})
    public ResponseEntity<BaseResultDTO<PageInfoResp<CustomizedMenuTemplate>>> queryMenuTemplateList(@RequestBody @Valid QueryMenuTemplateReq queryMenuTemplateReq) {
        try {
            PageInfoResp templateRespList = this.customizedMenuTemplateService.queryMenuTemplateList(queryMenuTemplateReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)templateRespList);
        }
        catch (Exception e) {
            log.error("CustomizedMenuTemplateController query menu template list error. param:{}", (Object)queryMenuTemplateReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/customized/template/queryMenuTemplateList, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/updateTemplateStatus"})
    public ResponseEntity<BaseResultDTO<Boolean>> updateMenuTemplateStatus(@RequestBody @Valid UpdateMenuTemplateReq updateMenuTemplateReq) {
        try {
            if (CollectionUtils.isEmpty((Collection)updateMenuTemplateReq.getIdList())) {
                return ResponseEntityWrapperUtil.wrapperOk((Object)true);
            }
            String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
            boolean isOnlyAsa = this.tenantAppService.isOnlyAsaSalesPlan(tenantId);
            if (Constants.VALID_STATUS_UNUSABLE.equals(updateMenuTemplateReq.getTemplateStatus()) && !isOnlyAsa) {
                if (updateMenuTemplateReq.getIdList().size() == Constants.NUMBER_ONE.intValue()) {
                    if (this.queryPortalByMenuTempId(updateMenuTemplateReq.getIdList())) {
                        return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.template.not.cancel"));
                    }
                } else if (this.queryPortalByMenuTempId(updateMenuTemplateReq.getIdList())) {
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.template.not.cancel.batch"));
                }
            }
            if (isOnlyAsa && Constants.VALID_STATUS_ENABLE.equals(updateMenuTemplateReq.getTemplateStatus())) {
                this.customizedMenuTemplateService.unusableOtherTemplate(updateMenuTemplateReq, tenantId);
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.customizedMenuTemplateService.updateStatus(updateMenuTemplateReq));
        }
        catch (Exception e) {
            log.error("CustomizedMenuTemplateController update menu template status error. param:{}", (Object)updateMenuTemplateReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/customized/template/updateMenuTemplateStatus, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/deleteMenuTemplate"})
    public ResponseEntity<BaseResultDTO<Boolean>> deleteTemplate(@RequestBody DeleteMenuTemplateReq deleteMenuTemplateReq) {
        try {
            if (CollectionUtils.isEmpty((Collection)deleteMenuTemplateReq.getIdList())) {
                return ResponseEntityWrapperUtil.wrapperOk((Object)true);
            }
            Optional<CustomizedMenuTemplate> optional = this.customizedMenuTemplateService.queryTemplateByIds(deleteMenuTemplateReq.getIdList()).stream().filter(template -> PublishSourceEnum.ISV.name().equals(template.getPublishSource())).findAny();
            if (optional.isPresent()) {
                String error = this.messageUtils.getMessage("error.unsupported.edit.isv.menu");
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
            String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
            boolean isOnlyAsa = this.tenantAppService.isOnlyAsaSalesPlan(tenantId);
            if (!isOnlyAsa) {
                if (deleteMenuTemplateReq.getIdList().size() == Constants.NUMBER_ONE.intValue()) {
                    if (this.queryPortalByMenuTempId(deleteMenuTemplateReq.getIdList())) {
                        return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.template.not.delete"));
                    }
                } else if (this.queryPortalByMenuTempId(deleteMenuTemplateReq.getIdList())) {
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.template.not.delete.batch"));
                }
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.customizedMenuTemplateService.deleteTemplateById(deleteMenuTemplateReq));
        }
        catch (Exception e) {
            log.error("CustomizedMenuTemplateController delete menu template error. param:{}", (Object)deleteMenuTemplateReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/customized/template/deleteMenuTemplate, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    private boolean queryPortalByMenuTempId(List<Long> menuTempIdList) {
        List portalInfoList = this.portalInfoService.queryPortalByMenuTempId(menuTempIdList);
        if (CollectionUtils.isNotEmpty((Collection)portalInfoList)) {
            List idList = portalInfoList.stream().map(PortalInfo::getMenuTemplateId).distinct().collect(Collectors.toList());
            return menuTempIdList.size() == idList.size();
        }
        return false;
    }

    @PostMapping(value={"/queryPortalTempList"})
    public ResultPageBean queryPortalTempList(@RequestBody @Valid QueryMenuTemplateReq queryMenuTemplateReq) {
        try {
            Long portalMenuTempId = null;
            if (ObjectUtils.isNotEmpty((Object)queryMenuTemplateReq.getPortalId())) {
                PortalInfo tempPortal = this.portalInfoService.getTempPortal(queryMenuTemplateReq.getPortalId());
                if (ObjectUtils.isEmpty((Object)tempPortal)) {
                    return ResultPageBean.sysException((ServiceException)new ServiceException(ErrorCodeConstant.PARAM_MISSING_ERROR, "portal is not exist"));
                }
                portalMenuTempId = tempPortal.getMenuTemplateId();
            }
            return this.customizedMenuTemplateService.queryPortalTempList(queryMenuTemplateReq, portalMenuTempId);
        }
        catch (Exception e) {
            log.error("CustomizedMenuTemplateController query portal temp list error. param:{}", (Object)queryMenuTemplateReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/customized/template/queryPortalTemplateList, message:" + e.getMessage());
            return ResultPageBean.sysException((ServiceException)new ServiceException(ErrorCodeConstant.SYSTEM_ERROR, error));
        }
    }

    @PostMapping(value={"/validMenuTempName"})
    public ResponseEntity<BaseResultDTO<Boolean>> validMenuTempName(@RequestBody Map<String, String> map) {
        String templateName = map.get("templateName");
        try {
            if (StringUtils.isBlank((String)templateName)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"templateName can not be null");
            }
            Boolean existFlag = this.customizedMenuTemplateService.validExist(null, templateName);
            return ResponseEntityWrapperUtil.wrapperOk((Object)existFlag);
        }
        catch (Exception e) {
            log.error("CustomizedMenuWorkController valid menu temp name error. templateName:{}", (Object)templateName, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/customized/menu/validMenuTempName, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @GetMapping(value={"/queryUserMenuFlag"})
    public ResponseEntity<BaseResultDTO<Integer>> queryUserMenuFlag() {
        try {
            List portalUserAuthRespList = this.portalInfoService.selectUserPortal(Constants.ClientTypeEnum.PC.getValue());
            List portalUserList = portalUserAuthRespList.stream().filter(x -> Boolean.TRUE.equals(x.getIsRecently())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(portalUserList)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.use.portal.recovery"));
            }
            Long menuTemplateId = ((PortalUserAuthResp)portalUserList.get(0)).getMenuTemplateId();
            if (Constants.GENERAL_MENU_TEMPLATE_ID.equals(menuTemplateId)) {
                return ResponseEntityWrapperUtil.wrapperOk((Object)Constants.GENERAL_MENU_FLAG_YES);
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)Constants.GENERAL_MENU_FLAG_NO);
        }
        catch (Exception e) {
            log.error("CustomizedMenuWorkController query user menu flag error.", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/customized/menu/queryUserMenuFlag, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @GetMapping(value={"/queryEnableMenuTemplateList"})
    public ResponseEntity<BaseResultDTO<List<CustomizedMenuTemplate>>> queryEnableMenuTemplateList() {
        try {
            List templateRespList = this.customizedMenuTemplateService.queryEnableMenuTemplateList();
            return ResponseEntityWrapperUtil.wrapperOk((Object)templateRespList);
        }
        catch (Exception e) {
            log.error("CustomizedMenuTemplateController query menu template list error.", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/customized/template/queryEnableMenuTemplateList, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

