/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.menu;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.dto.menu.SaveMenuReq;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuTemplate;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuWork;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.proxy.athena.service.audc.AudcService;
import com.digiwin.athena.semc.proxy.athena.service.audc.model.SystemMenuDTO;
import com.digiwin.athena.semc.proxy.km.service.KmService;
import com.digiwin.athena.semc.proxy.km.service.model.AppJobDTO;
import com.digiwin.athena.semc.service.menu.CustomizedMenuTemplateService;
import com.digiwin.athena.semc.service.menu.CustomizedMenuWorkService;
import com.digiwin.athena.semc.service.portal.LabelSystemCustomService;
import com.digiwin.athena.semc.service.portal.PortalInfoService;
import com.digiwin.athena.semc.service.workbench.constant.PublishSourceEnum;
import com.digiwin.athena.semc.util.InterceptorIgnoreUtil;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.menu.CustomizedMenuWorkResp;
import com.digiwin.athena.semc.vo.menu.ValidCustomMenuRelVO;
import com.digiwin.athena.semc.vo.portal.LabelSystemAllVo;
import com.google.common.collect.Lists;
import io.github.linpeilie.Converter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/customized/menu"})
public class CustomizedMenuWorkController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomizedMenuWorkController.class);
    @Resource
    private CustomizedMenuWorkService customizedMenuWorkService;
    @Resource
    private CustomizedMenuTemplateService customizedMenuTemplateService;
    @Resource
    private LabelSystemCustomService labelSystemCustomService;
    @Resource
    private PortalInfoService portalInfoService;
    @Resource
    private AudcService audcService;
    @Autowired
    private KmService kmService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private Converter converter;
    public static final int MENU_TEMPLATE_COUNT_MAX = 99;
    public static final int MENU_NAME_LENGTH_MAX = 50;
    public static final int MENU_COUNT_MAX = 50;

    @GetMapping(value={"/queryManageMenu"})
    public ResponseEntity<BaseResultDTO<JSONObject>> queryManageMenu(@RequestParam Long templateId, @RequestParam Integer portalTypeSource) {
        CustomizedMenuTemplate template = null;
        if (Constants.LabelOrPoralSourceEnum.TENANT.getFlag().equals(portalTypeSource)) {
            template = this.customizedMenuTemplateService.queryTemplateById(templateId);
        } else if (Constants.LabelOrPoralSourceEnum.ISV.getFlag().equals(portalTypeSource)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            String tenantVersion = this.kmService.queryTenantVersion();
            wrapper.eq(CustomizedMenuTemplate::getMenuDesignerId, (Object)templateId);
            wrapper.eq(CustomizedMenuTemplate::getVersion, (Object)tenantVersion);
            wrapper.eq(CustomizedMenuTemplate::getPublishSource, (Object)PublishSourceEnum.ISV.name());
            template = (CustomizedMenuTemplate)InterceptorIgnoreUtil.handler(() -> (CustomizedMenuTemplate)this.customizedMenuTemplateService.getBaseMapper().selectOne((Wrapper)wrapper));
        }
        if (ObjectUtils.isEmpty((Object)template)) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)"\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        JSONObject jsonObject = new JSONObject();
        List menuWorkRespList = this.customizedMenuWorkService.queryManageMenu(template.getId());
        jsonObject.put("customList", (Object)menuWorkRespList);
        List systemMenuDTOList = Lists.newArrayList();
        if (Constants.SYSTEM_MENU_FLAG_YES.equals(template.getSystemMenuFlag())) {
            systemMenuDTOList = this.audcService.querySystemMenu();
        }
        jsonObject.put("systemList", (Object)systemMenuDTOList);
        return ResponseEntityWrapperUtil.wrapperOk((Object)jsonObject);
    }

    @PostMapping(value={"/validCustomMenuRel"})
    public ResponseEntity<BaseResultDTO<ValidCustomMenuRelVO>> validCustomMenuRel(@RequestBody @Valid SaveMenuReq saveMenuReq) {
        ValidCustomMenuRelVO validCustomMenuRelVO = new ValidCustomMenuRelVO();
        if (CollectionUtils.isEmpty((Collection)saveMenuReq.getMenuList())) {
            return ResponseEntityWrapperUtil.wrapperOk((Object)validCustomMenuRelVO);
        }
        List disabledList = this.queryDisabledListByIdList(saveMenuReq.getMenuList());
        if (CollectionUtils.isNotEmpty((Collection)disabledList)) {
            List labelNameList = disabledList.stream().map(LabelSystemCustom::getNameZh).collect(Collectors.toList());
            validCustomMenuRelVO.setSuccessFlag(Boolean.valueOf(false));
            validCustomMenuRelVO.setDisabledCustomList(labelNameList);
        }
        return ResponseEntityWrapperUtil.wrapperOk((Object)validCustomMenuRelVO);
    }

    private void filterCustomLabelList(CustomizedMenuWorkResp menu, List<CustomizedMenuWork> customLabelMenuList) {
        if (Constants.CustomizedMenuTypeEnum.LABEL.getType().equals(menu.getMenuType()) && Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal().equals(menu.getMenuLabelType())) {
            CustomizedMenuWork menuWork = (CustomizedMenuWork)this.converter.convert((Object)menu, CustomizedMenuWork.class);
            customLabelMenuList.add(menuWork);
        }
        if (CollectionUtils.isEmpty((Collection)menu.getChildren())) {
            return;
        }
        for (CustomizedMenuWorkResp child : menu.getChildren()) {
            this.filterCustomLabelList(child, customLabelMenuList);
        }
    }

    private List<LabelSystemCustom> queryDisabledListByIdList(List<CustomizedMenuWorkResp> menuTreeReqList) {
        ArrayList labelSystemCustomList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(menuTreeReqList)) {
            return labelSystemCustomList;
        }
        ArrayList customLabelMenuList = Lists.newArrayList();
        for (CustomizedMenuWorkResp menu : menuTreeReqList) {
            this.filterCustomLabelList(menu, (List)customLabelMenuList);
        }
        if (CollectionUtils.isEmpty((Collection)customLabelMenuList)) {
            return labelSystemCustomList;
        }
        List labelIdList = customLabelMenuList.stream().filter(x -> Constants.LabelTypeSourceEnum.TENANT.getFlag().equals(x.getLabelTypeSource())).map(CustomizedMenuWork::getMenuLabelId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(labelIdList)) {
            return labelSystemCustomList;
        }
        LabelSystemAllVo req = new LabelSystemAllVo();
        req.setIdList(labelIdList);
        req.setValidStatus(Constants.VALID_STATUS_UNUSABLE);
        return this.labelSystemCustomService.queryCustomList(req);
    }

    @PostMapping(value={"/saveMenu"})
    public ResponseEntity<BaseResultDTO<Boolean>> saveMenuList(@RequestBody @Valid SaveMenuReq saveMenuReq) {
        boolean isIsv;
        long count;
        if (ObjectUtils.isEmpty((Object)saveMenuReq.getTemplateId()) && (count = this.customizedMenuTemplateService.count()) > 99L) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.template.count.over"));
        }
        Boolean existFlag = this.customizedMenuTemplateService.validExist(saveMenuReq.getTemplateId(), saveMenuReq.getTemplateName());
        if (existFlag.booleanValue()) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.template.name.duplicate"));
        }
        if (saveMenuReq.getTemplateId() != null && (isIsv = Optional.ofNullable(this.customizedMenuTemplateService.queryTemplateById(saveMenuReq.getTemplateId())).map(template -> PublishSourceEnum.ISV.name().equals(template.getPublishSource())).orElse(false).booleanValue())) {
            String error = this.messageUtils.getMessage("error.unsupported.edit.isv.menu");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
        }
        ArrayList parallelMenuList = Lists.newArrayList();
        List menuTreeReqList = saveMenuReq.getMenuList();
        for (CustomizedMenuWorkResp menu : menuTreeReqList) {
            this.traverseTree(menu, (List)parallelMenuList, saveMenuReq.getTemplateId());
        }
        List disabledList = this.queryDisabledListByIdList(menuTreeReqList);
        ArrayList finalMenuList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)disabledList)) {
            List labelIdList = disabledList.stream().map(LabelSystemCustom::getId).collect(Collectors.toList());
            for (CustomizedMenuWork menuWork : parallelMenuList) {
                if (!Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal().equals(menuWork.getMenuLabelType())) {
                    finalMenuList.add(menuWork);
                    continue;
                }
                if (labelIdList.contains(menuWork.getMenuLabelId())) continue;
                finalMenuList.add(menuWork);
            }
        } else {
            finalMenuList.addAll(parallelMenuList);
        }
        ResponseEntity responseEntity = this.validSaveMenuParam((List)finalMenuList, Integer.valueOf(menuTreeReqList.size()));
        if (ObjectUtils.isNotEmpty((Object)responseEntity)) {
            return responseEntity;
        }
        Boolean flag = this.customizedMenuWorkService.saveMenu(saveMenuReq, (List)finalMenuList);
        return ResponseEntityWrapperUtil.wrapperOk((Object)flag);
    }

    private ResponseEntity<BaseResultDTO<Boolean>> validSaveMenuParam(List<CustomizedMenuWork> menuList, Integer menuCount) {
        if (CollectionUtils.isEmpty(menuList)) {
            return null;
        }
        boolean validLevel = menuList.stream().anyMatch(x -> Constants.CustomizedMenuLevelEnum.THIRD.getLevel() < x.getLevel());
        if (validLevel) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"The menu level cannot exceed three levels");
        }
        boolean validNameNull = menuList.stream().anyMatch(x -> StringUtils.isBlank((CharSequence)x.getMenuName()));
        if (validNameNull) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.menu.name.cannot.be.null"));
        }
        boolean validNameLength = menuList.stream().anyMatch(x -> x.getMenuName().length() > 50);
        if (validNameLength) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"The menu name cannot exceed 50 characters");
        }
        if (menuCount > 50) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"The menu count cannot exceed 50");
        }
        Map<Long, Long> parentIdMap = menuList.stream().filter(x -> x.getParentId() != null).collect(Collectors.groupingBy(CustomizedMenuWork::getParentId, Collectors.counting()));
        for (Map.Entry<Long, Long> parentIdEntry : parentIdMap.entrySet()) {
            if (parentIdEntry.getValue() <= 50L) continue;
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"The menu count cannot exceed 50");
        }
        List menuNameList = menuList.stream().filter(x -> Constants.CustomizedMenuTypeEnum.MENU.getType().equals(x.getMenuType())).map(CustomizedMenuWork::getMenuName).collect(Collectors.toList());
        HashSet disMenuNameSet = new HashSet(menuNameList);
        if (menuNameList.size() != disMenuNameSet.size()) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"The menu cannot have duplicate names");
        }
        List workNameList = menuList.stream().filter(x -> Arrays.asList(Constants.CustomizedMenuTypeEnum.WORK.getType(), Constants.CustomizedMenuTypeEnum.LABEL.getType()).contains(x.getMenuType())).map(CustomizedMenuWork::getMenuName).collect(Collectors.toList());
        boolean disjoint = Collections.disjoint(menuNameList, workNameList);
        if (!disjoint) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"The menu and work cannot have duplicate names");
        }
        for (CustomizedMenuWork menu : menuList) {
            if (Arrays.asList(Constants.CustomizedMenuTypeEnum.WORK.getType(), Constants.CustomizedMenuTypeEnum.LABEL.getType()).contains(menu.getMenuType())) continue;
            List workList = menuList.stream().filter(x -> Arrays.asList(Constants.CustomizedMenuTypeEnum.WORK.getType(), Constants.CustomizedMenuTypeEnum.LABEL.getType()).contains(x.getMenuType()) && ObjectUtils.isNotEmpty((Object)x.getParentId()) && x.getParentId().equals(menu.getId())).map(CustomizedMenuWork::getMenuName).collect(Collectors.toList());
            HashSet disWorkNameSet = new HashSet(workList);
            if (workList.size() == disWorkNameSet.size()) continue;
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"The same job cannot be placed multiple times under the same menu");
        }
        for (CustomizedMenuWork menu : menuList) {
            boolean validWorkChild;
            if (Constants.CustomizedMenuTypeEnum.MENU.getType().equals(menu.getMenuType()) || !(validWorkChild = menuList.stream().anyMatch(x -> x.getParentId() != null && x.getParentId().equals(menu.getId())))) continue;
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"The job cannot have sub level job or menu");
        }
        return null;
    }

    private void traverseTree(CustomizedMenuWorkResp menu, List<CustomizedMenuWork> parallelMenuList, Long templateId) {
        Long id;
        if (ObjectUtils.isEmpty((Object)templateId) && ObjectUtils.isNotEmpty((Object)menu.getId())) {
            menu.setId(null);
        }
        if ((id = menu.getId()) == null) {
            id = SnowflakeIdWorker.getInstance().newId();
            menu.setId(id);
        }
        CustomizedMenuWork menuWork = (CustomizedMenuWork)this.converter.convert((Object)menu, CustomizedMenuWork.class);
        parallelMenuList.add(menuWork);
        if (CollectionUtils.isEmpty((Collection)menu.getChildren())) {
            return;
        }
        for (CustomizedMenuWorkResp child : menu.getChildren()) {
            child.setParentId(id);
            child.setParentName(menu.getMenuName());
            this.traverseTree(child, parallelMenuList, templateId);
        }
    }

    @GetMapping(value={"/queryDisplayMenu"})
    public ResponseEntity<BaseResultDTO<JSONObject>> queryDisplayMenu(@RequestParam(required=false) Long templateId, @RequestParam(required=false) Long portalId, @RequestParam Integer portalTypeSource) {
        if (ObjectUtils.isEmpty((Object)templateId) && ObjectUtils.isEmpty((Object)portalId)) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"param is not exist");
        }
        Integer menuTypeSource = Constants.SourceEnum.TENANT.getFlag();
        if (ObjectUtils.isEmpty((Object)templateId)) {
            PortalInfo tempPortal = null;
            tempPortal = Constants.PortalTypeSourceEnum.ISV.getFlag().equals(portalTypeSource) ? this.portalInfoService.queryPortalInfoByDesignerId(portalId) : this.portalInfoService.getTempPortal(portalId);
            if (ObjectUtils.isEmpty((Object)tempPortal)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)("portal is not exist, portalId:" + portalId));
            }
            templateId = tempPortal.getMenuTemplateId();
            menuTypeSource = tempPortal.getMenuTypeSource();
        }
        JSONObject jsonObject = new JSONObject();
        if (Constants.GENERAL_MENU_TEMPLATE_ID.equals(templateId)) {
            jsonObject.put("generalFlag", (Object)Constants.GENERAL_MENU_FLAG_YES);
            return ResponseEntityWrapperUtil.wrapperOk((Object)jsonObject);
        }
        CustomizedMenuTemplate template = null;
        template = Constants.SourceEnum.ISV.getFlag().equals(menuTypeSource) ? this.customizedMenuTemplateService.queryTemplateByDesignerId(templateId) : this.customizedMenuTemplateService.queryTemplateById(templateId);
        if (ObjectUtils.isEmpty((Object)template)) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)("template is not exist, templateId:" + templateId + ", portalId:" + portalId));
        }
        jsonObject.put("generalFlag", (Object)template.getGeneralFlag());
        JSONObject menuList = this.customizedMenuWorkService.queryDisplayMenu(template.getId(), template.getSystemMenuFlag());
        jsonObject.putAll((Map)menuList);
        return ResponseEntityWrapperUtil.wrapperOk((Object)jsonObject);
    }

    @GetMapping(value={"/queryNoPortalDisplayMenu"})
    public ResponseEntity<BaseResultDTO<JSONObject>> queryNoPortalDisplayMenu(@RequestParam(required=false) Long templateId) {
        CustomizedMenuTemplate template = null;
        if (ObjectUtils.isEmpty((Object)templateId)) {
            List customizedMenuTemplate = this.customizedMenuTemplateService.queryEnableMenuTemplateList();
            if (CollectionUtils.isNotEmpty((Collection)customizedMenuTemplate)) {
                template = (CustomizedMenuTemplate)customizedMenuTemplate.get(0);
                templateId = template.getId();
            } else {
                return ResponseEntityWrapperUtil.wrapperOk();
            }
        }
        JSONObject jsonObject = new JSONObject();
        if (Constants.GENERAL_MENU_TEMPLATE_ID.equals(templateId)) {
            jsonObject.put("generalFlag", (Object)Constants.GENERAL_MENU_FLAG_YES);
            return ResponseEntityWrapperUtil.wrapperOk((Object)jsonObject);
        }
        if (ObjectUtils.isEmpty(template)) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)("template is not exist, templateId:" + templateId));
        }
        jsonObject.put("generalFlag", (Object)template.getGeneralFlag());
        JSONObject menuList = this.customizedMenuWorkService.queryDisplayMenu(templateId, template.getSystemMenuFlag());
        jsonObject.putAll((Map)menuList);
        return ResponseEntityWrapperUtil.wrapperOk((Object)jsonObject);
    }

    @GetMapping(value={"/queryWorkList"})
    public ResponseEntity<BaseResultDTO<List<AppJobDTO>>> queryWorkList() {
        List jobList = this.customizedMenuWorkService.queryAppJobList();
        return ResponseEntityWrapperUtil.wrapperOk((Object)jobList);
    }

    @GetMapping(value={"/querySystemMenuList"})
    public ResponseEntity<BaseResultDTO<List<SystemMenuDTO>>> querySystemMenuList() {
        List systemMenuDTOList = this.audcService.querySystemMenu();
        return ResponseEntityWrapperUtil.wrapperOk((Object)systemMenuDTOList);
    }

    @GetMapping(value={"/initData"})
    public ResponseEntity<BaseResultDTO<Boolean>> initCustomizedMenuData() {
        Boolean result = this.customizedMenuWorkService.initData();
        return ResponseEntityWrapperUtil.wrapperOk((Object)result);
    }
}

