/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.menu.manage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.dto.menu.manage.SaveMenuAuthReq;
import com.digiwin.athena.semc.entity.menu.manage.ManageMenu;
import com.digiwin.athena.semc.entity.menu.manage.ManageMenuAuth;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.service.menu.AuthService;
import com.digiwin.athena.semc.service.menu.ManageMenuAuthService;
import com.digiwin.athena.semc.service.menu.ManageMenuService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.SecurityLogUtil;
import com.digiwin.athena.semc.util.Utils;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/manage/menu/auth"})
public class ManageMenuAuthController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ManageMenuAuthController.class);
    @Resource
    private ManageMenuAuthService manageMenuAuthService;
    @Resource
    private ManageMenuService manageMenuService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    EnvProperties envProperties;
    @Resource
    private AuthService authService;

    @GetMapping(value={"/queryAuthRelMenu"})
    public ResponseEntity<BaseResultDTO<JSONObject>> queryAuthRelMenu(@RequestParam(value="authId") String authId) {
        JSONObject resp = new JSONObject();
        List menuAuthList = this.manageMenuAuthService.queryAuthRelMenu(authId);
        List menuKeyList = menuAuthList.stream().map(ManageMenuAuth::getMenuKey).collect(Collectors.toList());
        resp.put("menuAuthList", menuKeyList);
        if (CollectionUtils.isEmpty((Collection)menuAuthList)) {
            resp.put("allMenuAuthFlag", (Object)Constants.ALL_AUTH_FLAG_NO);
            return ResponseEntityWrapperUtil.wrapperOk((Object)resp);
        }
        boolean flag = menuAuthList.stream().anyMatch(x -> Constants.ALL_AUTH_FLAG_YES.equals(x.getAllMenuAuthFlag()));
        resp.put("allMenuAuthFlag", (Object)(flag ? Constants.ALL_AUTH_FLAG_YES : Constants.ALL_AUTH_FLAG_NO));
        return ResponseEntityWrapperUtil.wrapperOk((Object)resp);
    }

    @PostMapping(value={"/saveAuthRelMenu"})
    public ResponseEntity<BaseResultDTO<Boolean>> saveAuthRelMenu(@RequestBody @Valid SaveMenuAuthReq saveMenuAuthReq, HttpServletRequest request) {
        try {
            if (this.authService.hasAuth("permission-menu")) {
                this.manageMenuAuthService.saveAuthRelMenu(saveMenuAuthReq);
                return ResponseEntityWrapperUtil.wrapperOk((Object)true);
            }
            SecurityLogUtil.writeSecurityLog((HttpServletRequest)request, (String)JSON.toJSONString((Object)saveMenuAuthReq));
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u65e0\u6743\u9650");
        }
        catch (Exception e) {
            log.error("ManageMenuAuthController save auth rel menu error. param:{}", (Object)saveMenuAuthReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/manage/menu/auth/saveAuthRelMenu, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @GetMapping(value={"/queryUserMenuList"})
    public ResponseEntity<BaseResultDTO<List<String>>> queryUserMenuList(@RequestParam Integer environmentFlag) {
        String version = this.manageMenuService.getTenantVersion();
        List manageMenuList = this.manageMenuService.queryBaseManageMenu(environmentFlag, true, version);
        List specialMenuKeyList = manageMenuList.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getTenantId()) && x.getTenantId().equals(Utils.getTenantId()) && x.getBelongingUsers().contains(Utils.getUserId())).map(ManageMenu::getMenuKey).collect(Collectors.toList());
        List menuAuthList = this.manageMenuAuthService.queryUserMenuList();
        if (CollectionUtils.isEmpty((Collection)menuAuthList)) {
            return ResponseEntityWrapperUtil.wrapperOk(specialMenuKeyList);
        }
        boolean allFlag = menuAuthList.stream().anyMatch(x -> Constants.ALL_AUTH_FLAG_YES.equals(x.getAllMenuAuthFlag()));
        List menuKeyList = allFlag ? manageMenuList.stream().filter(x -> StringUtils.isBlank((CharSequence)x.getTenantId())).map(ManageMenu::getMenuKey).collect(Collectors.toList()) : menuAuthList.stream().map(ManageMenuAuth::getMenuKey).collect(Collectors.toList());
        menuKeyList.addAll(specialMenuKeyList);
        return ResponseEntityWrapperUtil.wrapperOk(menuKeyList);
    }

    @GetMapping(value={"/querySpecialUser"})
    public ResponseEntity<BaseResultDTO<JSONObject>> querySpecialUser() {
        try {
            String specialTenantId = this.envProperties.getTemplateTenantId();
            String specialUserId = this.envProperties.getTemplateUserId();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("specialTenantId", (Object)specialTenantId);
            jsonObject.put("specialUserId", (Object)specialUserId);
            return ResponseEntityWrapperUtil.wrapperOk((Object)jsonObject);
        }
        catch (Exception e) {
            log.error("ManageMenuAuthController query special user error.", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/manage/menu/auth/querySpecialUser, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

