/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.menu.manage;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.dto.menu.manage.DelMenuListReq;
import com.digiwin.athena.semc.dto.menu.manage.SaveSpecialTenantIdReq;
import com.digiwin.athena.semc.entity.menu.manage.ManageMenu;
import com.digiwin.athena.semc.service.cache.CommonConfigService;
import com.digiwin.athena.semc.service.menu.ManageMenuService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.menu.UserManageMenulVO;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/manage/menu"})
public class ManageMenuController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ManageMenuController.class);
    @Resource
    private ManageMenuService manageMenuService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private CommonConfigService commonConfigService;

    @GetMapping(value={"/queryManageMenuConfigList"})
    public ResponseEntity<BaseResultDTO<List<ManageMenu>>> queryManageMenuConfigList() {
        try {
            List manageMenuList = this.manageMenuService.queryManageMenuConfigList();
            return ResponseEntityWrapperUtil.wrapperOk((Object)manageMenuList);
        }
        catch (Exception e) {
            log.error("ManageMenuController query manage menu page error.", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/manage/menu/queryManageMenuConfigList, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/saveManageMenu"})
    public ResponseEntity<BaseResultDTO<Boolean>> saveManageMenu(@RequestBody @Valid ManageMenu manageMenu) {
        try {
            Boolean isNeedEmpty;
            if (Boolean.FALSE.equals(this.commonConfigService.getBackendMenuOperateFlag())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u65e0\u6743\u9650");
            }
            if (manageMenu.getOnlyPreArea() == null) {
                manageMenu.setOnlyPreArea(Integer.valueOf(0));
            }
            if (StringUtils.isNotBlank((CharSequence)manageMenu.getParentMenuKey()) && manageMenu.getMenuKey().equals(manageMenu.getParentMenuKey())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"menuKey and parentMenuKey cannot be duplicated");
            }
            List manageMenuList = this.manageMenuService.existMenuKey(manageMenu);
            if (CollectionUtils.isNotEmpty((Collection)manageMenuList)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)("menuKey is exist:" + manageMenu.getMenuKey()));
            }
            if (StringUtils.isNotEmpty((CharSequence)manageMenu.getVersion()) && (isNeedEmpty = this.manageMenuService.handMenuVersion(manageMenu)).booleanValue()) {
                manageMenu.setVersion(null);
            }
            if (ObjectUtils.isEmpty((Object)manageMenu.getId())) {
                this.manageMenuService.insertManageMenu(manageMenu);
            } else {
                this.manageMenuService.updateManageMenu(manageMenu);
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("ManageMenuController save manage menu error. param:{}", (Object)manageMenu, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/manage/menu/saveManageMenu, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/delManageMenu"})
    public ResponseEntity<BaseResultDTO<Boolean>> delManageMenu(@RequestBody @Valid DelMenuListReq delMenuListReq) {
        try {
            if (Boolean.FALSE.equals(this.commonConfigService.getBackendMenuOperateFlag())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u65e0\u6743\u9650");
            }
            List manageMenuList = this.manageMenuService.getBaseMapper().selectList((Wrapper)Wrappers.emptyWrapper());
            this.manageMenuService.deleteByMenuKeyList(delMenuListReq.getMenuKeyList(), manageMenuList);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("ManageMenuController del manage menu error. param:{}", (Object)delMenuListReq.getMenuKeyList(), (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/manage/menu/delManageMenu, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @GetMapping(value={"/queryManageMenuList"})
    public ResponseEntity<BaseResultDTO<List<ManageMenu>>> queryManageMenuList(@RequestParam Integer environmentFlag) {
        try {
            List menuList = this.manageMenuService.queryManageMenuList(environmentFlag);
            return ResponseEntityWrapperUtil.wrapperOk((Object)menuList);
        }
        catch (Exception e) {
            log.error("ManageMenuController query manage menu list error. environmentFlag:{}", (Object)environmentFlag, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/manage/menu/queryManageMenuList, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @GetMapping(value={"/queryManageMenuTree"})
    public ResponseEntity<BaseResultDTO<List<ManageMenu>>> queryManageMenuTree(@RequestParam Integer environmentFlag) {
        try {
            List menuList = this.manageMenuService.queryManageMenuTree(environmentFlag);
            return ResponseEntityWrapperUtil.wrapperOk((Object)menuList);
        }
        catch (Exception e) {
            log.error("ManageMenuController query manage menu tree error. environmentFlag:{}", (Object)environmentFlag, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/manage/menu/queryManageMenuTree, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @GetMapping(value={"/validMenuAuth"})
    public ResponseEntity<BaseResultDTO<Boolean>> validMenuAuth(@RequestParam Integer environmentFlag, @RequestParam String menuKey) {
        try {
            QueryWrapper condition = new QueryWrapper();
            condition.eq((Object)"menu_key", (Object)menuKey);
            List manageMenuList = this.manageMenuService.getBaseMapper().selectList((Wrapper)condition);
            if (CollectionUtils.isEmpty((Collection)manageMenuList)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)("the menuKey is not exist:" + menuKey));
            }
            boolean flag = this.manageMenuService.validMenuAuth(environmentFlag, (ManageMenu)manageMenuList.get(0));
            return ResponseEntityWrapperUtil.wrapperOk((Object)flag);
        }
        catch (Exception e) {
            log.error("ManageMenuController valid menu auth error. environmentFlag:{}, menuKey:{}", new Object[]{environmentFlag, menuKey, e});
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/manage/menu/validMenuAuth, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/saveTenantId"})
    public ResponseEntity<BaseResultDTO<Boolean>> saveTenantId(@RequestBody SaveSpecialTenantIdReq saveSpecialTenantIdReq) {
        try {
            this.manageMenuService.saveTenantId(saveSpecialTenantIdReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("ManageMenuController save tenantId error. param:{}", (Object)saveSpecialTenantIdReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/manage/menu/saveTenantId, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/queryUserMenuFlag"})
    public ResponseEntity<BaseResultDTO<UserManageMenulVO>> queryUserMenuFlag(@RequestBody @Valid UserManageMenulVO req) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.manageMenuService.queryUserMenuFlag(req));
        }
        catch (Exception e) {
            log.error("queryUserMenuFlag  environmentFlag:{}, error:{}", (Object)req.getEnvironmentFlag(), (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/manage/menu/queryUserMenuFlag, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

