/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.message;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.dto.message.SaveBlackWhiteReq;
import com.digiwin.athena.semc.entity.message.MessageBlackWhite;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.iam.service.model.RoleDTO;
import com.digiwin.athena.semc.service.message.MessageBlackWhiteService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/message/blackwhite"})
public class MessageBlackWhiteController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageBlackWhiteController.class);
    @Resource
    private MessageBlackWhiteService messageBlackWhiteService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private IamService iamService;

    @GetMapping(value={"/queryUserList"})
    public ResponseEntity<BaseResultDTO<List<MessageBlackWhite>>> queryUserList(@RequestParam(required=false) Integer type, @RequestParam(required=false) String key, @RequestParam(required=false) String tenantId) {
        try {
            if (type != null && !Arrays.asList(Constants.BLACK_TYPE, Constants.WHITE_TYPE).contains(type)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"the type is is illegal");
            }
            List blackWhiteList = this.messageBlackWhiteService.queryUserList(type, key, tenantId);
            return ResponseEntityWrapperUtil.wrapperOk((Object)blackWhiteList);
        }
        catch (Exception e) {
            log.error("MessageBlackWhiteController | query user list error.", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @GetMapping(value={"/delUser"})
    public ResponseEntity<BaseResultDTO<Boolean>> delUser(@RequestParam Long id) {
        try {
            MessageBlackWhite blackWhite = (MessageBlackWhite)this.messageBlackWhiteService.getBaseMapper().selectById((Serializable)id);
            if (ObjectUtils.isEmpty((Object)blackWhite)) {
                return ResponseEntityWrapperUtil.wrapperOk((Object)true);
            }
            List userList = this.iamService.queryAllUserList();
            List userIdList = userList.stream().map(RoleDTO::getId).collect(Collectors.toList());
            if (!userIdList.contains(blackWhite.getUserId())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"No permission to delete the current user");
            }
            this.messageBlackWhiteService.delUser(id);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("MessageBlackWhiteController | delete user list error.", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @GetMapping(value={"/validUser"})
    public ResponseEntity<BaseResultDTO<JSONObject>> validUser(@RequestParam Integer type, @RequestParam String userId) {
        try {
            Integer oppositeType = Constants.BLACK_TYPE.equals(type) ? Constants.WHITE_TYPE : Constants.BLACK_TYPE;
            List blackWhiteList = this.messageBlackWhiteService.queryUserList(oppositeType, null, null);
            Boolean flag = Boolean.TRUE;
            String errorMsg = "";
            if (CollectionUtils.isNotEmpty((Collection)blackWhiteList)) {
                List userIdList = blackWhiteList.stream().map(MessageBlackWhite::getUserId).collect(Collectors.toList());
                if (userIdList.contains(userId) && Constants.BLACK_TYPE.equals(type)) {
                    flag = Boolean.FALSE;
                    errorMsg = this.messageUtils.getMessage("error.message.white.user.exist");
                }
                if (userIdList.contains(userId) && Constants.WHITE_TYPE.equals(type)) {
                    flag = Boolean.FALSE;
                    errorMsg = this.messageUtils.getMessage("error.message.black.user.exist");
                }
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"flag", (Object)flag);
            jsonObject.put((Object)"errorMsg", (Object)errorMsg);
            return ResponseEntityWrapperUtil.wrapperOk((Object)jsonObject);
        }
        catch (Exception e) {
            log.error("MessageBlackWhiteController | valid user error.", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @PostMapping(value={"/saveUser"})
    public ResponseEntity<BaseResultDTO<Boolean>> saveUser(@RequestBody @Valid SaveBlackWhiteReq saveBlackWhiteReq) {
        try {
            List reqUserList;
            List userIdList;
            Integer oppositeType = Constants.BLACK_TYPE.equals(saveBlackWhiteReq.getType()) ? Constants.WHITE_TYPE : Constants.BLACK_TYPE;
            List blackWhiteList = this.messageBlackWhiteService.queryUserList(oppositeType, null, null);
            if (CollectionUtils.isNotEmpty((Collection)blackWhiteList) && CollectionUtils.containsAny(userIdList = blackWhiteList.stream().map(MessageBlackWhite::getUserId).collect(Collectors.toList()), reqUserList = saveBlackWhiteReq.getUserList().stream().map(SaveBlackWhiteReq.UserDTO::getUserId).collect(Collectors.toList()))) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"there are users on the opposing list");
            }
            List userList = this.iamService.queryAllUserList();
            List userIdList2 = userList.stream().map(RoleDTO::getId).collect(Collectors.toList());
            for (SaveBlackWhiteReq.UserDTO userDTO : saveBlackWhiteReq.getUserList()) {
                if (userIdList2.contains(userDTO.getUserId())) continue;
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)("No permission to add user:" + userDTO.getUserName()));
            }
            this.messageBlackWhiteService.saveUser(saveBlackWhiteReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("MessageBlackWhiteController |save user list error.", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }
}

