/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.message;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.dto.message.CopyTemplateReq;
import com.digiwin.athena.semc.dto.message.QueryTemplateListReq;
import com.digiwin.athena.semc.dto.message.QueryTemplateListResp;
import com.digiwin.athena.semc.dto.message.QueryTemplateRelResp;
import com.digiwin.athena.semc.dto.message.SaveTemplateReq;
import com.digiwin.athena.semc.dto.message.TemplateRelReq;
import com.digiwin.athena.semc.entity.message.MessageChannelBase;
import com.digiwin.athena.semc.entity.message.MessageChannelTemplate;
import com.digiwin.athena.semc.service.message.MessageChannelBaseService;
import com.digiwin.athena.semc.service.message.MessageChannelService;
import com.digiwin.athena.semc.service.message.MessageChannelTemplateService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.SpecialValidator;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/message/channel"})
public class MessageChannelController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageChannelController.class);
    public static final int CONTACT_MAX_LENGTH = 100;
    public static final int MESSAGE_REL_PERSONNEL_COUNT_MAX = 1000;
    public static final int CHILD_TEMPLATE_MAX_COUNT = 10;
    @Resource
    private MessageChannelBaseService messageChannelBaseService;
    @Resource
    private MessageChannelService messageChannelService;
    @Resource
    private MessageChannelTemplateService messageChannelTemplateService;
    @Resource
    private MessageUtils messageUtils;

    @GetMapping(value={"/queryBaseChannel"})
    public ResponseEntity<BaseResultDTO<List<MessageChannelBase>>> queryBaseChannel(@RequestParam(required=false) Integer sceneType) {
        try {
            List channelBaseList = this.messageChannelBaseService.queryBaseChannel();
            if (sceneType == null && CollectionUtils.isNotEmpty((Collection)channelBaseList)) {
                channelBaseList = channelBaseList.stream().filter(x -> x.getChannelKey().equals("wecom")).collect(Collectors.toList());
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)channelBaseList);
        }
        catch (Exception e) {
            log.error("MessageChannelController | query message base channel error. param:{}", (Object)sceneType, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/message/channel/queryBaseChannel");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @GetMapping(value={"/queryChannel"})
    public ResponseEntity<BaseResultDTO<String>> queryChannel(@RequestParam(required=false, value="tenantId") String tenantId) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.messageChannelService.queryChannelFlag(null, tenantId));
        }
        catch (Exception e) {
            log.error("MessageChannelController | query message channel error. param:{} ", (Object)tenantId, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/message/channel/queryChannel");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @GetMapping(value={"/saveChannel"})
    public ResponseEntity<BaseResultDTO<Boolean>> saveChannel(@RequestParam String channelStr) {
        try {
            this.messageChannelService.saveChannel(channelStr);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("MessageChannelController | save message channel error. param\uff1a{}", (Object)channelStr, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/message/channel/saveChannel");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/queryTemplateList"})
    public ResponseEntity<BaseResultDTO<List<QueryTemplateListResp>>> queryTemplateList(@RequestBody @Valid QueryTemplateListReq queryTemplateListReq) {
        try {
            List templateListRespList = this.messageChannelTemplateService.queryTemplateList(queryTemplateListReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)templateListRespList);
        }
        catch (Exception e) {
            log.error("MessageChannelController | query template list error. param\uff1a{}", (Object)queryTemplateListReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/message/channel/queryTemplateList");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/updateStatus"})
    public ResponseEntity<BaseResultDTO<Boolean>> updateStatus(@RequestBody @Valid SaveTemplateReq saveTemplateReq) {
        try {
            if (saveTemplateReq.getStatus() == null) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"the status can not be null");
            }
            this.messageChannelTemplateService.updateStatus(saveTemplateReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("MessageChannelController | update status error. param\uff1a{}", (Object)saveTemplateReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/message/channel/updateStatus");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/updateTemplate"})
    public ResponseEntity<BaseResultDTO<Boolean>> updateTemplate(@RequestBody @Valid SaveTemplateReq saveTemplateReq) {
        try {
            if (!Constants.MessageChannelEnum.EMAIL.getFlag().equals(saveTemplateReq.getChannelFlag())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"the channelFlag is illegal");
            }
            if (StringUtils.isBlank((String)saveTemplateReq.getRemark())) {
                saveTemplateReq.setRemark("");
            }
            this.messageChannelTemplateService.updateTemplate(saveTemplateReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("MessageChannelController | update template error. param\uff1a{}", (Object)saveTemplateReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/message/channel/updateTemplate");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/queryRelPerson"})
    public ResponseEntity<BaseResultDTO<QueryTemplateRelResp>> queryRelPerson(@RequestBody @Valid TemplateRelReq templateRelReq) {
        try {
            if (!Arrays.asList(Constants.MessageChannelEnum.EMAIL.getFlag(), Constants.MessageChannelEnum.SMS.getFlag(), Constants.MessageChannelEnum.WECOM.getFlag(), Constants.MessageChannelEnum.DINGTALK.getFlag()).contains(templateRelReq.getChannelFlag())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"the channelFlag is illegal");
            }
            QueryTemplateRelResp relResp = this.messageChannelTemplateService.queryRelPerson(templateRelReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)relResp);
        }
        catch (Exception e) {
            log.error("MessageChannelController | query rel person error. param\uff1a{}", (Object)templateRelReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/message/channel/queryRelPerson");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/addRelPerson"})
    public ResponseEntity<?> addRelPerson(@RequestBody @Valid TemplateRelReq templateRelReq) {
        try {
            if (!Arrays.asList(Constants.MessageChannelEnum.EMAIL.getFlag(), Constants.MessageChannelEnum.SMS.getFlag(), Constants.MessageChannelEnum.WECOM.getFlag(), Constants.MessageChannelEnum.DINGTALK.getFlag()).contains(templateRelReq.getChannelFlag())) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"the channelFlag is illegal");
            }
            if (StringUtils.isBlank((String)templateRelReq.getLanguage())) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"the language can not be null");
            }
            if (CollectionUtils.isEmpty((Collection)templateRelReq.getContactList())) {
                return ResponseEntityWrapper.wrapperOk((Object)true);
            }
            for (String contact : templateRelReq.getContactList()) {
                if (contact.length() < 100) continue;
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"The length of the contact cannot over100");
            }
            if (Constants.MessageChannelEnum.EMAIL.getFlag().equals(templateRelReq.getChannelFlag())) {
                if (templateRelReq.getEmailType() == null) {
                    return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"the emailType can not be null");
                }
                for (String email : templateRelReq.getContactList()) {
                    if (SpecialValidator.validateEmail((String)email)) continue;
                    return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)("the email format error:" + email));
                }
            }
            if (Constants.MessageChannelEnum.SMS.getFlag().equals(templateRelReq.getChannelFlag())) {
                for (String telephone : templateRelReq.getContactList()) {
                    if (SpecialValidator.validatePositiveNumber((String)telephone)) continue;
                    return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)("The phone number is illegal:" + telephone));
                }
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"errorCode", (Object)"");
            Integer totalCount = this.validPersonNumber(templateRelReq);
            if (totalCount > 1000) {
                jsonObject.put((Object)"errorCode", (Object)ErrorCodeConstant.PARAM_LENGTH_ERROR);
                jsonObject.put((Object)"errorMsg", (Object)"the number of person can not over 1000");
                return ResponseEntityWrapper.wrapperOk((Object)jsonObject);
            }
            this.messageChannelTemplateService.addRelPerson(templateRelReq);
            return ResponseEntityWrapper.wrapperOk((Object)jsonObject);
        }
        catch (Exception e) {
            log.error("MessageChannelController | add rel person error. param\uff1a{}", (Object)templateRelReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/message/channel/addRelPerson, message:" + e.getMessage());
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    private Integer validPersonNumber(TemplateRelReq templateRelReq) {
        QueryTemplateRelResp relResp = this.messageChannelTemplateService.queryRelPerson(templateRelReq);
        Integer paramCount = CollectionUtils.isNotEmpty((Collection)templateRelReq.getContactList()) ? templateRelReq.getContactList().size() : 0;
        if (Constants.MessageChannelEnum.EMAIL.getFlag().equals(templateRelReq.getChannelFlag())) {
            if (Constants.EmailTypeEnum.CONTACT.getFlag().equals(templateRelReq.getEmailType())) {
                Integer existCount = CollectionUtils.isNotEmpty((Collection)relResp.getContactList()) ? relResp.getContactList().size() : 0;
                return existCount + paramCount;
            }
            if (Constants.EmailTypeEnum.CCCONTACT.getFlag().equals(templateRelReq.getEmailType())) {
                Integer existCount = CollectionUtils.isNotEmpty((Collection)relResp.getCcContactList()) ? relResp.getCcContactList().size() : 0;
                return existCount + paramCount;
            }
            if (Constants.EmailTypeEnum.BCCCONTACT.getFlag().equals(templateRelReq.getEmailType())) {
                Integer existCount = CollectionUtils.isNotEmpty((Collection)relResp.getBccContactList()) ? relResp.getBccContactList().size() : 0;
                return existCount + paramCount;
            }
        } else {
            Integer existCount = CollectionUtils.isNotEmpty((Collection)relResp.getContactList()) ? relResp.getContactList().size() : 0;
            return existCount + paramCount;
        }
        return 0;
    }

    @PostMapping(value={"/delRelPerson"})
    public ResponseEntity<BaseResultDTO<Boolean>> delRelPerson(@RequestBody @Valid TemplateRelReq templateRelReq) {
        try {
            if (StringUtils.isBlank((String)templateRelReq.getLanguage())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"the language can not be null");
            }
            if (!Arrays.asList(Constants.MessageChannelEnum.EMAIL.getFlag(), Constants.MessageChannelEnum.SMS.getFlag(), Constants.MessageChannelEnum.WECOM.getFlag(), Constants.MessageChannelEnum.DINGTALK.getFlag()).contains(templateRelReq.getChannelFlag())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"the channelFlag is illegal");
            }
            this.messageChannelTemplateService.delRelPerson(templateRelReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("MessageChannelController | del rel person error. param:{}", (Object)templateRelReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/message/channel/delRelPerson");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @GetMapping(value={"/queryEventIdList"})
    public ResponseEntity<BaseResultDTO<List<String>>> queryEventIdList(@RequestParam String tenantId, @RequestParam String remark) {
        try {
            if (StringUtils.isBlank((String)tenantId) || StringUtils.isBlank((String)remark)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"the tenantId or remark can not be null");
            }
            List eventIdList = this.messageChannelTemplateService.queryEventIdList(tenantId, remark);
            if (CollectionUtils.isEmpty((Collection)eventIdList)) {
                return ResponseEntityWrapperUtil.wrapperOk(new ArrayList());
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)eventIdList);
        }
        catch (Exception e) {
            log.error("MessageChannelController | query event id list error. tenantId:{}, remark:{}", new Object[]{tenantId, remark, e});
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/message/channel/queryEventIdList");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/copyTemplate"})
    public ResponseEntity<BaseResultDTO<Boolean>> copyTemplate(@RequestBody @Valid CopyTemplateReq copyTemplateReq) {
        try {
            Long count;
            if (copyTemplateReq.getId() != null && (count = this.messageChannelTemplateService.queryChildTemplateCount(copyTemplateReq.getId())) >= 10L) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"\u6700\u591a\u5141\u8bb8\u590d\u523610\u4e2a\u6a21\u677f");
            }
            this.messageChannelTemplateService.copyTemplate(copyTemplateReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("MessageChannelController | copy template error. param:{}", (Object)copyTemplateReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/message/channel/copyTemplate, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @GetMapping(value={"/delTemplate"})
    public ResponseEntity<BaseResultDTO<Boolean>> delTemplate(@RequestParam Long templateId) {
        try {
            MessageChannelTemplate template = (MessageChannelTemplate)this.messageChannelTemplateService.getBaseMapper().selectById((Serializable)templateId);
            if (template == null) {
                return ResponseEntityWrapperUtil.wrapperOk((Object)true);
            }
            if (template.getParentId() == null) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"\u4e0d\u5141\u8bb8\u5220\u9664\u539f\u6a21\u7248");
            }
            this.messageChannelTemplateService.getBaseMapper().deleteById((Serializable)templateId);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("MessageChannelController | del template error. templateId:{}", (Object)templateId, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/message/channel/delTemplate, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

