/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.message;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.controller.BasicController;
import com.digiwin.athena.semc.dto.message.DeleteMessageConfigReq;
import com.digiwin.athena.semc.dto.message.QueryThirdMessageConfigReq;
import com.digiwin.athena.semc.dto.message.QueryThirdMessageListReq;
import com.digiwin.athena.semc.dto.message.ReadThirdMessageReq;
import com.digiwin.athena.semc.dto.message.ReceiveThirdMessageReq;
import com.digiwin.athena.semc.dto.message.SaveThirdMessageConfigReq;
import com.digiwin.athena.semc.entity.message.ThirdMessageConfig;
import com.digiwin.athena.semc.entity.message.ThirdMessageInfo;
import com.digiwin.athena.semc.entity.message.ThirdMessageType;
import com.digiwin.athena.semc.quartz.ThirdMessagePullTaskJob;
import com.digiwin.athena.semc.service.menu.AuthService;
import com.digiwin.athena.semc.service.message.ThirdMessageInfoService;
import com.digiwin.athena.semc.service.message.ThirdMessageReadInfoService;
import com.digiwin.athena.semc.service.message.ThirdSystemMessageService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.util.AesUtil;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.InterceptorIgnoreUtil;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.SecurityLogUtil;
import com.digiwin.athena.semc.vo.message.MessageAppNumResp;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/third/message"})
public class ThirdSystemMessageController
extends BasicController<ThirdSystemMessageService, ThirdMessageConfig> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThirdSystemMessageController.class);
    @Resource
    private ThirdSystemMessageService thirdSystemMessageService;
    @Resource
    private ThirdMessageInfoService thirdMessageInfoService;
    @Resource
    ThirdMessageReadInfoService thirdMessageReadInfoService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private ThirdMessagePullTaskJob thirdMessagePullTaskJob;
    @Autowired
    private LabelSystemDataService labelSystemDataService;
    @Autowired
    private AuthService authService;

    @PostMapping(value={"/queryMessageConfigPage"})
    public ResponseEntity<BaseResultDTO<PageInfoResp<ThirdMessageConfig>>> queryMessageConfigPage(@RequestBody @Valid QueryThirdMessageConfigReq queryImportRecordReq) {
        try {
            PageInfoResp pageInfoResp = this.thirdSystemMessageService.queryMessageConfigPage(queryImportRecordReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)pageInfoResp);
        }
        catch (Exception e) {
            log.error("query message config error, param:{}", (Object)queryImportRecordReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/third/message/queryMessageConfig");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/saveApplication"})
    public ResponseEntity<BaseResultDTO<Boolean>> saveApplication(@RequestBody @Valid SaveThirdMessageConfigReq saveThirdMessageConfigReq, HttpServletRequest request) {
        try {
            boolean flag;
            if (!this.authService.hasAuth("third-message")) {
                SecurityLogUtil.writeSecurityLog((HttpServletRequest)request, (String)JSON.toJSONString((Object)saveThirdMessageConfigReq));
            }
            if (Constants.DataGetTypeEnum.PULL.getFlag().equals(saveThirdMessageConfigReq.getDataGetType())) {
                if (saveThirdMessageConfigReq.getPullPeriod() == null) {
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"the pullPeriod cannot be null");
                }
                if (saveThirdMessageConfigReq.getAppAccessModel() == null) {
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"the appAccessModel cannot be null");
                }
                if (Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal().equals(saveThirdMessageConfigReq.getAppAccessModel())) {
                    if (StringUtils.isBlank((String)saveThirdMessageConfigReq.getMiddleSystemName())) {
                        return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"the middleSystemName cannot be null");
                    }
                    if (StringUtils.isBlank((String)saveThirdMessageConfigReq.getMiddleSystemUid())) {
                        return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"the middleSystemUid cannot be null");
                    }
                } else if (StringUtils.isBlank((String)saveThirdMessageConfigReq.getDomain())) {
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"the domain cannot be null");
                }
            }
            if (flag = this.thirdSystemMessageService.validMessageConfigExist(saveThirdMessageConfigReq)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u5e94\u7528\u5df2\u5b58\u5728\uff01");
            }
            if (saveThirdMessageConfigReq.getId() != null) {
                this.thirdMessagePullTaskJob.deleteJob("ThirdMessagePullTaskJob", "MessageJob_" + saveThirdMessageConfigReq.getId());
            }
            ThirdMessageConfig thirdMessageConfig = this.thirdSystemMessageService.saveApplication(saveThirdMessageConfigReq);
            if (saveThirdMessageConfigReq.getDataGetType() == 2 && thirdMessageConfig.getValidStatus() == 1) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("id", thirdMessageConfig.getId());
                params.put("appCode", thirdMessageConfig.getAppCode());
                params.put("appPrimaryId", thirdMessageConfig.getAppPrimaryId());
                params.put("appSource", thirdMessageConfig.getAppSource());
                params.put("pullPeriod", thirdMessageConfig.getPullPeriod());
                params.put("appAccessModel", thirdMessageConfig.getAppAccessModel());
                params.put("middleSystemName", thirdMessageConfig.getMiddleSystemName());
                params.put("middleSystemUid", thirdMessageConfig.getMiddleSystemUid());
                params.put("domain", thirdMessageConfig.getDomain());
                params.put("sendChannel", thirdMessageConfig.getSendChannel());
                params.put("tenantsid", AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                Map ssoInfoMap = this.labelSystemDataService.getSSoInfo(Long.valueOf(Long.parseLong(thirdMessageConfig.getAppPrimaryId())), thirdMessageConfig.getAppSource());
                if (null != ssoInfoMap && StringUtils.isNotEmpty((String)((String)ssoInfoMap.get("appId")))) {
                    params.put("appId", ((String)ssoInfoMap.get("appId")).toString());
                }
                this.thirdMessagePullTaskJob.addJob(params);
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("add application error. addThirdMessageConfigReq:{}", (Object)saveThirdMessageConfigReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/third/message/saveApplication");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/receive"})
    public ResponseEntity<BaseResultDTO<Boolean>> receiveMessage(@RequestBody @Valid ReceiveThirdMessageReq receiveThirdMessageReq) {
        try {
            log.info("receive message. param:{}", (Object)receiveThirdMessageReq);
            String appCode = AesUtil.decrypt((String)receiveThirdMessageReq.getAppCode());
            log.info("AesUtil decrypt appCode. result:{}", (Object)appCode);
            List thirdMessageConfigList = this.thirdSystemMessageService.queryConfigByAppCode(appCode, receiveThirdMessageReq.getAppId());
            if (CollectionUtils.isEmpty((Collection)thirdMessageConfigList)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)"\u5f53\u524d\u5e94\u7528\u4e0d\u5728\u914d\u7f6e\u4e2d\uff0c\u65e0\u6743\u63a8\u9001\u6d88\u606f");
            }
            List filteredList = thirdMessageConfigList.stream().filter(x -> Constants.VALID_STATUS_ENABLE.equals(x.getValidStatus())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(filteredList)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)"\u5f53\u524d\u5e94\u7528\u672a\u542f\u7528\uff0c\u65e0\u6743\u63a8\u9001\u6d88\u606f");
            }
            String sendChannel = ((ThirdMessageConfig)filteredList.get(0)).getSendChannel();
            receiveThirdMessageReq.setSendChannel(sendChannel);
            for (ThirdMessageInfo info : receiveThirdMessageReq.getMessageList()) {
                if (StringUtils.isEmpty((String)info.getMessageId())) {
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)"\u6d88\u606fid\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((String)info.getMessagePublishTime())) {
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)"\u6d88\u606f\u53d1\u5e03\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!DateUtils.validateDate((String)info.getMessagePublishTime(), (String)"yyyy-MM-dd HH:mm:ss")) {
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)"\u6d88\u606f\u53d1\u5e03\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
                }
                if (StringUtils.isEmpty((String)info.getMessageTitle()) && StringUtils.isEmpty((String)info.getMessageContent())) {
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)"\u6d88\u606f\u6807\u9898\u548c\u6d88\u606f\u5185\u5bb9\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
                }
                if (!Objects.isNull(info.getSideType())) continue;
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)"\u6d88\u606f\u7aef\u4e0d\u80fd\u4e3a\u7a7a");
            }
            receiveThirdMessageReq.setAppCode(appCode);
            this.thirdSystemMessageService.receiveMessage(receiveThirdMessageReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("receive message error. param:{}", (Object)receiveThirdMessageReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/third/message/receive, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/queryUnreadCount"})
    public ResponseEntity<BaseResultDTO<Long>> queryUnreadCount(@RequestBody QueryThirdMessageListReq queryThirdMessageListReq) {
        try {
            Long count = this.thirdSystemMessageService.queryUnreadCount(queryThirdMessageListReq.getClientType());
            return ResponseEntityWrapperUtil.wrapperOk((Object)count);
        }
        catch (Exception e) {
            log.error("query unread count error", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/third/message/queryUnreadCount");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/queryMessageListPage"})
    public ResponseEntity<BaseResultDTO<PageInfoResp<ThirdMessageInfo>>> queryMessageListPage(@RequestBody @Valid QueryThirdMessageListReq queryThirdMessageListReq) {
        if (StringUtils.isBlank((String)queryThirdMessageListReq.getAppId())) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"appId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageInfoResp messageInfoListPage = this.thirdSystemMessageService.queryMessageListPage(queryThirdMessageListReq);
        return ResponseEntityWrapperUtil.wrapperOk((Object)messageInfoListPage);
    }

    @PostMapping(value={"/readMessage"})
    public ResponseEntity<BaseResultDTO<Boolean>> readMessage(@RequestBody ReadThirdMessageReq readThirdMessageReq) {
        try {
            this.thirdSystemMessageService.readMessage(readThirdMessageReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("read message list error. readThirdMessageReq:{}", (Object)readThirdMessageReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/third/message/readMessage");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/deleteBatch"})
    public ResponseEntity<BaseResultDTO<Boolean>> deleteBatch(@RequestBody DeleteMessageConfigReq deleteMessageConfigReq) {
        try {
            QueryWrapper condition = new QueryWrapper();
            condition.in((Object)"id", (Collection)deleteMessageConfigReq.getIdList());
            condition.eq((Object)"valid_status", (Object)Constants.VALID_STATUS_ENABLE);
            List messageConfigList = this.thirdSystemMessageService.getBaseMapper().selectList((Wrapper)condition);
            if (CollectionUtils.isNotEmpty((Collection)messageConfigList)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)"\u5df2\u542f\u7528\u7684\u5e94\u7528\u4e0d\u80fd\u88ab\u5220\u9664");
            }
            if (CollectionUtils.isEmpty((Collection)deleteMessageConfigReq.getIdList())) {
                return ResponseEntityWrapperUtil.wrapperOk((Object)true);
            }
            List idList = deleteMessageConfigReq.getIdList();
            for (Long id : idList) {
                this.thirdMessagePullTaskJob.deleteJob("ThirdMessagePullTaskJob", "MessageJob_" + id);
            }
            this.thirdSystemMessageService.deleteBatchApp(deleteMessageConfigReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("read message list error. param:{}", (Object)deleteMessageConfigReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/third/message/deleteBatch");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/syncMessageData"})
    public ResponseEntity<?> syncMessageData() {
        try {
            return this.thirdSystemMessageService.syncMessageData();
        }
        catch (Exception e) {
            log.error("read message list error. readThirdMessageReq:{}", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/third/message/syncMessageData");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/readAllMessage"})
    public ResponseEntity<BaseResultDTO<Integer>> readAllMessage(@RequestBody QueryThirdMessageListReq queryThirdMessageListReq) {
        try {
            return this.thirdSystemMessageService.readAllMessage(queryThirdMessageListReq);
        }
        catch (Exception e) {
            log.error("readAllMessage error. e:{}", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/third/message/readAllMessage");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/queryMessageAppList"})
    public ResponseEntity<BaseResultDTO<List<MessageAppNumResp>>> queryMessageAppList(@RequestBody QueryThirdMessageListReq queryThirdMessageListReq) {
        List appNumRespList = this.thirdSystemMessageService.queryMessageAppList(queryThirdMessageListReq);
        return ResponseEntityWrapperUtil.wrapperOk((Object)appNumRespList);
    }

    @PostMapping(value={"/queryMessageType"})
    public ResponseEntity<BaseResultDTO<List<ThirdMessageType>>> queryMessageType() {
        List messageTypeList = this.thirdSystemMessageService.queryMessageType();
        return ResponseEntityWrapperUtil.wrapperOk((Object)messageTypeList);
    }

    @PostMapping(value={"/saveAppSort"})
    public ResponseEntity<BaseResultDTO<Boolean>> saveAppSort(@RequestBody List<String> appIdList) {
        this.thirdSystemMessageService.saveAppSort(appIdList);
        return ResponseEntityWrapperUtil.wrapperOk((Object)true);
    }

    @PostMapping(value={"/queryMessageCount"})
    public ResponseEntity<BaseResultDTO<MessageAppNumResp>> queryMessageCount(@RequestBody QueryThirdMessageListReq queryThirdMessageListReq) {
        if (StringUtils.isBlank((String)queryThirdMessageListReq.getAppId())) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"appId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MessageAppNumResp messageAppNumResp = this.thirdSystemMessageService.queryMessageCount(queryThirdMessageListReq);
        return ResponseEntityWrapperUtil.wrapperOk((Object)messageAppNumResp);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<BaseResultDTO<Boolean>> delete(@RequestBody DeleteMessageConfigReq deleteMessageConfigReq) {
        try {
            QueryWrapper condition = new QueryWrapper();
            condition.in((Object)"id", (Collection)deleteMessageConfigReq.getIdList());
            InterceptorIgnoreUtil.handler(() -> this.thirdMessageInfoService.remove((Wrapper)condition));
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("read message list error. param:{}", (Object)deleteMessageConfigReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/third/message/deleteBatch");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/deleteMessage"})
    public ResponseEntity<BaseResultDTO<Boolean>> deleteMessage(@RequestBody DeleteMessageConfigReq deleteMessageConfigReq) {
        QueryWrapper condition = new QueryWrapper();
        condition.in((Object)"id", (Collection)deleteMessageConfigReq.getIdList());
        this.thirdMessageInfoService.remove((Wrapper)condition);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"message_id", (Collection)deleteMessageConfigReq.getIdList());
        this.thirdMessageReadInfoService.remove((Wrapper)queryWrapper);
        return ResponseEntityWrapperUtil.wrapperOk((Object)true);
    }
}

