/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.mobile;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.service.mobile.MobileDataSourceAuthService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.mobile.MobileDataSourceAuthListResp;
import com.digiwin.athena.semc.vo.mobile.MobileDataSourceAuthQueryReq;
import com.digiwin.athena.semc.vo.mobile.MobileDataSourceAuthSaveReq;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/mobile/datasource/auth/"})
public class MobileDataSourceAuthController {
    private static final Logger logger = LoggerFactory.getLogger(MobileDataSourceAuthController.class);
    @Autowired
    MobileDataSourceAuthService mobileDataSourceAuthService;
    @Resource
    private MessageUtils messageUtils;

    @PostMapping(value={"/queryAuthList"})
    public ResponseEntity<BaseResultDTO<List<MobileDataSourceAuthListResp>>> queryAuthList(@RequestBody @Valid MobileDataSourceAuthQueryReq req) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.mobileDataSourceAuthService.queryAuthList(req));
        }
        catch (Exception e) {
            logger.error("queryAuthList exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @Operation(summary="\u4fdd\u5b58\u79fb\u52a8\u5e94\u7528-\u4f5c\u4e1a\u6743\u9650")
    @PostMapping(value={"/saveDatasourceAuth"})
    public ResponseEntity<BaseResultDTO<Integer>> saveDatasourceAuth(@RequestBody @Valid MobileDataSourceAuthSaveReq req) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.mobileDataSourceAuthService.saveDatasourceAuth(req));
        }
        catch (Exception e) {
            logger.error("saveDatasourceAuth exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }
}

