/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.mobile;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.dto.mobile.MobileClassificationReqDTO;
import com.digiwin.athena.semc.dto.news.AnnouncementIdReq;
import com.digiwin.athena.semc.dto.news.QueryAnnouncementTypeReq;
import com.digiwin.athena.semc.entity.mobile.MobileDatasourceClassification;
import com.digiwin.athena.semc.service.mobile.MobileDatasourceClassificationService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.mobile.MobileClassificatonResp;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/mobile/application/class"})
public class MobileDatasourceClassificationController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MobileDatasourceClassificationController.class);
    @Resource
    private MobileDatasourceClassificationService mobileDatasourceClassificationService;
    @Resource
    private MessageUtils messageUtils;
    private static final Integer MAX_COUNT = 20;

    @PostMapping(value={"/queryApplicationClassificationList"})
    public ResponseEntity<BaseResultDTO<List<MobileDatasourceClassification>>> queryApplicationClassificationList(@RequestBody QueryAnnouncementTypeReq queryAnnouncementTypeReq) {
        try {
            List mobileApplicationClassificationList = this.mobileDatasourceClassificationService.queryApplicationClassificationList();
            return ResponseEntityWrapperUtil.wrapperOk((Object)mobileApplicationClassificationList);
        }
        catch (Exception e) {
            log.error("query news type list error. param:{}", (Object)queryAnnouncementTypeReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/application/class/queryApplicationClassificationList, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/saveApplicationClassification"})
    public ResponseEntity<BaseResultDTO<Boolean>> saveApplicationClassification(@RequestBody @Valid MobileDatasourceClassification mobileApplicationClassification) {
        try {
            List applicationClassificationList = this.mobileDatasourceClassificationService.queryApplicationClassificationList();
            if (ObjectUtils.isEmpty((Object)mobileApplicationClassification.getId()) && applicationClassificationList.size() >= MAX_COUNT) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u5206\u7c7b\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc720\u4e2a");
            }
            List mobileApplicationClassificationList = this.mobileDatasourceClassificationService.existNameValid(mobileApplicationClassification.getId(), mobileApplicationClassification.getClassificationName());
            if (mobileApplicationClassificationList.size() > 0) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u8be5\u5e94\u7528\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728");
            }
            this.mobileDatasourceClassificationService.saveClassification(mobileApplicationClassification);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("save news type error. param:{}", (Object)mobileApplicationClassification, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/application/class/saveApplicationClassification, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/delApplicationClassification"})
    public ResponseEntity<BaseResultDTO<Boolean>> delApplicationClassification(@RequestBody @Valid AnnouncementIdReq announcementIdReq) {
        try {
            this.mobileDatasourceClassificationService.delApplicationClassification(announcementIdReq.getId());
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("delete news type error. param:{}", (Object)announcementIdReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/application/class/delApplicationClassification, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/getClassificationList"})
    public ResponseEntity<BaseResultDTO<List<MobileClassificatonResp>>> getClassificationList(@RequestBody MobileClassificationReqDTO reqDTO) {
        List result = this.mobileDatasourceClassificationService.getClassificationList(reqDTO.getIsAll());
        return ResponseEntityWrapperUtil.wrapperOk((Object)result);
    }

    @PostMapping(value={"/getClassificationListNew"})
    public ResponseEntity<BaseResultDTO<List<MobileClassificatonResp>>> getClassificationListNew(@RequestBody MobileClassificationReqDTO reqDTO) {
        List result = this.mobileDatasourceClassificationService.getClassificationList(reqDTO.getIsAll());
        return ResponseEntityWrapperUtil.wrapperOk((Object)result);
    }
}

