/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.mobile;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.VirtualApplicationEnum;
import com.digiwin.athena.semc.dto.mobile.CustomApplicationIdReq;
import com.digiwin.athena.semc.dto.mobile.CustomApplicationsListPageReq;
import com.digiwin.athena.semc.dto.mobile.SaveAppcationReq;
import com.digiwin.athena.semc.dto.mobile.UpdateAppcationConfigReq;
import com.digiwin.athena.semc.dto.mobile.UpdateAppcationStatusReq;
import com.digiwin.athena.semc.dto.news.DeleteNewsOrTypeReq;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.mobile.MobileDatasourceInfo;
import com.digiwin.athena.semc.mapper.mobile.MobileDatasourceInfoMapper;
import com.digiwin.athena.semc.service.applink.AppLinkService;
import com.digiwin.athena.semc.service.mobile.MobileDatasourceInfoService;
import com.digiwin.athena.semc.service.mobile.MobilePortalService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.common.PermissionUserFunctionalDTO;
import com.digiwin.athena.semc.vo.common.UserApplicationModulesDTO;
import com.digiwin.athena.semc.vo.common.UserApplicationSimpleDTO;
import com.digiwin.athena.semc.vo.mobile.MobileDatasourceInfoVO;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/mobile/application"})
public class MobileDatasourceInfoController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MobileDatasourceInfoController.class);
    @Resource
    private MobileDatasourceInfoService mobileDatasourceInfoService;
    @Autowired
    private MobilePortalService mobilePortalService;
    @Autowired
    private MobileDatasourceInfoMapper mobileDatasourceInfoMapper;
    @Autowired
    private AppLinkService appLinkService;
    @Resource
    private MessageUtils messageUtils;
    @Autowired
    private LabelSystemDataService labelSystemDataService;

    @PostMapping(value={"/queryCustomApplicationsByPage"})
    public ResponseEntity<BaseResultDTO<PageInfoResp<MobileDatasourceInfoVO>>> queryCustomApplicationsByPage(@RequestBody @Valid CustomApplicationsListPageReq customApplicationsListPageReq) {
        try {
            PageInfoResp pageInfoResp = this.mobileDatasourceInfoService.queryCustomApplicationsByPage(customApplicationsListPageReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)pageInfoResp);
        }
        catch (Exception e) {
            log.error("query custom applications by page error. param:{}", (Object)customApplicationsListPageReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/application/queryCustomApplicationsByPage, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/updateStatus"})
    public ResponseEntity<BaseResultDTO<Boolean>> updateStatus(@RequestBody @Valid UpdateAppcationStatusReq updateAppcationStatusReq) {
        try {
            if (Constants.MobileDatasourceInfoStatusEnum.UNUSABLE.getFlag().equals(updateAppcationStatusReq.getStatus())) {
                List mobilePortalInfoContents = this.mobilePortalService.checkContentApp(updateAppcationStatusReq.getIdList());
                if (CollectionUtils.isNotEmpty((Collection)mobilePortalInfoContents)) {
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.mobile.custom.application.status.close"));
                }
                List workCodeList = updateAppcationStatusReq.getIdList().stream().map(Object::toString).collect(Collectors.toList());
                List systemDataList = this.labelSystemDataService.getDataByWork(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType(), VirtualApplicationEnum.ATHENA_APP.getPrimaryId(), workCodeList);
                if (CollectionUtils.isNotEmpty((Collection)systemDataList)) {
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.mobile.custom.application.status.close"));
                }
            }
            this.mobileDatasourceInfoService.updateStatus(updateAppcationStatusReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("update status error. param:{}", (Object)updateAppcationStatusReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/application/updateStatus, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/delApplicationInfo"})
    public ResponseEntity<BaseResultDTO<Boolean>> delApplicationInfo(@RequestBody DeleteNewsOrTypeReq deleteNewsOrTypeReq) {
        try {
            if (CollectionUtils.isEmpty((Collection)deleteNewsOrTypeReq.getIdList())) {
                return ResponseEntityWrapperUtil.wrapperOk((Object)true);
            }
            QueryWrapper condition = new QueryWrapper();
            condition.in((Object)"id", (Collection)deleteNewsOrTypeReq.getIdList());
            condition.eq((Object)"status", (Object)Constants.MobileDatasourceInfoStatusEnum.UNUSABLE.getFlag());
            List customApplicationList = this.mobileDatasourceInfoService.getBaseMapper().selectList((Wrapper)condition);
            if (CollectionUtils.isNotEmpty((Collection)customApplicationList)) {
                deleteNewsOrTypeReq.setIdList(customApplicationList.stream().map(MobileDatasourceInfo::getId).collect(Collectors.toList()));
                this.mobileDatasourceInfoService.delApplicationInfo(deleteNewsOrTypeReq.getIdList());
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("delete applicationInfo error. param:{}", (Object)deleteNewsOrTypeReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/application/delApplicationInfo, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/queryCustomApplicationDetail"})
    public ResponseEntity<BaseResultDTO<MobileDatasourceInfoVO>> queryCustomApplicationDetail(@RequestBody @Valid CustomApplicationIdReq customApplicationIdReq) {
        try {
            MobileDatasourceInfo mobileCustomApplication = (MobileDatasourceInfo)this.mobileDatasourceInfoService.getBaseMapper().selectById((Serializable)customApplicationIdReq.getId());
            if (ObjectUtils.isEmpty((Object)mobileCustomApplication)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u81ea\u5b9a\u4e49\u5e94\u7528\u4e0d\u5b58\u5728");
            }
            MobileDatasourceInfoVO mobileCustomApplicationVO = this.mobileDatasourceInfoService.queryCustomApplicationDetail(customApplicationIdReq.getId());
            return ResponseEntityWrapperUtil.wrapperOk((Object)mobileCustomApplicationVO);
        }
        catch (Exception e) {
            log.error("query news detail error. param:{}", (Object)customApplicationIdReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/application/queryCustomApplicationDetail, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/saveCustomApplication"})
    public ResponseEntity<BaseResultDTO<Boolean>> saveCustomApplication(@RequestBody @Valid SaveAppcationReq saveAppcationReq) {
        try {
            if (Constants.MobileDataSourceTye.MOBILE_THIRD_APPLICATION.getValue().equals(saveAppcationReq.getType()) && (ObjectUtils.isEmpty((Object)saveAppcationReq.getApplicationPrimaryId()) || ObjectUtils.isEmpty((Object)saveAppcationReq.getApplicationSource()))) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-missing"));
            }
            if (Constants.MobileDataSourceTye.DIGIWIN_NOT_ATHENA_APPLICATION.getValue().equals(saveAppcationReq.getType()) && StringUtils.isEmpty((CharSequence)saveAppcationReq.getApplicationConfig())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-missing"));
            }
            Integer isExistData = this.mobileDatasourceInfoService.countByParam(saveAppcationReq);
            if (isExistData > 0) {
                String error = this.messageUtils.getMessage("error.message.job.bench.name.repeat");
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
            this.mobileDatasourceInfoService.saveCustomApplication(saveAppcationReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("save news error. param: {}", (Object)saveAppcationReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/application/saveCustomApplication, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/queryDatasourceInfo"})
    public ResponseEntity<BaseResultDTO<List<MobileDatasourceInfo>>> queryDatasourceInfo(@RequestBody @Valid CustomApplicationsListPageReq customApplicationReq) {
        try {
            customApplicationReq.setStatus(Constants.VALID_STATUS_ENABLE);
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.mobileDatasourceInfoService.queryDatasourceInfo(customApplicationReq));
        }
        catch (Exception e) {
            log.error("queryDatasourceInfo error. param:{}", (Object)customApplicationReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/application/queryDatasourceInfo, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/queryApplicationByUser"})
    public ResponseEntity<BaseResultDTO<List<UserApplicationSimpleDTO>>> queryApplicationByUser() {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.mobileDatasourceInfoService.queryApplicationByUser());
        }
        catch (Exception e) {
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/application/queryApplicationByUser, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Deprecated
    @PostMapping(value={"/queryModuleByApplication"})
    public ResponseEntity<BaseResultDTO<List<UserApplicationModulesDTO>>> queryModuleByApplication(@RequestBody @Valid PermissionUserFunctionalDTO permissionUserFunctionalDTO) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.mobileDatasourceInfoService.queryModuleByApplication(permissionUserFunctionalDTO));
        }
        catch (Exception e) {
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/application/queryModuleByApplication, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/queryWorkByApplication"})
    public ResponseEntity<BaseResultDTO<List<PermissionUserFunctionalDTO>>> queryWorkByApplication(@RequestBody @Valid PermissionUserFunctionalDTO permissionUserFunctionalDTO) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.mobileDatasourceInfoService.queryWorkByApplication(permissionUserFunctionalDTO));
        }
        catch (Exception e) {
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/application/queryWorkByApplication, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/updateConfig"})
    public ResponseEntity<BaseResultDTO<Boolean>> updateConfig(@RequestBody @Valid UpdateAppcationConfigReq updateAppcationConfigReq) {
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"iam_work_id", (Object)updateAppcationConfigReq.getIamWorkId());
            queryWrapper.ne((Object)"id", (Object)updateAppcationConfigReq.getId());
            List mobileDatasourceInfos = this.mobileDatasourceInfoMapper.selectList((Wrapper)queryWrapper);
            if (!CollectionUtils.isEmpty((Collection)mobileDatasourceInfos)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.UPDATE_FAILED, (String)this.messageUtils.getMessage("error.message.mobile.work.exist"));
            }
            this.mobileDatasourceInfoService.updateConfig(updateAppcationConfigReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("update status error. param:{}", (Object)updateAppcationConfigReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/application/updateConfig, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/applicationDropdownList"})
    public ResponseEntity<BaseResultDTO<List<AppLinkDTO>>> applicationDropdownList() {
        try {
            List appLinkListDTO = this.appLinkService.queryManageList(AppAuthContextHolder.getContext().getAuthoredUser());
            return ResponseEntityWrapperUtil.wrapperOk(appLinkListDTO.stream().filter(x -> Constants.APP_TYPE_BS.equals(x.getSystemType())).collect(Collectors.toList()));
        }
        catch (Exception e) {
            log.error("applicationDropdownList error:", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/application/applicationDropdownList, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

