/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.mobile;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.controller.portal.PortalInfoController;
import com.digiwin.athena.semc.dto.mobile.ApplicationColumnReq;
import com.digiwin.athena.semc.dto.mobile.ApplicationColumnReqNew;
import com.digiwin.athena.semc.dto.mobile.MobilePortalDetailReqDTO;
import com.digiwin.athena.semc.dto.mobile.MobileSSOReq;
import com.digiwin.athena.semc.dto.mobile.ValidMobileAppAuthReqDTO;
import com.digiwin.athena.semc.dto.mobile.ValidMobileAppAuthRespDTO;
import com.digiwin.athena.semc.dto.portal.PortalInfoCheckResp;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.mobile.MobileApplicatonColumn;
import com.digiwin.athena.semc.entity.mobile.MobileApplicatonColumnNew;
import com.digiwin.athena.semc.entity.mobile.MobilePortalInfo;
import com.digiwin.athena.semc.entity.mobile.MobilePortalTypeUse;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.mapper.mobile.MobileApplicatonColumnMapper;
import com.digiwin.athena.semc.mapper.mobile.MobileApplicatonColumnNewMapper;
import com.digiwin.athena.semc.mapper.mobile.MobilePortalInfoUseMapper;
import com.digiwin.athena.semc.mapper.mobile.MobilePortalTypeUserMapper;
import com.digiwin.athena.semc.mapper.portal.PortalInfoUseMapper;
import com.digiwin.athena.semc.service.mobile.MobilePortalService;
import com.digiwin.athena.semc.service.mobile.MobileUserAuthService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.mobile.FullBackResp;
import com.digiwin.athena.semc.vo.mobile.MobileAppColumnResp;
import com.digiwin.athena.semc.vo.mobile.MobilePortalInfoResp;
import com.digiwin.athena.semc.vo.portal.PortalUserAuthResp;
import com.google.common.collect.Maps;
import io.swagger.v3.oas.annotations.Operation;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/mobile/portal"})
public class MobilePortalAppController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MobilePortalAppController.class);
    private static final Logger logger = LoggerFactory.getLogger(PortalInfoController.class);
    @Autowired
    private MobilePortalService mobilePortalService;
    @Autowired
    private MobilePortalTypeUserMapper mobilePortalTypeUserMapper;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private MobilePortalInfoUseMapper mobilePortalInfoUseMapper;
    @Resource
    private MobileApplicatonColumnMapper applicatonColumnMapper;
    @Resource
    MobileUserAuthService mobileUserAuthService;
    @Resource
    PortalInfoUseMapper portalInfoUseMapper;
    @Resource
    PortalInfoController portalInfoController;
    @Resource
    private MobileApplicatonColumnNewMapper mobileApplicatonColumnNewMapper;

    @Operation(method="selectUserPortal", summary="\u67e5\u8be2\u7528\u6237\u804c\u80fd\u95e8\u6237\u5217\u8868")
    @PostMapping(value={"/info/userAuth/selectUserPortal"})
    public ResponseEntity<BaseResultDTO<List<PortalUserAuthResp>>> selectUserPortal() {
        PortalInfo portalInfo = new PortalInfo();
        portalInfo.setClientType(Constants.ClientTypeEnum.MOBILE.getValue());
        return this.portalInfoController.selectUserPortal(portalInfo);
    }

    @Operation(method="getPortalInfo", description="\u83b7\u53d6\u95e8\u6237\u8be6\u60c5")
    @PostMapping(value={"/info/getPortalInfo"})
    public ResponseEntity<?> getPortalInfo(@RequestBody MobilePortalDetailReqDTO req) {
        if (req.getScene() == 0) {
            MobilePortalInfoResp mobilePortalInfoResp = this.mobilePortalService.getPortalInfo(req.getId(), req.getScene());
            if (null == mobilePortalInfoResp && req.getPortalType().equals(Constants.MobilePortalTypeEnum.PORTAL.getFlag())) {
                mobilePortalInfoResp = new MobilePortalInfoResp();
                String recentlyMsg = this.messageUtils.getMessage("error.message.not.auth");
                mobilePortalInfoResp.setRecentlyMsg(recentlyMsg);
                return ResponseEntityWrapperUtil.wrapperOk((Object)mobilePortalInfoResp);
            }
            if (null == mobilePortalInfoResp && req.getPortalType().equals(Constants.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag())) {
                String recentlyMsg = this.messageUtils.getMessage("error.message.mobile.portal.custom.del");
                return ResponseEntityWrapperUtil.wrapperOk((Object)recentlyMsg);
            }
            if (mobilePortalInfoResp.getPortalType().equals(Constants.MobilePortalTypeEnum.PORTAL.getFlag()) && mobilePortalInfoResp.getStatus().equals(Constants.ReleaseEnum.NO_RELEASE.getVal())) {
                String recentlyMsg = this.messageUtils.getMessage("error.message.not.auth");
                mobilePortalInfoResp.setRecentlyMsg(recentlyMsg);
                return ResponseEntityWrapperUtil.wrapperOk((Object)mobilePortalInfoResp);
            }
            if (mobilePortalInfoResp.getPortalType().equals(Constants.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag()) && mobilePortalInfoResp.getStatus().equals(Constants.ReleaseEnum.NO_RELEASE.getVal())) {
                String recentlyMsg = this.messageUtils.getMessage("error.message.mobile.portal.custom.del");
                return ResponseEntityWrapperUtil.wrapperOk((Object)recentlyMsg);
            }
            try {
                return ResponseEntityWrapperUtil.wrapperOk((Object)this.mobilePortalService.getPortalDetail(mobilePortalInfoResp));
            }
            catch (Exception e) {
                log.error("getPortalInfo exception {}", (Object)e.getMessage());
                String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/portal/info/getPortalInfo");
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
            }
        }
        MobilePortalInfoResp result = this.mobilePortalService.getPreMobilePortal(req.getId());
        return ResponseEntityWrapperUtil.wrapperOk((Object)result);
    }

    @PostMapping(value={"/addPortalType"})
    public ResponseEntity<BaseResultDTO<Boolean>> addPortalType(@RequestBody MobilePortalTypeUse typeUse) {
        if (ObjectUtils.isEmpty((Object)typeUse.getPortalType())) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u672a\u4f20\u5165\u76f8\u5173\u7684\u53c2\u6570");
        }
        if (typeUse.getPortalType() == 1 && ObjectUtils.isEmpty((Object)typeUse.getMobilePortalId())) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u672a\u4f20\u5165\u76f8\u5173\u7684\u53c2\u6570");
        }
        Boolean flag = this.mobilePortalService.saveMobilePortalTypeUse(typeUse);
        return ResponseEntityWrapperUtil.wrapperOk((Object)flag);
    }

    @Operation(method="checkPortalInfo", description="\u6821\u9a8c\u95e8\u6237\u6743\u9650")
    @PostMapping(value={"/info/checkPortalInfo"})
    public ResponseEntity<?> checkPortalInfo(@RequestBody MobilePortalInfo req) {
        if (null == req.getId()) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"id  cannot be empty");
        }
        PortalInfoCheckResp checkResp = new PortalInfoCheckResp();
        checkResp.setIsHavePort(Boolean.valueOf(false));
        MobilePortalInfo portalInfo = (MobilePortalInfo)this.mobilePortalService.getById((Serializable)req.getId());
        if (null == portalInfo && req.getPortalType().equals(Constants.MobilePortalTypeEnum.PORTAL.getFlag())) {
            checkResp.setErrorMsg(this.messageUtils.getMessage("error.message.not.auth"));
            return ResponseEntityWrapper.wrapperOk((Object)checkResp);
        }
        if (null == portalInfo && req.getPortalType().equals(Constants.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag())) {
            checkResp.setErrorMsg(this.messageUtils.getMessage("error.message.mobile.portal.custom.del"));
            return ResponseEntityWrapper.wrapperOk((Object)checkResp);
        }
        checkResp.setPortalName(portalInfo.getName());
        if (portalInfo.getPortalType().equals(Constants.MobilePortalTypeEnum.PORTAL.getFlag()) && portalInfo.getStatus().equals(Constants.ReleaseEnum.NO_RELEASE.getVal())) {
            checkResp.setErrorMsg(this.messageUtils.getMessage("error.message.not.auth"));
            return ResponseEntityWrapper.wrapperOk((Object)checkResp);
        }
        if (portalInfo.getPortalType().equals(Constants.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag()) && portalInfo.getStatus().equals(Constants.ReleaseEnum.NO_RELEASE.getVal())) {
            checkResp.setErrorMsg(this.messageUtils.getMessage("error.message.mobile.portal.custom.del"));
            return ResponseEntityWrapper.wrapperOk((Object)checkResp);
        }
        if (portalInfo.getDefaultFlag() == 1) {
            checkResp.setIsHavePort(Boolean.valueOf(true));
            return ResponseEntityWrapper.wrapperOk((Object)checkResp);
        }
        try {
            return this.mobilePortalService.checkPortalInfo(portalInfo);
        }
        catch (Exception e) {
            log.error("checkPortalInfo exception {}", (Object)e.getMessage());
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobilePortal/info/getPortalInfo");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/saveApplicationColumn"})
    public ResponseEntity<?> saveApplicationColumn(@RequestBody @Valid ApplicationColumnReq applicationColumnReq) {
        try {
            this.mobilePortalService.saveApplicationColumn(applicationColumnReq);
        }
        catch (Exception e) {
            log.error("saveApplicationColumn error{}", (Object)e.getMessage());
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobilePortal/info/saveApplicationColumn");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/saveApplicationColumnNew"})
    public ResponseEntity<?> saveApplicationColumnNew(@RequestBody @Valid ApplicationColumnReqNew applicationColumnReqNew) {
        try {
            this.mobilePortalService.saveApplicationColumnNew(applicationColumnReqNew);
        }
        catch (Exception e) {
            log.error("saveApplicationColumnNew error{}", (Object)e.getMessage());
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobilePortal/info/saveApplicationColumnNew");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/getApplicationColumnList"})
    public ResponseEntity<BaseResultDTO<List<MobileAppColumnResp>>> getApplicationColumnList() {
        try {
            ArrayList result = this.mobilePortalService.getApplicationColumnList();
            if (CollectionUtils.isEmpty((Collection)result)) {
                result = new ArrayList();
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)result);
        }
        catch (Exception e) {
            log.error("getApplicationColumnList error{}", (Object)e.getMessage());
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobilePortal/info/getPortalInfo");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/getApplicationColumnListNew"})
    public ResponseEntity<BaseResultDTO<List<MobileAppColumnResp>>> getApplicationColumnListNew() {
        try {
            ArrayList result = this.mobilePortalService.getApplicationColumnListNew();
            if (CollectionUtils.isEmpty((Collection)result)) {
                result = new ArrayList();
            }
            for (MobileAppColumnResp mobileAppColumnResp : result) {
                MobileApplicatonColumnNew mobileApplicatonColumn = new MobileApplicatonColumnNew();
                mobileApplicatonColumn.setId(mobileAppColumnResp.getId());
                MobileAppColumnResp applicationColumnDetail = this.mobilePortalService.getApplicationColumnDetailNew(mobileApplicatonColumn);
                mobileAppColumnResp.setMobileCustomAppList(applicationColumnDetail.getMobileCustomAppList());
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getCreateUserId, (Object)Utils.getUserId())).isNotNull(MobileApplicatonColumnNew::getCustomApplicationId)).eq(MobileApplicatonColumnNew::getParentId, (Object)mobileApplicatonColumn.getId());
                List mobileApplicatonColumns = this.mobileApplicatonColumnNewMapper.selectList((Wrapper)queryWrapper);
                ArrayList<HashMap> ids = new ArrayList<HashMap>();
                for (MobileApplicatonColumnNew mobileApplicatonColumnNew : mobileApplicatonColumns) {
                    HashMap map = Maps.newHashMap();
                    map.put("id", mobileApplicatonColumnNew.getCustomApplicationId());
                    map.put("source", mobileApplicatonColumnNew.getSource());
                    map.put("moduleId", mobileApplicatonColumnNew.getModuleId());
                    ids.add(map);
                }
                mobileAppColumnResp.setIdAndSources(ids);
            }
            return ResponseEntityWrapperUtil.wrapperOk(result);
        }
        catch (Exception e) {
            log.error("getApplicationColumnListNew error{}", (Object)e.getMessage());
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobilePortal/info/getApplicationColumnListNew");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/getApplicationColumnDetail"})
    public ResponseEntity<BaseResultDTO<MobileAppColumnResp>> getApplicationColumnDetail(@RequestBody ApplicationColumnReq applicationColumnReq) {
        try {
            if (ObjectUtils.isEmpty((Object)applicationColumnReq.getId())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"id  cannot be empty");
            }
            MobileApplicatonColumn mobileApplicatonColumn = (MobileApplicatonColumn)this.applicatonColumnMapper.selectById((Serializable)applicationColumnReq.getId());
            if (ObjectUtils.isEmpty((Object)mobileApplicatonColumn)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)"\u4e0d\u5b58\u5728\u6b64\u81ea\u5b9a\u4e49\u680f\u76ee");
            }
            MobileAppColumnResp result = this.mobilePortalService.getApplicationColumnDetail(mobileApplicatonColumn);
            return ResponseEntityWrapperUtil.wrapperOk((Object)result);
        }
        catch (Exception e) {
            log.error("get application column detail error. param:{}", (Object)applicationColumnReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/portal/getApplicationColumnDetail:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/setColumnOrder"})
    public ResponseEntity<?> setColumnOrder(@RequestBody List<Long> columnIds) {
        if (CollectionUtils.isEmpty(columnIds)) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"columnIds  cannot be empty");
        }
        try {
            this.mobilePortalService.setColumnOrder(columnIds);
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            log.error("set column order error. param:{}", columnIds, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/portal/setColumnOrder:" + e.getMessage());
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/setColumnOrderNew"})
    public ResponseEntity<?> setColumnOrderNew(@RequestBody List<Long> columnIds) {
        if (CollectionUtils.isEmpty(columnIds)) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"columnIds  cannot be empty");
        }
        try {
            this.mobilePortalService.setColumnOrderNew(columnIds);
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            log.error("set column order error. param:{}", columnIds, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/portal/setColumnOrder:" + e.getMessage());
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/getApplicationColumnDetailNew"})
    public ResponseEntity<BaseResultDTO<MobileAppColumnResp>> getApplicationColumnDetailNew(@RequestBody ApplicationColumnReq applicationColumnReq) {
        try {
            if (ObjectUtils.isEmpty((Object)applicationColumnReq.getId())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"id  cannot be empty");
            }
            MobileApplicatonColumnNew mobileApplicatonColumn = (MobileApplicatonColumnNew)this.mobileApplicatonColumnNewMapper.selectById((Serializable)applicationColumnReq.getId());
            if (ObjectUtils.isEmpty((Object)mobileApplicatonColumn)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)"\u4e0d\u5b58\u5728\u6b64\u81ea\u5b9a\u4e49\u680f\u76ee");
            }
            MobileAppColumnResp result = this.mobilePortalService.getApplicationColumnDetailNew(mobileApplicatonColumn);
            return ResponseEntityWrapperUtil.wrapperOk((Object)result);
        }
        catch (Exception e) {
            log.error("get application column detail error. param:{}", (Object)applicationColumnReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/portal/getApplicationColumnDetail:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/delColumn"})
    public ResponseEntity<?> delColumn(@RequestBody List<Long> columnIds) {
        if (CollectionUtils.isEmpty(columnIds)) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"columnIds  cannot be empty");
        }
        try {
            this.mobilePortalService.delColumn(columnIds);
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            log.error("del column error. param:{}", columnIds, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/portal/delColumn:" + e.getMessage());
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/delColumnNew"})
    public ResponseEntity<?> delColumnNew(@RequestBody List<Long> columnIds) {
        if (CollectionUtils.isEmpty(columnIds)) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"columnIds  cannot be empty");
        }
        try {
            this.mobilePortalService.delColumnNew(columnIds);
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            log.error("del column error. param:{}", columnIds, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/portal/delColumn:" + e.getMessage());
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/updateColumnStatus"})
    public ResponseEntity<?> updateColumnStaus(@RequestBody ApplicationColumnReq applicationColumnReq) {
        if (ObjectUtils.isEmpty((Object)applicationColumnReq.getId())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"id  cannot be empty");
        }
        MobileApplicatonColumn mobileApplicatonColumn = (MobileApplicatonColumn)this.applicatonColumnMapper.selectById((Serializable)applicationColumnReq.getId());
        if (ObjectUtils.isEmpty((Object)mobileApplicatonColumn)) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)"\u4f60\u6240\u9009\u5219\u7684\u680f\u76ee\u4e0d\u5b58\u5728");
        }
        if (ObjectUtils.isEmpty((Object)applicationColumnReq.getStatus())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"status cannot be empty");
        }
        try {
            mobileApplicatonColumn.setStatus(applicationColumnReq.getStatus());
            this.applicatonColumnMapper.updateById((Object)mobileApplicatonColumn);
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            log.error("update column status error. param:{}", (Object)applicationColumnReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/portal/updateColumnStatus:" + e.getMessage());
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/updateColumnStatusNew"})
    public ResponseEntity<?> updateColumnStausNew(@RequestBody ApplicationColumnReq applicationColumnReq) {
        if (ObjectUtils.isEmpty((Object)applicationColumnReq.getId())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"id  cannot be empty");
        }
        MobileApplicatonColumnNew mobileApplicatonColumn = (MobileApplicatonColumnNew)this.mobileApplicatonColumnNewMapper.selectById((Serializable)applicationColumnReq.getId());
        if (ObjectUtils.isEmpty((Object)mobileApplicatonColumn)) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)"\u4f60\u6240\u9009\u5219\u7684\u680f\u76ee\u4e0d\u5b58\u5728");
        }
        if (ObjectUtils.isEmpty((Object)applicationColumnReq.getStatus())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"status cannot be empty");
        }
        try {
            mobileApplicatonColumn.setStatus(applicationColumnReq.getStatus());
            this.mobileApplicatonColumnNewMapper.updateById((Object)mobileApplicatonColumn);
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            log.error("update column status error. param:{}", (Object)applicationColumnReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/portal/updateColumnStausNew:" + e.getMessage());
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/getFullCallBackUrl"})
    public ResponseEntity<BaseResultDTO<FullBackResp>> getFullCallBackUrl(@RequestBody @Valid MobileSSOReq mobileSSOReq) {
        try {
            FullBackResp fullCallBackUrl = this.mobilePortalService.getFullCallBackUrl(mobileSSOReq);
            if (ObjectUtils.isEmpty((Object)fullCallBackUrl)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u4f60\u7ed1\u5b9a\u7684\u5e94\u7528\u4e0d\u5b58\u5728");
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)fullCallBackUrl);
        }
        catch (Exception e) {
            log.error("get full callBackUrl error. param:{}", (Object)mobileSSOReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/portal/getFullCallBackUrl:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/validUserAppAuth"})
    public ResponseEntity<BaseResultDTO<List<ValidMobileAppAuthRespDTO>>> validUserAppAuth(@RequestBody @Valid ValidMobileAppAuthReqDTO validMobileAppAuthDTO) {
        List applicationIdList = this.mobileUserAuthService.validUserAppAuth(validMobileAppAuthDTO.getCustomApplicationIdList());
        List respList = validMobileAppAuthDTO.getCustomApplicationIdList().stream().map(x -> {
            ValidMobileAppAuthRespDTO respDTO = new ValidMobileAppAuthRespDTO();
            respDTO.setCustomApplicationId(x);
            if (applicationIdList.contains(x)) {
                respDTO.setAuthFlag(Boolean.valueOf(true));
            }
            return respDTO;
        }).collect(Collectors.toList());
        return ResponseEntityWrapperUtil.wrapperOk(respList);
    }
}

