/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.mobile;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.portal.PortalInfoQueryReq;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.mobile.MobilePortalInfo;
import com.digiwin.athena.semc.entity.mobile.MobilePortalInfoAuth;
import com.digiwin.athena.semc.entity.mobile.MobilePortalInfoContent;
import com.digiwin.athena.semc.entity.mobile.MobilePortalPreview;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.service.mobile.MobilePortalService;
import com.digiwin.athena.semc.service.portal.PortalInfoService;
import com.digiwin.athena.semc.service.workbench.constant.PublishSourceEnum;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.mobile.MobilePortalInfoAuthResp;
import com.digiwin.athena.semc.vo.mobile.MobilePortalInfoResp;
import com.digiwin.athena.semc.vo.portal.PortalInfoAuthReq;
import io.swagger.v3.oas.annotations.Operation;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/semc/mobile/portal/"})
public class MobilePortalWebController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MobilePortalWebController.class);
    @Autowired
    MobilePortalService mobilePortalService;
    @Autowired
    PortalInfoService portalInfoService;
    @Resource
    private MessageUtils messageUtils;

    @Operation(method="savePortal", description="\u4fdd\u5b58\u79fb\u52a8\u95e8\u6237")
    @PostMapping(value={"/info/savePortal"})
    public ResponseEntity<?> saveMobilePortal(@RequestBody @Valid MobilePortalInfo req) {
        List portalInfoList;
        if (null == req.getPortalType()) {
            req.setPortalType(Constants.MobilePortalTypeEnum.PORTAL.getFlag());
        }
        if (CollectionUtils.isNotEmpty((Collection)(portalInfoList = this.mobilePortalService.checkPortal(req)))) {
            String error = this.messageUtils.getMessage("error.message.job.bench.name.repeat");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
        }
        ResponseEntity checkResult = this.checkMobilePortal(req);
        if (null != checkResult) {
            return checkResult;
        }
        try {
            return ResponseEntityWrapper.wrapperOk((Object)this.mobilePortalService.savePortal(req));
        }
        catch (Exception e) {
            log.error("mobile savePortal exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/portal/info/savePortal");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    public ResponseEntity<?> checkMobilePortal(MobilePortalInfo req) {
        List contentList = req.getContentList();
        if (CollectionUtils.isEmpty((Collection)contentList)) {
            return null;
        }
        List taskDataList = contentList.stream().filter(item -> Constants.PrtalMobileContentTypeEnum.PRE_TASK.getVal().equals(item.getContentType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(taskDataList) && taskDataList.size() > 1) {
            String error = this.messageUtils.getMessage("error.message.mobile.portal.task.can.only.error");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
        }
        List projectDataList = contentList.stream().filter(item -> Constants.PrtalMobileContentTypeEnum.PRE_PROJECT.getVal().equals(item.getContentType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(projectDataList) && taskDataList.size() > 1) {
            String error = this.messageUtils.getMessage("error.message.mobile.portal.project.can.only.error");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
        }
        List districtList = contentList.stream().filter(item -> Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(item.getContentType())).collect(Collectors.toList());
        int customDistrict = 0;
        for (MobilePortalInfoContent district : districtList) {
            if (district.getCustomType().equals(Constants.DistrictCustomTypeEnum.USER_TYPE.getValue())) {
                ++customDistrict;
            }
            if (customDistrict > 1) {
                String error = this.messageUtils.getMessage("error.message.mobile.portal.custom.district.can.only.error");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
            if (!Constants.DistrictinteractionTypeEnum.EXPAND_ALL.getValue().equals(district.getInteractionType())) continue;
            district.setLineNum(null);
        }
        return null;
    }

    @Operation(method="/manage/pageQuery", description="\u67e5\u8be2\u79fb\u52a8\u95e8\u6237\u5217\u8868")
    @PostMapping(value={"/manage/pageQuery"})
    public ResultPageBean pageQuery(@RequestBody @Valid PortalInfoQueryReq req) {
        return this.mobilePortalService.pageQuery(req);
    }

    @Operation(method="updateStatus", description="\u6279\u91cf\u53d1\u5e03\u548c\u53d6\u6d88\u53d1\u5e03\u79fb\u52a8\u95e8\u6237")
    @PostMapping(value={"/info/updateStatus"})
    public ResponseEntity<?> updateStatus(@RequestBody PortalInfoQueryReq req) {
        if (CollectionUtils.isEmpty((Collection)req.getIdList())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"idList is null");
        }
        if (null == req.getStatus()) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"status is null");
        }
        try {
            this.mobilePortalService.updateBat(req);
        }
        catch (Exception e) {
            log.error("mobile updateStatus exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/portal/info/updateStatus");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    @Operation(method="batchDel", description="\u6279\u91cf\u5220\u9664\u5e03\u5c40\u79fb\u52a8\u95e8\u6237")
    @PostMapping(value={"info/batchDel"})
    public ResponseEntity<?> batchDel(@RequestBody PortalInfoQueryReq req) {
        if (CollectionUtils.isEmpty((Collection)req.getIdList())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"idList is null");
        }
        try {
            this.mobilePortalService.delBat(req);
        }
        catch (Exception e) {
            log.error("mobile batchDel exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/portal/info/batchDel");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    @Operation(summary="\u4fdd\u5b58\u79fb\u52a8\u95e8\u6237\u7ec4\u4ef6\u6743\u9650")
    @PostMapping(value={"/userAuth/savePortalAuth"})
    public ResponseEntity<BaseResultDTO<Integer>> savePortalAuth(@RequestBody @Valid PortalInfoAuthReq req) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.mobilePortalService.savePortalAuth(req));
        }
        catch (Exception e) {
            log.error("mobile savePortalAuth exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @Operation(summary="\u67e5\u8be2\u79fb\u52a8\u95e8\u6237\u6743\u9650\u4fe1\u606f")
    @PostMapping(value={"/userAuth/selectByPortal"})
    public ResponseEntity<BaseResultDTO<MobilePortalInfoAuthResp>> selectByPortal(@RequestBody MobilePortalInfoAuth req) {
        if (null == req.getId()) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"id  cannot be empty");
        }
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.mobilePortalService.selectByPortalAuth(req.getId()));
        }
        catch (Exception e) {
            log.error("mobile selectByPortal exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @Operation(method="getPortalDetail", description="\u83b7\u53d6\u95e8\u6237\u6570\u636e\u8be6\u60c5")
    @PostMapping(value={"/info/getPortalDetail"})
    public ResponseEntity<BaseResultDTO<MobilePortalInfoResp>> getPortalDetail(@RequestBody MobilePortalInfo req) {
        if (null == req.getId()) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"id  cannot be empty");
        }
        MobilePortalInfo portalInfo = (MobilePortalInfo)this.mobilePortalService.getById((Serializable)req.getId());
        if (null == portalInfo) {
            String recentlyMsg = this.messageUtils.getMessage("error.message.choose.portal.recovery");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)recentlyMsg);
        }
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.mobilePortalService.getMobilePortalDetail(portalInfo));
        }
        catch (Exception e) {
            log.error("mobile getPortalDetail exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/portal/info/getPortalDetail");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(method="getPreviewPortal", description="\u83b7\u53d6\u95e8\u6237\u6570\u636e\u8be6\u60c5")
    @PostMapping(value={"/info/getPreviewPortal"})
    public ResponseEntity<BaseResultDTO<MobilePortalPreview>> getPreviewPortal(@RequestBody MobilePortalInfo req) {
        if (null == req.getId()) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"id  cannot be empty");
        }
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.mobilePortalService.getPreviewPortal(req.getId()));
        }
        catch (Exception e) {
            log.error("mobile getPortalDetail exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/portal/info/getPortalDetail");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(method="previewPortal", description="\u9884\u89c8\u79fb\u52a8\u95e8\u6237")
    @PostMapping(value={"/info/previewPortal"})
    public ResponseEntity<BaseResultDTO<MobilePortalPreview>> previewPortal(@RequestBody @Valid MobilePortalInfo req) {
        MobilePortalPreview mobilePortalPreview;
        if (ObjectUtils.isNotEmpty((Object)req.getOldPortalFlag()) && Boolean.FALSE.equals(req.getOldPortalFlag())) {
            PortalInfo portalInfo = null;
            if (null != req.getId()) {
                if (Constants.LabelOrPoralSourceEnum.TENANT.getFlag().equals(req.getPortalTypeSource())) {
                    portalInfo = (PortalInfo)this.portalInfoService.getById((Serializable)req.getId());
                } else if (Constants.LabelOrPoralSourceEnum.ISV.getFlag().equals(req.getPortalTypeSource())) {
                    portalInfo = this.portalInfoService.queryPortalInfoByDesignerId(req.getPortalDesignerId());
                }
                if (null == portalInfo) {
                    String recentlyMsg = this.messageUtils.getMessage("error.message.choose.portal.recovery");
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)recentlyMsg);
                }
                PortalInfo pcPortalDetail = this.portalInfoService.getMobilePortalDetail(portalInfo);
                pcPortalDetail.setVersionDefault(portalInfo.getVersionDefault());
                MobilePortalPreview mobilePortalPreview2 = this.mobilePortalService.previewPortal(null, pcPortalDetail);
                mobilePortalPreview2.setVersionDefault(portalInfo.getVersionDefault());
                return ResponseEntityWrapperUtil.wrapperOk((Object)mobilePortalPreview2);
            }
            mobilePortalPreview = this.mobilePortalService.previewPortal(req, null);
            mobilePortalPreview.setVersionDefault(Integer.valueOf(1));
        } else {
            if (null != req.getId()) {
                MobilePortalInfo mobilePortalInfo = (MobilePortalInfo)this.mobilePortalService.getById((Serializable)req.getId());
                if (null == mobilePortalInfo) {
                    String recentlyMsg = this.messageUtils.getMessage("error.message.choose.portal.recovery");
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)recentlyMsg);
                }
                req = mobilePortalInfo;
                req.setOldPortalFlag(Boolean.valueOf(true));
            }
            mobilePortalPreview = this.mobilePortalService.previewPortal(req, null);
            mobilePortalPreview.setVersionDefault(Integer.valueOf(0));
        }
        return ResponseEntityWrapperUtil.wrapperOk((Object)mobilePortalPreview);
    }

    @Operation(method="listAllCustomPortal", description="\u67e5\u8be2\u5168\u90e8\u81ea\u5b9a\u4e49\u9875\u9762\u5e03\u5c40\u5217\u8868")
    @PostMapping(value={"/manage/listAllCustomPortal"})
    public ResponseEntity<BaseResultDTO<List<MobilePortalInfo>>> listAllCustomPortal() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PortalInfo::getPortalType, (Object)Constants.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag());
        queryWrapper.eq(PortalInfo::getTenantId, (Object)Utils.getTenantId());
        queryWrapper.orderByDesc(BaseEntity::getModifyTime);
        List portalList = this.portalInfoService.list((Wrapper)queryWrapper);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(MobilePortalInfo::getPortalType, (Object)Constants.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag());
        wrapper.orderByDesc(BaseEntity::getModifyTime);
        List portalInfoList = this.mobilePortalService.list((Wrapper)wrapper);
        for (MobilePortalInfo mobilePortalInfo : portalInfoList) {
            PortalInfo pcPortalInfo = MobilePortalWebController.mobilePortalConvertToPortal((MobilePortalInfo)mobilePortalInfo);
            portalList.add(pcPortalInfo);
        }
        return ResponseEntityWrapperUtil.wrapperOk((Object)portalInfoList);
    }

    private static PortalInfo mobilePortalConvertToPortal(MobilePortalInfo mobilePortalInfo) {
        PortalInfo pcPortalInfo = new PortalInfo();
        pcPortalInfo.setId(mobilePortalInfo.getId());
        pcPortalInfo.setPortalTypeSource(Constants.PortalTypeSourceEnum.TENANT.getFlag());
        pcPortalInfo.setClientType(Constants.ClientTypeTypeEnum.MOBILE.getFlag());
        pcPortalInfo.setPortalType(mobilePortalInfo.getPortalType());
        pcPortalInfo.setTitle(mobilePortalInfo.getTitle());
        pcPortalInfo.setBgColor(mobilePortalInfo.getBgColor());
        pcPortalInfo.setPortalDesignerId(null);
        pcPortalInfo.setWorkbenchAppCode(null);
        pcPortalInfo.setParentId(Long.valueOf(0L));
        pcPortalInfo.setTemplateId(null);
        pcPortalInfo.setDefaultFlag(mobilePortalInfo.getDefaultFlag());
        pcPortalInfo.setName(mobilePortalInfo.getName());
        pcPortalInfo.setPortalDesc(mobilePortalInfo.getPortalDesc());
        pcPortalInfo.setMenuTemplateId(null);
        pcPortalInfo.setStatus(mobilePortalInfo.getStatus());
        pcPortalInfo.setPortalContent(mobilePortalInfo.getPortalContent());
        pcPortalInfo.setPortalImgId(mobilePortalInfo.getPortalImgId());
        pcPortalInfo.setTenantId(mobilePortalInfo.getTenantId());
        pcPortalInfo.setCreateUserName(mobilePortalInfo.getName());
        pcPortalInfo.setCreateTime(mobilePortalInfo.getCreateTime());
        pcPortalInfo.setModifyUserName(mobilePortalInfo.getModifyUserName());
        pcPortalInfo.setModifyTime(mobilePortalInfo.getModifyTime());
        pcPortalInfo.setModifyUserId(mobilePortalInfo.getModifyUserId());
        pcPortalInfo.setPublishSource(PublishSourceEnum.TENANT.name());
        return pcPortalInfo;
    }

    @Operation(summary="\u590d\u5236\u95e8\u6237")
    @PostMapping(value={"info/copyPortal"})
    public ResponseEntity<BaseResultDTO<Integer>> copyPortal(@RequestBody MobilePortalInfo req) {
        try {
            if (null == req.getId()) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"id  cannot be empty");
            }
            MobilePortalInfo portalInfo = (MobilePortalInfo)this.mobilePortalService.getById((Serializable)req.getId());
            if (null == portalInfo) {
                String recentlyMsg = this.messageUtils.getMessage("error.message.choose.portal.recovery");
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)recentlyMsg);
            }
            req = portalInfo;
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.mobilePortalService.copyPortal(req));
        }
        catch (Exception e) {
            log.error("mobile copyPortal exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }
}

