/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.mobile;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.entity.mobile.MobileStartSet;
import com.digiwin.athena.semc.service.mobile.MobileStartSetService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import io.swagger.v3.oas.annotations.Operation;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/mobile/start/set/"})
public class MobileStartSetController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MobileStartSetController.class);
    @Autowired
    MobileStartSetService mobileStartSetService;
    @Resource
    private MessageUtils messageUtils;

    @Operation(method="saveSet", description="\u4fdd\u5b58\u542f\u52a8\u9875\u914d\u7f6e")
    @PostMapping(value={"saveSet"})
    public ResponseEntity<BaseResultDTO<MobileStartSet>> saveSet(@RequestBody @Valid MobileStartSet req) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.mobileStartSetService.saveStartSet(req));
        }
        catch (Exception e) {
            log.error("saveSet exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/start/set/saveSet");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(method="selectStartSetList", description="\u67e5\u8be2\u79df\u6237\u8bbe\u7f6e\u7684\u542f\u52a8\u9875\u914d\u7f6e\u63a5\u53e3")
    @PostMapping(value={"selectStartSetList"})
    public ResponseEntity<BaseResultDTO<List<MobileStartSet>>> selectStartSetList(@RequestBody MobileStartSet req) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.mobileStartSetService.selectStartSetList(req.getDeviceType()));
        }
        catch (Exception e) {
            log.error("selectStartSetList exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/start/set/selectStartSetList");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"selectAppStartSet"})
    public ResponseEntity<BaseResultDTO<List<MobileStartSet>>> selectAppStartSet() {
        try {
            List startSetList = this.mobileStartSetService.selectStartSetList(null);
            for (MobileStartSet startSet : startSetList) {
                if (startSet.getImgType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                    startSet.setPicUrl(startSet.getPicLocalUrl());
                }
                String locale = LocaleContextHolder.getLocale().toString();
                if (startSet.getImgType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag()) && "zh_TW".equals(locale)) {
                    startSet.setPicUrl(startSet.getPicUrlTw());
                }
                if (!startSet.getImgType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag()) || !"zh_CN".equals(locale)) continue;
                startSet.setPicUrl(startSet.getPicUrl());
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)startSetList);
        }
        catch (Exception e) {
            log.error("selectAppStartSet exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/start/set/selectAppStartSet");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

