/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.news;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.dto.news.SaveNewsAuthReq;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/news/auth"})
public class NewsAnnouncementAuthController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewsAnnouncementAuthController.class);
    @Resource
    private MessageUtils messageUtils;

    @PostMapping(value={"/saveNewsAuth"})
    public ResponseEntity<BaseResultDTO<Boolean>> saveNewsAuth(@RequestBody @Valid SaveNewsAuthReq saveNewsAuthReq) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("save news auth error. param:{}", (Object)saveNewsAuthReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/news/auth/saveNewsAuth, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @GetMapping(value={"/delNewsAuth"})
    public ResponseEntity<BaseResultDTO<Boolean>> delNewsAuth(@RequestParam Long id) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("del news auth error. id:{}", (Object)id, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/news/auth/delNewsAuth, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

