/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.news;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.enums.DataChangeTypeEnum;
import com.digiwin.athena.semc.common.enums.NewsAnnouncementPublishTypeEnum;
import com.digiwin.athena.semc.dto.news.AnnouncementIdReq;
import com.digiwin.athena.semc.dto.news.DeleteNewsOrTypeReq;
import com.digiwin.athena.semc.dto.news.MyNewsFavoritePageReq;
import com.digiwin.athena.semc.dto.news.NewLikeReqDTO;
import com.digiwin.athena.semc.dto.news.NewsCommonIdListReq;
import com.digiwin.athena.semc.dto.news.NewsCommonIdReq;
import com.digiwin.athena.semc.dto.news.NewsStatisticsReqDTO;
import com.digiwin.athena.semc.dto.news.NewsUpdateToppedStatusReq;
import com.digiwin.athena.semc.dto.news.NewsUserNewsDetailReq;
import com.digiwin.athena.semc.dto.news.QueryMobileNewsListPageReq;
import com.digiwin.athena.semc.dto.news.QueryNewsListPageReq;
import com.digiwin.athena.semc.dto.news.SaveAnnouncementReq;
import com.digiwin.athena.semc.dto.news.UpdateNewsStatusReq;
import com.digiwin.athena.semc.dto.news.WebQueryNewsListPageReq;
import com.digiwin.athena.semc.entity.news.NewsAnnouncement;
import com.digiwin.athena.semc.event.NewsAuthBizIdSetEvent;
import com.digiwin.athena.semc.event.NewsChangeEvent;
import com.digiwin.athena.semc.event.dto.NewsChangeEventDTO;
import com.digiwin.athena.semc.service.news.NewsAnnouncementFavoriteService;
import com.digiwin.athena.semc.service.news.NewsAnnouncementLikeService;
import com.digiwin.athena.semc.service.news.NewsAnnouncementReadService;
import com.digiwin.athena.semc.service.news.NewsAnnouncementService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.TrackingUtil;
import com.digiwin.athena.semc.vo.news.MyNewsAnnouncementFavoriteVO;
import com.digiwin.athena.semc.vo.news.NewsAnnouncementStatisticsVO;
import com.digiwin.athena.semc.vo.news.NewsAnnouncementVO;
import com.digiwin.athena.semc.vo.news.ValidateNewsVO;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/news"})
public class NewsAnnouncementController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewsAnnouncementController.class);
    @Resource
    private NewsAnnouncementService newsAnnouncementService;
    @Resource
    private NewsAnnouncementReadService newsAnnouncementReadService;
    @Resource
    private TrackingUtil trackingUtil;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private ApplicationEventPublisher eventPublisher;
    @Resource
    private NewsAnnouncementLikeService newsAnnouncementLikeService;
    @Resource
    private NewsAnnouncementFavoriteService newsAnnouncementFavoriteService;
    public static final int MAX_NEWS_COUNT = 1000;
    public static final int MAX_NEWS_FILE_COUNT = 5;

    @PostMapping(value={"/queryManagerNewsByPage"})
    public ResponseEntity<BaseResultDTO<PageInfoResp<NewsAnnouncementVO>>> queryManagerNewsByPage(@RequestBody @Valid QueryNewsListPageReq queryNewsListPageReq) {
        try {
            PageInfoResp pageInfoResp = this.newsAnnouncementService.queryNewsListByPage(queryNewsListPageReq);
            NewsAuthBizIdSetEvent newsAuthBizIdSetEvent = new NewsAuthBizIdSetEvent((Object)this, null);
            this.eventPublisher.publishEvent((ApplicationEvent)newsAuthBizIdSetEvent);
            return ResponseEntityWrapperUtil.wrapperOk((Object)pageInfoResp);
        }
        catch (Exception e) {
            log.error("query manager news by page error. param:{}", (Object)queryNewsListPageReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/news/queryManagerNewsByPage, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/queryManagerNewsStatistics"})
    public ResponseEntity<BaseResultDTO<NewsAnnouncementStatisticsVO>> queryManagerNewsStatistics(@RequestBody @Valid NewsStatisticsReqDTO newsStatisticsReqDTO) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.newsAnnouncementService.queryManagerNewsStatistics(newsStatisticsReqDTO));
    }

    @PostMapping(value={"/updatePublishStatus"})
    public ResponseEntity<BaseResultDTO<Boolean>> updatePublishStatus(@RequestBody @Valid UpdateNewsStatusReq updateNewsStatusReq) {
        List idList = updateNewsStatusReq.getIdList();
        List newsAnnouncementList = this.newsAnnouncementService.getBaseMapper().selectBatchIds((Collection)idList);
        this.newsAnnouncementService.updatePublishStatus(updateNewsStatusReq, newsAnnouncementList);
        this.trackingUtil.reportUserTrackForUpdatePublishStatus(updateNewsStatusReq);
        return ResponseEntityWrapperUtil.wrapperOk((Object)true);
    }

    @PostMapping(value={"/updateToppedStatus"})
    public ResponseEntity<BaseResultDTO<Boolean>> updateToppedStatus(@RequestBody @Valid NewsUpdateToppedStatusReq announcementIdReq) {
        if (ObjectUtils.isEmpty((Object)announcementIdReq.getToppedFlag())) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u662f\u5426\u7f6e\u9876\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        NewsAnnouncement newsAnnouncement = (NewsAnnouncement)this.newsAnnouncementService.getBaseMapper().selectById((Serializable)announcementIdReq.getId());
        if (newsAnnouncement == null) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u8be5\u516c\u544a\u4e0d\u5b58\u5728");
        }
        if (Constants.TOPPED_FLAG_YES.equals(announcementIdReq.getToppedFlag())) {
            if (Constants.NewsAnnouncementStatusEnum.EXPIRED.getFlag().equals(newsAnnouncement.getNewsStatus())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u8be5\u516c\u544a\u5df2\u5931\u6548\uff0c\u4e0d\u80fd\u7f6e\u9876");
            }
            if (new Date().compareTo(DateUtils.StringToDate((String)newsAnnouncement.getNewsEndTime())) > 0) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u8be5\u516c\u544a\u5df2\u5931\u6548\uff0c\u4e0d\u80fd\u7f6e\u9876");
            }
        }
        this.newsAnnouncementService.updateToppedStatus(announcementIdReq.getId(), announcementIdReq.getToppedFlag());
        return ResponseEntityWrapperUtil.wrapperOk((Object)true);
    }

    @PostMapping(value={"/delNews"})
    public ResponseEntity<BaseResultDTO<Boolean>> delNews(@RequestBody DeleteNewsOrTypeReq deleteNewsOrTypeReq) {
        if (CollectionUtils.isEmpty((Collection)deleteNewsOrTypeReq.getIdList())) {
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        List newsAnnouncementList = this.newsAnnouncementService.getBaseMapper().selectBatchIds((Collection)deleteNewsOrTypeReq.getIdList());
        this.newsAnnouncementService.delNews(deleteNewsOrTypeReq.getIdList());
        List newsTypeIdList = newsAnnouncementList.stream().map(NewsAnnouncement::getNewsTypeId).filter(ObjectUtils::isNotEmpty).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(newsTypeIdList)) {
            NewsChangeEventDTO eventDTO = new NewsChangeEventDTO();
            eventDTO.setDataChangeType(DataChangeTypeEnum.DELETE);
            eventDTO.setOldNewsTypeIdList(newsTypeIdList);
            NewsChangeEvent newsChangeEvent = new NewsChangeEvent((Object)this, eventDTO);
            this.eventPublisher.publishEvent((ApplicationEvent)newsChangeEvent);
        }
        return ResponseEntityWrapperUtil.wrapperOk((Object)true);
    }

    @PostMapping(value={"/validateNews"})
    public ResponseEntity<BaseResultDTO<ValidateNewsVO>> validateNews(@RequestBody @Valid NewsCommonIdReq announcementIdReq) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.newsAnnouncementService.validateNews(announcementIdReq.getId()));
    }

    @PostMapping(value={"/queryManagerNewsDetail"})
    public ResponseEntity<BaseResultDTO<NewsAnnouncementVO>> queryManagerNewsDetail(@RequestBody @Valid NewsCommonIdReq announcementIdReq) {
        NewsAnnouncementVO newsAnnouncementVO = this.newsAnnouncementService.queryManagerNewsDetail(announcementIdReq.getId());
        if (newsAnnouncementVO == null) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u516c\u544a\u4e0d\u5b58\u5728");
        }
        return ResponseEntityWrapperUtil.wrapperOk((Object)newsAnnouncementVO);
    }

    @PostMapping(value={"/saveNews"})
    public ResponseEntity<BaseResultDTO<Boolean>> saveNews(@RequestBody @Valid SaveAnnouncementReq saveAnnouncementReq) {
        Long newCount;
        boolean isAdd = ObjectUtils.isEmpty((Object)saveAnnouncementReq.getId());
        if (isAdd && (newCount = this.newsAnnouncementService.getBaseMapper().selectCount((Wrapper)Wrappers.emptyWrapper())) >= 1000L) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u6700\u5927\u53ef\u65b0\u589e1000\u6761\u516c\u544a\uff0c\u76ee\u524d\u5df2\u8fbe\u4e0a\u9650");
        }
        if (CollectionUtils.isNotEmpty((Collection)saveAnnouncementReq.getFileIdList()) && saveAnnouncementReq.getFileIdList().size() > 5) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u9644\u4ef6\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc75\u4e2a");
        }
        if (StringUtils.isNotBlank((CharSequence)saveAnnouncementReq.getNewsEffectiveTime())) {
            if (!DateUtils.validateDate((String)saveAnnouncementReq.getNewsEffectiveTime(), (String)"yyyy-MM-dd HH:mm:ss")) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u751f\u6548\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            if (saveAnnouncementReq.getNewsEffectiveTime().compareTo(saveAnnouncementReq.getNewsEndTime()) > 0) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u751f\u6548\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u622a\u6b62\u65f6\u95f4");
            }
        } else if (Constants.NewsAnnouncementStatusEnum.PUBLISHED.getFlag().equals(saveAnnouncementReq.getNewsStatus())) {
            saveAnnouncementReq.setNewsEffectiveTime(DateUtils.getNowTime(null));
        } else {
            saveAnnouncementReq.setNewsEffectiveTime(null);
        }
        if (!DateUtils.validateDate((String)saveAnnouncementReq.getNewsEndTime(), (String)"yyyy-MM-dd HH:mm:ss")) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u622a\u6b62\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        String tomorrow = DateUtils.addDate((String)DateUtils.getNowTime(null), (String)"yyyy-MM-dd HH:mm:ss", (int)1, (String)"day");
        if (saveAnnouncementReq.getNewsEndTime().compareTo(tomorrow) < 0) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u622a\u6b62\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4+24h");
        }
        if ((NewsAnnouncementPublishTypeEnum.LOGIN_NAME.getCode().equals(saveAnnouncementReq.getPublishType()) || NewsAnnouncementPublishTypeEnum.ROLE_NAME.getCode().equals(saveAnnouncementReq.getPublishType())) && (StringUtils.isBlank((CharSequence)saveAnnouncementReq.getPublishId()) || StringUtils.isBlank((CharSequence)saveAnnouncementReq.getPublishName()))) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u53d1\u5e03\u4eba\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.newsAnnouncementService.saveNews(saveAnnouncementReq);
        this.trackingUtil.reportUserTrackForSaveNews(saveAnnouncementReq);
        return ResponseEntityWrapperUtil.wrapperOk((Object)true);
    }

    @PostMapping(value={"/queryUserNewsList"})
    public ResponseEntity<BaseResultDTO<PageInfoResp<NewsAnnouncementVO>>> queryUserNewsList(@RequestBody @Valid WebQueryNewsListPageReq queryNewsListPageReq) {
        PageInfoResp pageInfoResp = this.newsAnnouncementService.queryUserNewsList(queryNewsListPageReq);
        return ResponseEntityWrapperUtil.wrapperOk((Object)pageInfoResp);
    }

    @PostMapping(value={"/readNews"})
    public ResponseEntity<BaseResultDTO<Boolean>> readNews(@RequestBody @Valid NewsCommonIdReq newsCommonIdReq) {
        AnnouncementIdReq announcementIdReq = new AnnouncementIdReq();
        announcementIdReq.setId(newsCommonIdReq.getId());
        NewsAnnouncement newsAnnouncement = this.newsAnnouncementService.queryUserNewsById(newsCommonIdReq.getId());
        if (Constants.ThirdNewsAnnouncementEnum.OUTSIDER_INFORMATION.getType().equals(newsAnnouncement.getNewsSource())) {
            announcementIdReq.setThirdAppId(newsAnnouncement.getThirdAppId());
            announcementIdReq.setThirdNewsId(newsAnnouncement.getThirdNewsId());
            announcementIdReq.setThirdAppCode(newsAnnouncement.getThirdAppCode());
        }
        boolean flag = this.newsAnnouncementReadService.insertNews(announcementIdReq);
        return ResponseEntityWrapperUtil.wrapperOk((Object)flag);
    }

    @PostMapping(value={"/likeNews"})
    public ResponseEntity<BaseResultDTO<Integer>> likeNews(@RequestBody @Valid NewLikeReqDTO newLikeReqDTO) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.newsAnnouncementLikeService.like(newLikeReqDTO, true));
    }

    @PostMapping(value={"/cancelLikeNews"})
    public ResponseEntity<BaseResultDTO<Integer>> cancelLikeNews(@RequestBody @Valid NewLikeReqDTO newLikeReqDTO) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.newsAnnouncementLikeService.like(newLikeReqDTO, false));
    }

    @PostMapping(value={"/favoriteNews"})
    public ResponseEntity<BaseResultDTO<Integer>> favoriteNews(@RequestBody @Valid NewsCommonIdReq newsCommonIdReq) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.newsAnnouncementFavoriteService.favoriteNews(newsCommonIdReq));
    }

    @PostMapping(value={"/cancelFavoriteNews"})
    public ResponseEntity<BaseResultDTO<Integer>> cancelFavoriteNews(@RequestBody @Valid NewsCommonIdListReq newsCommonIdListReq) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.newsAnnouncementFavoriteService.cancelFavoriteNews(newsCommonIdListReq));
    }

    @PostMapping(value={"/myFavoriteNewsList"})
    public ResponseEntity<BaseResultDTO<PageInfoResp<MyNewsAnnouncementFavoriteVO>>> myFavoriteNewsList(@RequestBody MyNewsFavoritePageReq myNewsFavoritePageReq) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.newsAnnouncementFavoriteService.myFavoriteNewsList(myNewsFavoritePageReq));
    }

    @PostMapping(value={"/queryUserNewsDetail"})
    public ResponseEntity<BaseResultDTO<NewsAnnouncementVO>> queryUserNewsDetail(@RequestBody @Valid NewsUserNewsDetailReq announcementIdReq) {
        NewsAnnouncement newsAnnouncement = this.newsAnnouncementService.queryUserNewsById(announcementIdReq.getId());
        if (ObjectUtils.isEmpty((Object)newsAnnouncement)) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u516c\u544a\u4e0d\u5b58\u5728");
        }
        if (Arrays.asList(Constants.NewsAnnouncementStatusEnum.UNPUBLISHED.getFlag(), Constants.NewsAnnouncementStatusEnum.EXPIRED.getFlag()).contains(newsAnnouncement.getNewsStatus()) || LocalDateTime.now().compareTo(LocalDateTime.parse(newsAnnouncement.getNewsEndTime(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))) > 0) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u516c\u544a\u5df2\u5931\u6548");
        }
        NewsAnnouncementVO newsAnnouncementVO = this.newsAnnouncementService.queryUserNewsDetail(newsAnnouncement, announcementIdReq.getCallSource());
        return ResponseEntityWrapperUtil.wrapperOk((Object)newsAnnouncementVO);
    }

    @PostMapping(value={"/queryNewsUnReadCount"})
    public ResponseEntity<BaseResultDTO<Integer>> queryNewsUnReadCount() {
        Integer count = this.newsAnnouncementService.queryNewsUnReadCount();
        return ResponseEntityWrapperUtil.wrapperOk((Object)count);
    }

    @PostMapping(value={"/queryNewsAppList"})
    public ResponseEntity<BaseResultDTO<List<JSONObject>>> queryNewsAppList() {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.newsAnnouncementService.queryNewsAppList());
    }

    @PostMapping(value={"/queryMobileNewsListPage"})
    public ResponseEntity<BaseResultDTO<PageInfoResp<NewsAnnouncementVO>>> queryMobileNewsListPage(@RequestBody @Valid QueryMobileNewsListPageReq queryMobileNewsListPageReq) {
        if (StringUtils.isNotBlank((CharSequence)queryMobileNewsListPageReq.getOrderByRule()) && !Arrays.asList("asc", "desc").contains(queryMobileNewsListPageReq.getOrderByRule())) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u6392\u5e8f\u89c4\u5219\u4e0d\u6b63\u786e");
        }
        if (StringUtils.isNotBlank((CharSequence)queryMobileNewsListPageReq.getEffectiveTimeStart()) && !DateUtils.validateDate((String)queryMobileNewsListPageReq.getEffectiveTimeStart(), (String)"yyyy-MM-dd HH:mm:ss") || StringUtils.isNotBlank((CharSequence)queryMobileNewsListPageReq.getEffectiveTimeEnd()) && !DateUtils.validateDate((String)queryMobileNewsListPageReq.getEffectiveTimeEnd(), (String)"yyyy-MM-dd HH:mm:ss")) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        PageInfoResp pageInfoResp = this.newsAnnouncementService.queryMobileNewsListPage(queryMobileNewsListPageReq);
        return ResponseEntityWrapperUtil.wrapperOk((Object)pageInfoResp);
    }
}

