/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.news;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.NewsTypeConstants;
import com.digiwin.athena.semc.dto.news.AnnouncementIdReq;
import com.digiwin.athena.semc.dto.news.DeleteNewsOrTypeReq;
import com.digiwin.athena.semc.dto.news.QueryAnnouncementTypeReq;
import com.digiwin.athena.semc.dto.news.SaveNewsTypeReqDTO;
import com.digiwin.athena.semc.dto.news.ValidSaveNewsTypeReqDTO;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.news.NewsAnnouncement;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementAut;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementRead;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementType;
import com.digiwin.athena.semc.mapper.news.NewsAnnouncementMapper;
import com.digiwin.athena.semc.mapper.news.NewsAnnouncementReadMapper;
import com.digiwin.athena.semc.service.news.NewsAnnouncementAuthService;
import com.digiwin.athena.semc.service.news.NewsAnnouncementService;
import com.digiwin.athena.semc.service.news.NewsAnnouncementTypeAuthService;
import com.digiwin.athena.semc.service.news.NewsAnnouncementTypeService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.InterceptorIgnoreUtil;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.news.NewsAnnouncementTypeVO;
import com.digiwin.athena.semc.vo.news.NewsTypeAuthVO;
import com.digiwin.athena.semc.vo.news.ValidSaveNewsTypeVO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.linpeilie.Converter;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/news/type"})
public class NewsAnnouncementTypeController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewsAnnouncementTypeController.class);
    @Resource
    private NewsAnnouncementTypeService newsAnnouncementTypeService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private Converter converter;
    @Resource
    private NewsAnnouncementAuthService newsAnnouncementAuthService;
    @Resource
    private NewsAnnouncementTypeAuthService newsAnnouncementTypeAuthService;
    @Resource
    private NewsAnnouncementMapper newsAnnouncementMapper;
    @Resource
    private NewsAnnouncementService newsAnnouncementService;
    @Resource
    private NewsAnnouncementReadMapper newsAnnouncementReadMapper;

    @PostMapping(value={"/queryNewsTypeList"})
    public ResponseEntity<BaseResultDTO<List<NewsAnnouncementTypeVO>>> queryNewsTypeList(@RequestBody QueryAnnouncementTypeReq queryAnnouncementTypeReq) {
        try {
            List autList;
            List newsTypeList = this.converter.convert(this.newsAnnouncementTypeService.queryNewsTypeListByParentId(null), NewsAnnouncementTypeVO.class);
            String locale = LocaleContextHolder.getLocale().toString();
            if ("zh_TW".equals(locale)) {
                newsTypeList.forEach(x -> {
                    if (StringUtils.isNotEmpty((String)x.getNameTw())) {
                        x.setName(x.getNameTw());
                    }
                    if (StringUtils.isNotEmpty((String)x.getDescriptionTw())) {
                        x.setDescription(x.getDescriptionTw());
                    }
                });
            }
            Map<Object, Object> newsTypeNewsMap = Maps.newHashMap();
            List newsAnnouncementReadList = Lists.newArrayList();
            if (Boolean.TRUE.equals(queryAnnouncementTypeReq.getQueryAuthNewsCount()) && CollectionUtils.isNotEmpty((Collection)(autList = this.newsAnnouncementAuthService.queryAuthNewsList()))) {
                List newsIdDistinctList = autList.stream().map(NewsAnnouncementAut::getNewsId).distinct().collect(Collectors.toList());
                List newsAnnouncementList = this.newsAnnouncementMapper.selectNewsAnnouncementIdList(Constants.NewsAnnouncementStatusEnum.PUBLISHED.getFlag(), newsIdDistinctList, null, DateUtils.getNowTime(null));
                newsAnnouncementList.addAll(this.newsAnnouncementService.queryThirdNewsList(null));
                newsTypeNewsMap = newsAnnouncementList.stream().collect(Collectors.groupingBy(NewsAnnouncement::getNewsTypeId, Collectors.toList()));
                if (CollectionUtils.isNotEmpty((Collection)newsAnnouncementList)) {
                    LambdaQueryWrapper readCondition = new LambdaQueryWrapper();
                    readCondition.in(NewsAnnouncementRead::getNewsId, (Collection)newsAnnouncementList.stream().map(NewsAnnouncement::getId).collect(Collectors.toList()));
                    readCondition.eq(BaseEntity::getCreateUserId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
                    readCondition.select(new SFunction[]{NewsAnnouncementRead::getNewsId});
                    newsAnnouncementReadList = this.newsAnnouncementReadMapper.selectList((Wrapper)readCondition);
                }
            }
            Map<Integer, List<NewsAnnouncementTypeVO>> newsTypeMap = newsTypeList.stream().collect(Collectors.groupingBy(NewsAnnouncementTypeVO::getLevel));
            List<NewsAnnouncementTypeVO> oneNewTypeList = newsTypeMap.get(1);
            this.softNewTypeList(oneNewTypeList);
            List other = oneNewTypeList.stream().filter(x -> NewsTypeConstants.NEWS_TYPE_OTHER_ID.equals(x.getId())).collect(Collectors.toList());
            oneNewTypeList.removeIf(x -> NewsTypeConstants.NEWS_TYPE_OTHER_ID.equals(x.getId()));
            oneNewTypeList.addAll(other);
            List<NewsAnnouncementTypeVO> twoNewTypeList = newsTypeMap.get(2);
            for (NewsAnnouncementTypeVO newsTypeVO : oneNewTypeList) {
                List oneAuthNewsList;
                int sumTwoAuthNewsCount = 0;
                int sumTwoAuthUnReadNewsCount = 0;
                if (CollectionUtils.isNotEmpty(twoNewTypeList)) {
                    List collect = twoNewTypeList.stream().filter(m -> m.getParentId().equals(newsTypeVO.getId())).collect(Collectors.toList());
                    this.softNewTypeList(collect);
                    for (NewsAnnouncementTypeVO newsTypeVO2 : collect) {
                        List twoAuthNewsList = (List)newsTypeNewsMap.getOrDefault(newsTypeVO2.getId(), Lists.newArrayList());
                        int twoAuthNewsCount = twoAuthNewsList.size();
                        newsTypeVO2.setAuthNewsCount(Integer.valueOf(twoAuthNewsCount));
                        sumTwoAuthNewsCount += twoAuthNewsCount;
                        long twoNewsReadCount = newsAnnouncementReadList.stream().filter(m -> this.existNews(twoAuthNewsList, m.getNewsId())).count();
                        newsTypeVO2.setAuthUnReadNewsCount(Integer.valueOf(twoAuthNewsCount - (int)twoNewsReadCount));
                        sumTwoAuthUnReadNewsCount += newsTypeVO2.getAuthUnReadNewsCount().intValue();
                        newsTypeVO2.setParentName(newsTypeVO.getName());
                    }
                    newsTypeVO.setChildrenList(collect);
                }
                if (sumTwoAuthNewsCount > 0) {
                    newsTypeVO.setAuthNewsCount(Integer.valueOf(sumTwoAuthNewsCount));
                } else {
                    oneAuthNewsList = newsTypeNewsMap.getOrDefault(newsTypeVO.getId(), Lists.newArrayList());
                    newsTypeVO.setAuthNewsCount(Integer.valueOf(oneAuthNewsList.size()));
                }
                if (sumTwoAuthUnReadNewsCount > 0) {
                    newsTypeVO.setAuthUnReadNewsCount(Integer.valueOf(sumTwoAuthUnReadNewsCount));
                    continue;
                }
                oneAuthNewsList = (List)newsTypeNewsMap.getOrDefault(newsTypeVO.getId(), Lists.newArrayList());
                long oneNewsReadCount = newsAnnouncementReadList.stream().filter(m -> this.existNews(oneAuthNewsList, m.getNewsId())).count();
                newsTypeVO.setAuthUnReadNewsCount(Integer.valueOf(oneAuthNewsList.size() - (int)oneNewsReadCount));
            }
            return ResponseEntityWrapperUtil.wrapperOk(oneNewTypeList);
        }
        catch (Exception e) {
            log.error("query news type list error. param:{}", (Object)queryAnnouncementTypeReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/news/type/queryNewsTypeList, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    private boolean existNews(List<NewsAnnouncement> newsAnnouncementList, Long newsId) {
        return newsAnnouncementList.stream().anyMatch(x -> x.getId().equals(newsId));
    }

    private void softNewTypeList(List<NewsAnnouncementTypeVO> newsTypeList) {
        if (CollectionUtils.isEmpty(newsTypeList)) {
            return;
        }
        newsTypeList.sort(Comparator.comparing(NewsAnnouncementTypeVO::getSort, Comparator.reverseOrder()).thenComparing(NewsAnnouncementTypeVO::getId, Comparator.naturalOrder()).thenComparing(NewsAnnouncementTypeVO::getName, Comparator.naturalOrder()));
    }

    @PostMapping(value={"/queryManageNewsTypeList"})
    public ResponseEntity<BaseResultDTO<List<NewsAnnouncementTypeVO>>> queryManageNewsTypeList(@RequestBody QueryAnnouncementTypeReq queryAnnouncementTypeReq) {
        List newsTypeList;
        ArrayList newsTypeRespList = Lists.newArrayList();
        Long parentId = null;
        if (queryAnnouncementTypeReq.getOnlyFirstFlag().booleanValue()) {
            parentId = NewsTypeConstants.NEWS_TYPE_FIRST_LEVEL_PARENT_ID;
        }
        if (queryAnnouncementTypeReq.getOnlyAuthFlag().booleanValue()) {
            NewsTypeAuthVO newsTypeAuthVO = this.newsAnnouncementTypeAuthService.queryAuthRelNewsType(null);
            if (Constants.ALL_AUTH_FLAG_NO.equals(newsTypeAuthVO.getAllNewsTypeFlag())) {
                List authorizedNewsTypeIdList = newsTypeAuthVO.getAuthorizedNewsTypeIdList();
                newsTypeList = (List)InterceptorIgnoreUtil.handler(() -> this.newsAnnouncementTypeService.getBaseMapper().selectBatchIds((Collection)authorizedNewsTypeIdList));
                List parentIdList = newsTypeList.stream().map(NewsAnnouncementType::getParentId).filter(x -> !NewsTypeConstants.NEWS_TYPE_FIRST_LEVEL_PARENT_ID.equals(x)).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(parentIdList)) {
                    List newsAnnouncementTypeList = (List)InterceptorIgnoreUtil.handler(() -> this.newsAnnouncementTypeService.getBaseMapper().selectBatchIds((Collection)parentIdList));
                    newsTypeList.addAll(newsAnnouncementTypeList);
                }
            } else {
                newsTypeList = this.newsAnnouncementTypeService.queryNewsTypeListByParentId(parentId);
            }
        } else {
            newsTypeList = this.newsAnnouncementTypeService.queryNewsTypeListByParentId(parentId);
        }
        if (CollectionUtils.isEmpty((Collection)newsTypeList)) {
            return ResponseEntityWrapperUtil.wrapperOk((Object)newsTypeRespList);
        }
        Map defaultNewsTypeIdMap = this.queryNewsListWithDefaultType(newsTypeList);
        Map<Long, List<NewsAnnouncementTypeVO>> parentIdMap = newsTypeList.stream().filter(x -> !NewsTypeConstants.NEWS_TYPE_FIRST_LEVEL_PARENT_ID.equals(x.getParentId())).map(x -> (NewsAnnouncementTypeVO)this.converter.convert(x, NewsAnnouncementTypeVO.class)).collect(Collectors.groupingBy(NewsAnnouncementTypeVO::getParentId));
        List parentNewsTypeList = newsTypeList.stream().filter(x -> NewsTypeConstants.NEWS_TYPE_FIRST_LEVEL_PARENT_ID.equals(x.getParentId())).collect(Collectors.toList());
        for (NewsAnnouncementType parentNewsType : parentNewsTypeList) {
            List<NewsAnnouncementTypeVO> newsTypeVOList;
            NewsAnnouncementTypeVO newsTypeRespVO = (NewsAnnouncementTypeVO)this.converter.convert((Object)parentNewsType, NewsAnnouncementTypeVO.class);
            newsTypeRespList.add(newsTypeRespVO);
            if (NewsTypeConstants.NEWS_TYPE_DEFAULT_FLAG.equals(parentNewsType.getDefaultFlag())) {
                List newsAnnouncementList = (List)defaultNewsTypeIdMap.get(parentNewsType.getId());
                if (CollectionUtils.isNotEmpty((Collection)newsAnnouncementList)) {
                    Integer totalCount = newsAnnouncementList.size();
                    Long publishedCount = newsAnnouncementList.stream().filter(x -> Constants.NewsAnnouncementStatusEnum.PUBLISHED.getFlag().equals(x.getNewsStatus())).count();
                    newsTypeRespVO.setNewsCount(totalCount);
                    newsTypeRespVO.setPublishedNewsCount(Integer.valueOf(publishedCount.intValue()));
                } else {
                    newsTypeRespVO.setNewsCount(Integer.valueOf(0));
                    newsTypeRespVO.setPublishedNewsCount(Integer.valueOf(0));
                }
            }
            if (!CollectionUtils.isNotEmpty(newsTypeVOList = parentIdMap.get(parentNewsType.getId()))) continue;
            newsTypeVOList.forEach(x -> x.setParentName(newsTypeRespVO.getName()));
            this.softNewTypeList(newsTypeVOList);
            newsTypeRespVO.setChildrenList(newsTypeVOList);
        }
        this.softNewTypeList((List)newsTypeRespList);
        newsTypeRespList.stream().filter(x -> NewsTypeConstants.NEWS_TYPE_DEFAULT_FLAG.equals(x.getDefaultFlag())).forEach(x -> x.setSort(null));
        NewsAnnouncementTypeVO other = newsTypeRespList.stream().filter(x -> NewsTypeConstants.NEWS_TYPE_OTHER_ID.equals(x.getId())).collect(Collectors.toList()).stream().findFirst().orElse(null);
        if (ObjectUtils.isNotEmpty((Object)other)) {
            newsTypeRespList.removeIf(x -> NewsTypeConstants.NEWS_TYPE_OTHER_ID.equals(x.getId()));
            other.setOtherFlag(Boolean.TRUE);
            other.setSort(null);
            newsTypeRespList.add(other);
        }
        return ResponseEntityWrapperUtil.wrapperOk((Object)newsTypeRespList);
    }

    private Map<Long, List<NewsAnnouncement>> queryNewsListWithDefaultType(List<NewsAnnouncementType> newsTypeList) {
        Map<Object, Object> defaultNewsTypeIdMap = Maps.newHashMap();
        List defaultNewsTypeIdList = newsTypeList.stream().filter(x -> NewsTypeConstants.NEWS_TYPE_DEFAULT_FLAG.equals(x.getDefaultFlag())).map(NewsAnnouncementType::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(defaultNewsTypeIdList)) {
            return defaultNewsTypeIdMap;
        }
        LambdaQueryWrapper condition = new LambdaQueryWrapper();
        condition.in(NewsAnnouncement::getNewsTypeId, defaultNewsTypeIdList);
        condition.select(new SFunction[]{NewsAnnouncement::getId, NewsAnnouncement::getNewsStatus, NewsAnnouncement::getNewsTypeId});
        List newsAnnouncementList = this.newsAnnouncementMapper.selectList((Wrapper)condition);
        defaultNewsTypeIdMap = newsAnnouncementList.stream().collect(Collectors.groupingBy(NewsAnnouncement::getNewsTypeId));
        return defaultNewsTypeIdMap;
    }

    @PostMapping(value={"/validSaveNewsType"})
    public ResponseEntity<BaseResultDTO<ValidSaveNewsTypeVO>> validSaveNewsType(@RequestBody @Valid ValidSaveNewsTypeReqDTO validSaveNewsTypeReqDTO) {
        ValidSaveNewsTypeVO validSaveNewsTypeVO = new ValidSaveNewsTypeVO();
        String msgCode = this.validNewsTypeInner(validSaveNewsTypeReqDTO);
        validSaveNewsTypeVO.setMsgCode(msgCode);
        return ResponseEntityWrapperUtil.wrapperOk((Object)validSaveNewsTypeVO);
    }

    private String validNewsTypeInner(ValidSaveNewsTypeReqDTO validSaveNewsTypeReqDTO) {
        List newsTypeList = this.newsAnnouncementTypeService.queryNewsTypeListByParentId(validSaveNewsTypeReqDTO.getParentId());
        if (ObjectUtils.isEmpty((Object)validSaveNewsTypeReqDTO.getNewsTypeId())) {
            long count;
            String respCode;
            if (NewsTypeConstants.NEWS_TYPE_FIRST_LEVEL_PARENT_ID.equals(validSaveNewsTypeReqDTO.getParentId()) && newsTypeList.size() >= NewsTypeConstants.MAX_NEWS_TYPE_COUNT) {
                return "1003";
            }
            if (!NewsTypeConstants.NEWS_TYPE_FIRST_LEVEL_PARENT_ID.equals(validSaveNewsTypeReqDTO.getParentId()) && StringUtils.isNotBlank((String)(respCode = this.validBelongingParentNewsType((count = newsTypeList.stream().filter(x -> !NewsTypeConstants.NEWS_TYPE_DEFAULT_FLAG.equals(x.getDefaultFlag())).count()) >= (long)NewsTypeConstants.MAX_NEWS_TYPE_COUNT.intValue(), validSaveNewsTypeReqDTO)))) {
                return respCode;
            }
        } else if (NewsTypeConstants.NEWS_TYPE_FIRST_LEVEL_PARENT_ID.equals(validSaveNewsTypeReqDTO.getParentId())) {
            long count = newsTypeList.stream().filter(x -> !validSaveNewsTypeReqDTO.getNewsTypeId().equals(x.getId())).count();
            if (count >= (long)NewsTypeConstants.MAX_NEWS_TYPE_COUNT.intValue()) {
                return "1003";
            }
        } else {
            long count = newsTypeList.stream().filter(x -> !NewsTypeConstants.NEWS_TYPE_DEFAULT_FLAG.equals(x.getDefaultFlag()) && !validSaveNewsTypeReqDTO.getNewsTypeId().equals(x.getId())).count();
            String respCode = this.validBelongingParentNewsType(count >= (long)NewsTypeConstants.MAX_NEWS_TYPE_COUNT.intValue(), validSaveNewsTypeReqDTO);
            if (StringUtils.isNotBlank((String)respCode)) {
                return respCode;
            }
            LambdaQueryWrapper condition = new LambdaQueryWrapper();
            condition.eq(NewsAnnouncementType::getParentId, (Object)validSaveNewsTypeReqDTO.getNewsTypeId());
            Long childCount = this.newsAnnouncementTypeService.getBaseMapper().selectCount((Wrapper)condition);
            if (childCount > 0L) {
                return "1002";
            }
        }
        return "1000";
    }

    private String validBelongingParentNewsType(boolean flag, ValidSaveNewsTypeReqDTO validSaveNewsTypeReqDTO) {
        if (flag) {
            return "1006";
        }
        NewsAnnouncementType parentNewsType = (NewsAnnouncementType)this.newsAnnouncementTypeService.getBaseMapper().selectById((Serializable)validSaveNewsTypeReqDTO.getParentId());
        if (ObjectUtils.isEmpty((Object)parentNewsType)) {
            return "1004";
        }
        if (ObjectUtils.isNotEmpty((Object)parentNewsType.getNewsCount()) && parentNewsType.getNewsCount() > 0) {
            return "1005";
        }
        return null;
    }

    @PostMapping(value={"/saveNewsType"})
    public ResponseEntity<BaseResultDTO<Boolean>> saveNewsType(@RequestBody @Valid SaveNewsTypeReqDTO saveNewsTypeReqDTO) {
        ValidSaveNewsTypeReqDTO validSaveNewsTypeReqDTO = new ValidSaveNewsTypeReqDTO();
        validSaveNewsTypeReqDTO.setNewsTypeId(saveNewsTypeReqDTO.getId());
        validSaveNewsTypeReqDTO.setParentId(saveNewsTypeReqDTO.getParentId());
        String msgCode = this.validNewsTypeInner(validSaveNewsTypeReqDTO);
        if (!"1000".equals(msgCode)) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u8bf7\u68c0\u67e5");
        }
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.newsAnnouncementTypeService.saveNewsType(saveNewsTypeReqDTO));
    }

    @PostMapping(value={"/validNewsType"})
    public ResponseEntity<BaseResultDTO<Boolean>> validNewsType(@RequestBody @Valid QueryAnnouncementTypeReq queryAnnouncementTypeReq) {
        if (ObjectUtils.isEmpty((Object)queryAnnouncementTypeReq.getNewsTypeId())) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"\u516c\u544a\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.newsAnnouncementTypeService.existByTypeId(queryAnnouncementTypeReq.getNewsTypeId()));
    }

    @PostMapping(value={"/validChildLevel"})
    public ResponseEntity<BaseResultDTO<ValidSaveNewsTypeVO>> validChildLevel(@RequestBody @Valid AnnouncementIdReq announcementIdReq) {
        ValidSaveNewsTypeVO validSaveNewsTypeVO = new ValidSaveNewsTypeVO();
        NewsAnnouncementType newsAnnouncementType = (NewsAnnouncementType)this.newsAnnouncementTypeService.getBaseMapper().selectById((Serializable)announcementIdReq.getId());
        if (ObjectUtils.isEmpty((Object)newsAnnouncementType)) {
            validSaveNewsTypeVO.setMsgCode("1001");
            return ResponseEntityWrapperUtil.wrapperOk((Object)validSaveNewsTypeVO);
        }
        if (ObjectUtils.isNotEmpty((Object)newsAnnouncementType.getNewsCount()) && newsAnnouncementType.getNewsCount() != 0) {
            validSaveNewsTypeVO.setMsgCode("1007");
            return ResponseEntityWrapperUtil.wrapperOk((Object)validSaveNewsTypeVO);
        }
        List childNewsTypeList = this.queryChildNewsTypeList(announcementIdReq.getId());
        if (childNewsTypeList.size() >= NewsTypeConstants.MAX_NEWS_TYPE_COUNT) {
            validSaveNewsTypeVO.setMsgCode("1008");
            return ResponseEntityWrapperUtil.wrapperOk((Object)validSaveNewsTypeVO);
        }
        validSaveNewsTypeVO.setMsgCode("1000");
        return ResponseEntityWrapperUtil.wrapperOk((Object)validSaveNewsTypeVO);
    }

    @PostMapping(value={"/delNewsType"})
    public ResponseEntity<BaseResultDTO<Boolean>> delNewsType(@RequestBody @Valid AnnouncementIdReq announcementIdReq) {
        NewsAnnouncementType newsAnnouncementType = (NewsAnnouncementType)this.newsAnnouncementTypeService.getBaseMapper().selectById((Serializable)announcementIdReq.getId());
        if (ObjectUtils.isEmpty((Object)newsAnnouncementType)) {
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        this.newsAnnouncementTypeService.delNewsType(newsAnnouncementType);
        return ResponseEntityWrapperUtil.wrapperOk((Object)true);
    }

    @PostMapping(value={"/validOperateNews"})
    public ResponseEntity<BaseResultDTO<ValidSaveNewsTypeVO>> validOperateNews(@RequestBody @Valid DeleteNewsOrTypeReq deleteNewsOrTypeReq) {
        ValidSaveNewsTypeVO validSaveNewsTypeVO = new ValidSaveNewsTypeVO();
        validSaveNewsTypeVO.setMsgCode("1000");
        if (CollectionUtils.isEmpty((Collection)deleteNewsOrTypeReq.getIdList())) {
            return ResponseEntityWrapperUtil.wrapperOk((Object)validSaveNewsTypeVO);
        }
        NewsTypeAuthVO newsTypeAuthVO = this.newsAnnouncementTypeAuthService.queryAuthRelNewsType(null);
        if (Constants.ALL_AUTH_FLAG_YES.equals(newsTypeAuthVO.getAllNewsTypeFlag())) {
            return ResponseEntityWrapperUtil.wrapperOk((Object)validSaveNewsTypeVO);
        }
        List newsTypeIdList = newsTypeAuthVO.getAuthorizedNewsTypeIdList();
        List newsAnnouncementList = this.newsAnnouncementService.getBaseMapper().selectBatchIds((Collection)deleteNewsOrTypeReq.getIdList());
        boolean flag = newsAnnouncementList.stream().anyMatch(x -> !newsTypeIdList.contains(x.getNewsTypeId()));
        if (flag) {
            if (deleteNewsOrTypeReq.getIdList().size() == 1) {
                validSaveNewsTypeVO.setMsgCode("1009");
            } else {
                validSaveNewsTypeVO.setMsgCode("1010");
            }
        }
        return ResponseEntityWrapperUtil.wrapperOk((Object)validSaveNewsTypeVO);
    }

    @PostMapping(value={"/validSaveNews"})
    public ResponseEntity<BaseResultDTO<ValidSaveNewsTypeVO>> validSaveNews(@RequestBody @Valid ValidSaveNewsTypeReqDTO validSaveNewsTypeReqDTO) {
        List childNewsTypeList;
        ValidSaveNewsTypeVO validSaveNewsTypeVO = new ValidSaveNewsTypeVO();
        NewsAnnouncementType newsAnnouncementType = (NewsAnnouncementType)InterceptorIgnoreUtil.handler(() -> (NewsAnnouncementType)this.newsAnnouncementTypeService.getBaseMapper().selectById((Serializable)validSaveNewsTypeReqDTO.getNewsTypeId()));
        if (ObjectUtils.isEmpty((Object)newsAnnouncementType)) {
            validSaveNewsTypeVO.setMsgCode("1001");
            return ResponseEntityWrapperUtil.wrapperOk((Object)validSaveNewsTypeVO);
        }
        if (!NewsTypeConstants.NEWS_TYPE_FIRST_LEVEL_PARENT_ID.equals(validSaveNewsTypeReqDTO.getParentId()) && NewsTypeConstants.NEWS_TYPE_FIRST_LEVEL_PARENT_ID.equals(newsAnnouncementType.getParentId())) {
            validSaveNewsTypeVO.setMsgCode("1011");
            return ResponseEntityWrapperUtil.wrapperOk((Object)validSaveNewsTypeVO);
        }
        if (NewsTypeConstants.NEWS_TYPE_FIRST_LEVEL_PARENT_ID.equals(validSaveNewsTypeReqDTO.getParentId()) && CollectionUtils.isNotEmpty((Collection)(childNewsTypeList = this.queryChildNewsTypeList(validSaveNewsTypeReqDTO.getNewsTypeId())))) {
            validSaveNewsTypeVO.setMsgCode("1013");
            return ResponseEntityWrapperUtil.wrapperOk((Object)validSaveNewsTypeVO);
        }
        NewsTypeAuthVO newsTypeAuthVO = this.newsAnnouncementTypeAuthService.queryAuthRelNewsType(null);
        if (Constants.ALL_AUTH_FLAG_YES.equals(newsTypeAuthVO.getAllNewsTypeFlag()) || newsTypeAuthVO.getAuthorizedNewsTypeIdList().contains(validSaveNewsTypeReqDTO.getNewsTypeId())) {
            validSaveNewsTypeVO.setMsgCode("1000");
        } else {
            validSaveNewsTypeVO.setMsgCode("1012");
        }
        return ResponseEntityWrapperUtil.wrapperOk((Object)validSaveNewsTypeVO);
    }

    private List<NewsAnnouncementType> queryChildNewsTypeList(Long newsTypeId) {
        LambdaQueryWrapper condition = new LambdaQueryWrapper();
        condition.eq(NewsAnnouncementType::getParentId, (Object)newsTypeId);
        return this.newsAnnouncementTypeService.getBaseMapper().selectList((Wrapper)condition);
    }
}

