/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.news;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.dto.news.ThirdNewsReq;
import com.digiwin.athena.semc.service.news.ThirdNewsAnnouncementService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import io.vavr.Tuple3;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/third/news"})
public class ThirdNewsAnnouncementController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThirdNewsAnnouncementController.class);
    @Resource
    private MessageUtils messageUtils;
    @Autowired
    private ThirdNewsAnnouncementService thirdNewsAnnouncementService;

    @PostMapping(value={"/receive"})
    public ResponseEntity<BaseResultDTO<Boolean>> receiveNewsList(@RequestBody @Valid ThirdNewsReq thirdNewsReq) {
        try {
            log.info("receive message. param:{}", (Object)JSON.toJSONString((Object)thirdNewsReq));
            Tuple3 tuple3 = this.thirdNewsAnnouncementService.checkAppCode(thirdNewsReq.getAppId(), thirdNewsReq.getAppCode());
            String error = (String)tuple3._1;
            String tenantId = (String)tuple3._2;
            if (StringUtils.isNotBlank((CharSequence)error) || StringUtils.isBlank((CharSequence)tenantId)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
            }
            List thirdNewsAnnouncementReqs = thirdNewsReq.getThirdNewsAnnouncementReqs();
            String errorMsg = this.thirdNewsAnnouncementService.checkNewsDateIsValid(thirdNewsAnnouncementReqs);
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)errorMsg);
            }
            this.thirdNewsAnnouncementService.saveNewsList(thirdNewsAnnouncementReqs, thirdNewsReq.getAppId(), thirdNewsReq.getAppCode(), tenantId, (ApplicationTypeEnum)tuple3._3);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/third/news/receive, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)e.getMessage());
        }
    }
}

