/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.open;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.dto.open.AppJobAccountVO;
import com.digiwin.athena.semc.dto.open.AppJobUrlReq;
import com.digiwin.athena.semc.dto.open.AppJobVO;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.service.open.OpenAppJobService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.Operation;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.validation.constraints.NotEmpty;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/openapi"})
public class JobController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobController.class);
    private static final Logger logger = LoggerFactory.getLogger(JobController.class);
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private OpenAppJobService openAppJobService;

    @Operation(summary="\u5e94\u7528\u4e0b\u4f5c\u4e1a")
    @GetMapping(value={"/job/{applicationType}/{applicationCode}"})
    public ResponseEntity<BaseResultDTO<List<AppJobVO>>> getAppJobList(@PathVariable(value="applicationType") @NotEmpty(message="\u5e94\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u5e94\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") Integer applicationType, @PathVariable(value="applicationCode") @NotEmpty(message="\u5e94\u7528\u4ee3\u53f7\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u5e94\u7528\u4ee3\u53f7\u4e0d\u80fd\u4e3a\u7a7a") String applicationCode) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.openAppJobService.queryAppJobList(applicationCode, applicationType));
        }
        catch (Exception e) {
            logger.error("queryAppJobList exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/openapi/job/list");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(summary="\u5e94\u7528\u4e0b\u4f5c\u4e1a\u8d26\u5957")
    @PostMapping(value={"/job/accounts"})
    public ResponseEntity<BaseResultDTO<List<AppJobAccountVO>>> queryAppJobAccounts(@RequestBody List<AppLinkDTO> appCodeList) {
        try {
            if (CollectionUtils.isEmpty(appCodeList)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"app code cannot be empty");
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.openAppJobService.queryAppJobAccount(appCodeList));
        }
        catch (Exception e) {
            logger.error("queryAppJobList exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/openapi/job/account");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(summary="\u5e94\u7528\u4e0b\u4f5c\u4e1a\u8d26\u5957")
    @PostMapping(value={"/job/account"})
    public ResponseEntity<BaseResultDTO<AppJobAccountVO>> queryAppJobAccount(@RequestBody AppLinkDTO app) {
        try {
            List appJobAccounts = this.openAppJobService.queryAppJobAccount((List)Lists.newArrayList((Object[])new AppLinkDTO[]{app}));
            if (CollectionUtils.isNotEmpty((Collection)appJobAccounts)) {
                return ResponseEntityWrapperUtil.wrapperOk(appJobAccounts.get(0));
            }
            return ResponseEntityWrapperUtil.wrapperOk(null);
        }
        catch (Exception e) {
            logger.error("queryAppJobList exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/openapi/job/account");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/app/link"})
    public ResponseEntity<BaseResultDTO<String>> queryCustomAppLink(@RequestBody AppJobUrlReq jobUrlReq) {
        try {
            AppLinkDTO appLinkDTO = this.openAppJobService.queryAppOrJobLink(jobUrlReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)(Objects.nonNull(appLinkDTO) ? appLinkDTO.getCloudwebsite() : ""));
        }
        catch (Exception e) {
            log.error("queryCustomAppLink is error\uff1a{}", (Object)jobUrlReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/openapi/app/link");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

