/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.open;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.controller.BasicController;
import com.digiwin.athena.semc.dto.message.QueryThirdMessageListReq;
import com.digiwin.athena.semc.dto.message.ReadThirdMessageReq;
import com.digiwin.athena.semc.entity.message.ThirdMessageConfig;
import com.digiwin.athena.semc.entity.message.ThirdMessageInfo;
import com.digiwin.athena.semc.service.message.ThirdSystemMessageService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/openapi/message"})
public class ThirdMessageController
extends BasicController<ThirdSystemMessageService, ThirdMessageConfig> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThirdMessageController.class);
    @Resource
    private ThirdSystemMessageService thirdSystemMessageService;
    @Resource
    private MessageUtils messageUtils;

    @PostMapping(value={"/queryUnreadCount"})
    public ResponseEntity<BaseResultDTO<Long>> queryUnreadCount() {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.thirdSystemMessageService.queryUnreadCount(Integer.valueOf(0)));
        }
        catch (Exception e) {
            log.error("query unread count error", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/openapi/message/queryUnreadCount");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<BaseResultDTO<PageInfoResp<ThirdMessageInfo>>> queryMessageListPage(@RequestBody @Valid QueryThirdMessageListReq queryThirdMessageListReq) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.thirdSystemMessageService.queryMessageListPage(queryThirdMessageListReq));
        }
        catch (Exception e) {
            log.error("query message list page error", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/openapi/message/list");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/readMessage"})
    public ResponseEntity<BaseResultDTO<Boolean>> readMessage(@RequestBody ReadThirdMessageReq readThirdMessageReq) {
        try {
            this.thirdSystemMessageService.readMessage(readThirdMessageReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("read message list error. readThirdMessageReq:{}", (Object)readThirdMessageReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/openapi/message/readMessage");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

