/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.open;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.controller.BasicController;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.open.SystemToDoReq;
import com.digiwin.athena.semc.dto.portal.ReimburseReq;
import com.digiwin.athena.semc.dto.portal.TodoListResp;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.entity.portal.TodoList;
import com.digiwin.athena.semc.service.open.OpenThirdToDoService;
import com.digiwin.athena.semc.service.portal.TodoListService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import io.swagger.v3.oas.annotations.Operation;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/openapi/todo"})
public class ThirdTodoController
extends BasicController<TodoListService, TodoList> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThirdTodoController.class);
    @Resource
    private TodoListService todoListService;
    @Resource
    private OpenThirdToDoService openThirdToDoService;
    @Resource
    private MessageUtils messageUtils;

    @Operation(summary="\u67e5\u8be2\u7ec4\u4ef6\u4e0b\u6570\u636e\u6e90\u7684\u5e94\u7528\u7cfb\u7edf")
    @PostMapping(value={"/application/list"})
    public ResponseEntity<BaseResultDTO<List<LabelSystemData>>> queryTodoAppList() {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.openThirdToDoService.queryTodoAppList());
        }
        catch (Exception e) {
            log.error("queryTodoAppList is exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/openapi/todo/application/list");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"list"})
    public ResultPageBean selectTodoList(@Valid @RequestBody SystemToDoReq todoListReq) {
        TodoListResp todoListResp = new TodoListResp();
        try {
            todoListResp = this.openThirdToDoService.queryTodoList(todoListReq);
        }
        catch (Exception e) {
            log.error("selectTodoList query exception", (Throwable)e);
            todoListResp.setResultCode("3001");
        }
        return ResultPageBean.success((ResponseBody)ResponseBody.getInstance((Object)todoListResp, (PageInfo)PageInfo.getPageInfo((Integer)todoListReq.getPageNum(), (Integer)todoListReq.getPageSize(), (Integer)todoListResp.getTotalResults())));
    }

    @PostMapping(value={"list/{applicationType}/{applicationCode}"})
    public ResultPageBean selectAppTodoList(@PathVariable(value="applicationType") @NotEmpty(message="\u5e94\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u5e94\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") Integer applicationType, @PathVariable(value="applicationCode") @NotEmpty(message="\u5e94\u7528\u4ee3\u53f7\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u5e94\u7528\u4ee3\u53f7\u4e0d\u80fd\u4e3a\u7a7a") String applicationCode, @Valid @RequestBody SystemToDoReq todoListReq) {
        TodoListResp todoListResp = new TodoListResp();
        try {
            todoListResp = this.openThirdToDoService.queryTodoListByCode(applicationCode, applicationType, todoListReq);
        }
        catch (Exception e) {
            log.error("selectTodoList query exception", (Throwable)e);
            todoListResp.setResultCode("3001");
        }
        return ResultPageBean.success((ResponseBody)ResponseBody.getInstance((Object)todoListResp, (PageInfo)PageInfo.getPageInfo((Integer)todoListReq.getPageNum(), (Integer)todoListReq.getPageSize(), (Integer)todoListResp.getTotalResults())));
    }

    @Operation(method="getTodoUrl", description="\u83b7\u53d6\u8df3\u8f6curl")
    @GetMapping(value={"/jumpUrl"})
    public ResponseEntity<?> getTodoUrl(@RequestParam(value="taskId") Long taskId) {
        ReimburseReq reimburseReq = new ReimburseReq();
        reimburseReq.setId(taskId);
        return this.todoListService.getTodoListUrl(reimburseReq);
    }
}

