/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResultBean;
import com.digiwin.athena.semc.common.enums.BizObjectTypeEnum;
import com.digiwin.athena.semc.dto.erpsso.GetSsoUrlReq;
import com.digiwin.athena.semc.dto.erpsso.GetSsoUrlResp;
import com.digiwin.athena.semc.dto.erpsso.QueryDisplayReq;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.service.applink.AppLinkService;
import com.digiwin.athena.semc.service.common.IBizObjAuthRelService;
import com.digiwin.athena.semc.service.common.IBizObjCommonUseService;
import com.digiwin.athena.semc.service.menu.AuthService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.SecurityLogUtil;
import com.digiwin.athena.semc.vo.common.BizObjAuthRelBatchForLinkReq;
import com.digiwin.athena.semc.vo.common.BizObjCommonUseVo;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tenant/semc/applink"})
public class AppLinkController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppLinkController.class);
    @Autowired
    private AppLinkService appLinkService;
    @Resource
    private IBizObjAuthRelService bizObjAuthRelService;
    @Resource
    private IBizObjCommonUseService bizObjCommonUseService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private AuthService authService;

    @PostMapping(value={"/accesses"})
    public ResultBean accessLink(@RequestBody Map<String, String> appJson) {
        ResultBean resultBean = new ResultBean();
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString(appJson));
        this.appLinkService.accessLink(jsonObject.getString("id"));
        resultBean.setResponse((Object)Boolean.TRUE);
        return resultBean;
    }

    @GetMapping(value={"/queryDisplayList"})
    public ResponseEntity<BaseResultDTO<List<AppLinkDTO>>> queryDisplayList(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestParam(required=false, value="key") String key) {
        try {
            List appLinkListDTO = this.appLinkService.queryDisplayList(user);
            if (StringUtils.isNotBlank((CharSequence)key)) {
                List matchedLinkList = appLinkListDTO.stream().filter(x -> x.getName().contains(key)).collect(Collectors.toList());
                return ResponseEntityWrapperUtil.wrapperOk(matchedLinkList);
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)appLinkListDTO);
        }
        catch (Exception e) {
            log.error("AppLinkController query manage list exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @PostMapping(value={"/queryDisplay"})
    public ResponseEntity<BaseResultDTO<AppLinkDTO>> queryDisplay(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody QueryDisplayReq req) {
        try {
            log.info("queryDisplay req:{}", (Object)req);
            AppLinkDTO appLinkDTO = this.appLinkService.queryDisplay(user, req);
            if (null == appLinkDTO) {
                return ResponseEntityWrapperUtil.wrapperFail((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)this.messageUtils.getMessage("error.message.query.not-found"));
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)appLinkDTO);
        }
        catch (Exception e) {
            log.error("AppLinkController queryDisplay exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)e.getMessage());
        }
    }

    @GetMapping(value={"/queryCommonUseList"})
    public ResponseEntity<BaseResultDTO<List<AppLinkDTO>>> queryCommonUseList(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        try {
            List commonUseList = this.bizObjCommonUseService.queryCommonUseList(BizObjectTypeEnum.APPlICATION_MANAGEMENT.getValue());
            List appLinkDTOList = this.appLinkService.queryCommonList(commonUseList, user);
            return ResponseEntityWrapperUtil.wrapperOk((Object)appLinkDTOList);
        }
        catch (Exception e) {
            log.error("AppLinkController query common list exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @PostMapping(value={"/getLinkSsoUrl"})
    public ResponseEntity<BaseResultDTO<AppLinkDTO>> getLinkSsoUrl(@RequestBody AppLinkDTO req) {
        try {
            if (StringUtils.isEmpty((CharSequence)req.getPrimaryId())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"primaryId \u4e0d\u53ef\u4e3a\u7a7a");
            }
            req = this.appLinkService.getLinkSsoUrl(req);
            return ResponseEntityWrapperUtil.wrapperOk((Object)req);
        }
        catch (Exception e) {
            log.error("getLinkSsoUrl  exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @PostMapping(value={"/saveCommonUse"})
    public ResponseEntity<BaseResultDTO<Boolean>> saveCommonUse(@RequestBody @Valid BizObjCommonUseVo bizObjCommonUseVo) {
        try {
            this.bizObjCommonUseService.saveCommonUse(bizObjCommonUseVo, BizObjectTypeEnum.APPlICATION_MANAGEMENT.getValue().intValue());
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("AppLinkController query common list exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @GetMapping(value={"/queryManageList"})
    public ResponseEntity<BaseResultDTO<List<AppLinkDTO>>> queryManageList(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        try {
            List appLinkListDTO = this.appLinkService.queryManageList(user);
            return ResponseEntityWrapperUtil.wrapperOk((Object)appLinkListDTO);
        }
        catch (Exception e) {
            log.error("AppLinkController query manage list exceptiona", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @GetMapping(value={"/queryAuthorizedList"})
    public ResponseEntity<BaseResultDTO<List<AppLinkDTO>>> queryAuthorizedList(@RequestParam(value="authId") String authId) {
        try {
            List appLinkListDTO = this.appLinkService.queryAuthorizedList(authId);
            return ResponseEntityWrapperUtil.wrapperOk((Object)appLinkListDTO);
        }
        catch (Exception e) {
            log.error("AppLinkController query manage list exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @PostMapping(value={"/saveAuth"})
    public ResponseEntity<BaseResultDTO<Boolean>> saveAuth(@RequestBody @Valid BizObjAuthRelBatchForLinkReq bizObjAuthRelBatchForLinkReq, HttpServletRequest request) {
        try {
            if (this.authService.hasAuth("permission-application")) {
                this.bizObjAuthRelService.saveBizObjectAuthRelForLinkApp(bizObjAuthRelBatchForLinkReq);
                return ResponseEntityWrapperUtil.wrapperOk((Object)true);
            }
            SecurityLogUtil.writeSecurityLog((HttpServletRequest)request, (String)JSON.toJSONString((Object)bizObjAuthRelBatchForLinkReq));
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u65e0\u6743\u9650");
        }
        catch (Exception e) {
            log.error("AppLinkController save auth exception, param:{}", (Object)bizObjAuthRelBatchForLinkReq, (Object)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @PostMapping(value={"/querySsoAppList"})
    public ResponseEntity<BaseResultDTO<List<AppLinkDTO>>> querySsoAppList() {
        try {
            AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
            List appLinkListDTO = this.appLinkService.querySsoList(user);
            return ResponseEntityWrapperUtil.wrapperOk((Object)appLinkListDTO);
        }
        catch (Exception e) {
            log.error("querySsoAppList exceptiona", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/tenant/semc/applink/querySsoAppList");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/getSsoUrl"})
    public ResponseEntity<?> getSsoUrl(@RequestBody GetSsoUrlReq req) {
        try {
            GetSsoUrlResp resp = this.appLinkService.getSsoUrl(req);
            return ResponseEntityWrapperUtil.wrapperOk((Object)resp);
        }
        catch (Exception e) {
            log.error("getSsoUrl exceptiona", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/tenant/semc/applink/getSsoUrl");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

