/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResultBean;
import com.digiwin.athena.semc.dto.homepage.DataMonitorReq;
import com.digiwin.athena.semc.dto.homepage.DataMonitorToDoReq;
import com.digiwin.athena.semc.dto.mq.MessageDO;
import com.digiwin.athena.semc.dto.portal.JobSyncReq;
import com.digiwin.athena.semc.dto.portal.TodoReceiveDto;
import com.digiwin.athena.semc.entity.portal.ThirdTodoConfig;
import com.digiwin.athena.semc.service.cache.ICacheService;
import com.digiwin.athena.semc.service.mq.MessageSendService;
import com.digiwin.athena.semc.service.portal.ThirdTodoConfigService;
import com.digiwin.athena.semc.service.portal.TodoListService;
import com.digiwin.athena.semc.util.AESUtils;
import com.digiwin.athena.semc.vo.maycur.MaycurTodoNoticeReq;
import com.digiwin.athena.semc.vo.maycur.MaycurTodoNoticeResp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tenant/semc"})
public class DataMonitorController {
    private static final Logger logger = LoggerFactory.getLogger(DataMonitorController.class);
    @Resource
    private MessageSendService messageSendService;
    @Autowired
    ICacheService cacheService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private TodoListService todoListService;
    @Resource
    private ThirdTodoConfigService thirdTodoConfigService;

    @PostMapping(value={"/data/notice"})
    public ResultBean dataNotice(@RequestBody DataMonitorReq dataMonitorReq) {
        logger.info("dataNotice param:{}", (Object)JSON.toJSONString((Object)dataMonitorReq));
        ResultBean resultBean = new ResultBean();
        try {
            ArrayList<String> verifyUserldList = dataMonitorReq.getVerifyUserldList();
            List changeDataList = dataMonitorReq.getChangeData();
            if (CollectionUtils.isNotEmpty((Collection)changeDataList)) {
                verifyUserldList = new ArrayList<String>();
                String userId = ((DataMonitorToDoReq)changeDataList.get(0)).getFkEmpId();
                verifyUserldList.add(userId);
            }
            for (String verifyUserld : verifyUserldList) {
                Object isUserObj;
                String key = "SEMC_TODO_USER:" + dataMonitorReq.getAppName();
                if (StringUtils.isNotEmpty((String)verifyUserld)) {
                    key = key + ":" + verifyUserld;
                }
                if (null != (isUserObj = this.cacheService.get(key))) {
                    return resultBean;
                }
                this.cacheService.cache(key, key, Duration.ofSeconds(1L));
                MessageDO payload = new MessageDO();
                payload.setAppName(dataMonitorReq.getAppName());
                payload.setAppId(dataMonitorReq.getAppId());
                payload.setUserId(verifyUserld);
                payload.setType(Constants.VALID_STATUS_UNUSABLE);
                this.messageSendService.sendToClient(verifyUserld, payload, "SEMC_TODO_USER");
            }
            return resultBean;
        }
        catch (Exception e) {
            logger.error("dataNotice  error req:{},e:{}", (Object)JSON.toJSONString((Object)dataMonitorReq), (Object)e);
            return resultBean;
        }
    }

    @PostMapping(value={"/todo/receive"})
    public ResponseEntity<?> toDoReceive(@RequestBody JobSyncReq req) {
        TodoReceiveDto receiveDto;
        logger.info("toDoReceive param:{}", (Object)JSON.toJSONString((Object)req));
        String bodyJsonStr = req.getBodyJsonStr();
        if (StringUtils.isEmpty((String)bodyJsonStr)) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"missing bodyJsonStr parameter");
        }
        try {
            String aesDecryptResult = AESUtils.aesDecrypt((String)bodyJsonStr, (String)"Wr3t3568aXaH91T30000fMK3ZpOyv4");
            receiveDto = (TodoReceiveDto)JSON.parseObject((String)aesDecryptResult, TodoReceiveDto.class);
        }
        catch (Exception e) {
            logger.error("toDoReceive parseObject error", (Throwable)e);
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"\u5165\u53c2\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u662f\u5426\u6b63\u786e");
        }
        try {
            if (receiveDto == null) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"\u5165\u53c2\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u662f\u5426\u6b63\u786e");
            }
            if (StringUtils.isEmpty((String)receiveDto.getAppCode())) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"missing app_code parameter");
            }
            if (CollectionUtils.isEmpty((Collection)receiveDto.getToDoList())) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"missing to_do_list parameter");
            }
            if (CollectionUtils.isEmpty((Collection)receiveDto.getDisplayFieldList())) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"missing display_field_list parameter");
            }
            ThirdTodoConfig thirdTodoConfig = this.thirdTodoConfigService.getToDoConfigBy("", receiveDto.getAppCode());
            if (null == thirdTodoConfig) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"\u5f53\u524d\u5e94\u7528\u4e0d\u5728\u914d\u7f6e\u4e2d\uff0c\u65e0\u6743\u63a8\u9001\u5f85\u529e");
            }
            if (Constants.VALID_STATUS_UNUSABLE.equals(thirdTodoConfig.getValidStatus())) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"\u5f53\u524d\u5e94\u7528\u672a\u542f\u7528\uff0c\u65e0\u6743\u63a8\u9001\u5f85\u529e");
            }
            this.todoListService.toDoReceive(receiveDto);
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            logger.error("toDoReceive exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "\u5f85\u529e\u540c\u6b65\u5f02\u5e38");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/maycur/approvals/notice"})
    public MaycurTodoNoticeResp maycurReceive(@RequestBody MaycurTodoNoticeReq req) {
        logger.info("maycurReceive approvals param:{}", (Object)JSON.toJSONString((Object)req));
        MaycurTodoNoticeResp resp = new MaycurTodoNoticeResp();
        try {
            resp.setCode(ErrorCodeConstant.PARAM_MISSING_ERROR + "");
            if (null == req.getCalloutParams()) {
                resp.setMessage("\u5916\u8c03\u53c2\u6570\u4e3a\u7a7a");
                return resp;
            }
            if (StringUtils.isEmpty((String)req.getCalloutParams().getFormCode())) {
                resp.setMessage("\u5355\u636e\u53f7\u4e3a\u7a7a");
                return resp;
            }
            if (StringUtils.isEmpty((String)req.getCalloutParams().getTaskActionType())) {
                resp.setMessage("\u4efb\u52a1\u7c7b\u578b\u4e3a\u7a7a");
                return resp;
            }
            if (CollectionUtils.isEmpty((Collection)req.getCalloutParams().getTaskAssignee())) {
                resp.setMessage("\u4efb\u52a1\u5904\u7406\u4eba\u4e3a\u7a7a");
                return resp;
            }
            this.todoListService.approvalsNotice(req);
            resp.setCode("ACK");
            return resp;
        }
        catch (Exception e) {
            logger.error("maycurReceive approvals exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "\u6bcf\u523b\u62a5\u9500\u56de\u8c03\u5f02\u5e38");
            resp.setCode(ErrorCodeConstant.PARAM_MISSING_ERROR + "");
            resp.setMessage(error);
            return resp;
        }
    }
}

