/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.BizException;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.ServiceException;
import com.digiwin.athena.semc.common.enums.BizObjectTypeEnum;
import com.digiwin.athena.semc.common.enums.BusinessSceneEnum;
import com.digiwin.athena.semc.common.enums.FolderLevelEnum;
import com.digiwin.athena.semc.common.enums.FolderTypeEnum;
import com.digiwin.athena.semc.controller.BasicController;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.FineReportQueryReq;
import com.digiwin.athena.semc.dto.portal.QueryReportReq;
import com.digiwin.athena.semc.dto.portal.SaveReportUrlParamReq;
import com.digiwin.athena.semc.entity.common.BizObjAuthRel;
import com.digiwin.athena.semc.entity.common.Folder;
import com.digiwin.athena.semc.entity.portal.FineReport;
import com.digiwin.athena.semc.service.cache.ICacheService;
import com.digiwin.athena.semc.service.cache.impl.CacheServiceImpl;
import com.digiwin.athena.semc.service.common.IBizObjAuthRelService;
import com.digiwin.athena.semc.service.common.IFolderService;
import com.digiwin.athena.semc.service.portal.IFineReportService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.common.BizObjAuthRelBatchVo;
import com.digiwin.athena.semc.vo.common.DeleteFolderVo;
import com.digiwin.athena.semc.vo.common.FolderViewVo;
import com.digiwin.athena.semc.vo.common.FolderVo;
import com.digiwin.athena.semc.vo.common.MoveFolderChildVo;
import com.digiwin.athena.semc.vo.common.MoveFolderListVo;
import com.digiwin.athena.semc.vo.portal.FineReportVo;
import com.digiwin.athena.semc.vo.portal.MoveFineReportVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.linpeilie.Converter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/fineReport"})
public class FineReporterController
extends BasicController<IFineReportService, FineReport> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FineReporterController.class);
    @Resource
    private IFolderService folderService;
    @Resource
    private IFineReportService fineReportService;
    @Resource
    private IBizObjAuthRelService bizObjAuthRelService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private Converter converter;

    @GetMapping(value={"/qryFolder"})
    public ResponseEntity<BaseResultDTO<List<FolderViewVo>>> qryFolder() {
        try {
            List ResponseEntityWrapperUtilUtil = this.fineReportService.qryFineReportFolder(BusinessSceneEnum.BACK_MANAGEMENT.getValue());
            log.info("FineReporterController qryFolder result:{}", (Object)ResponseEntityWrapperUtilUtil);
            return ResponseEntityWrapperUtil.wrapperOk((Object)ResponseEntityWrapperUtilUtil);
        }
        catch (Exception e) {
            log.error("FineReporterController qryFolder exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @GetMapping(value={"/qryFineReport/{folderId}"})
    public ResponseEntity<BaseResultDTO<List<FineReportVo>>> qryFineReport(@PathVariable(value="folderId") @NotNull(message="{NotNull.DeleteFolderVo.id}") @Valid @NotNull(message="{NotNull.DeleteFolderVo.id}") @Valid Long folderId) {
        try {
            if (!this.isExistFolder(folderId)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.folder.non.exists"));
            }
            List resultFineReportList = this.fineReportService.qryFineReport(folderId);
            return ResponseEntityWrapperUtil.wrapperOk((Object)resultFineReportList);
        }
        catch (Exception e) {
            log.error("FineReporterController qryFineReport exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @GetMapping(value={"/qryCurrentUserFolder"})
    public ResponseEntity<BaseResultDTO<List<FolderViewVo>>> qryCurrentUserFolder() {
        try {
            List ResponseEntityWrapperUtilUtil = this.fineReportService.qryFineReportFolder(BusinessSceneEnum.PORTAL.getValue());
            log.info("FineReporterController qryCurrentUserFolder end, result:{}", (Object)JSONObject.toJSONString((Object)ResponseEntityWrapperUtilUtil));
            return ResponseEntityWrapperUtil.wrapperOk((Object)ResponseEntityWrapperUtilUtil);
        }
        catch (Exception e) {
            log.error("FineReporterController qryCurrentUserFolder exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @GetMapping(value={"/qryCurrentUserFineReport/{folderId}"})
    public ResponseEntity<BaseResultDTO<List<FineReportVo>>> qryCurrentUserFineReport(@PathVariable(value="folderId") @NotNull(message="{NotNull.DeleteFolderVo.id}") @Valid @NotNull(message="{NotNull.DeleteFolderVo.id}") @Valid Long folderId, @RequestParam @NotBlank(message="{NotBlank.DeleteFolderVo.empId}") @Valid @NotBlank(message="{NotBlank.DeleteFolderVo.empId}") @Valid String empId) {
        try {
            if (!this.isExistFolder(folderId)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.folder.non.exists"));
            }
            List resultFineReportList = this.fineReportService.qryCurrentUserFineReport(folderId, empId);
            return ResponseEntityWrapperUtil.wrapperOk((Object)resultFineReportList);
        }
        catch (Exception e) {
            log.error("FineReporterController qryCurrentUserFineReport exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @PostMapping(value={"/addOrModFolder"})
    public ResponseEntity<?> addOrModFolder(@RequestBody @Valid FolderVo folderVo) {
        try {
            boolean isNameExist;
            log.info("FineReporterController addOrModFolder begin folderVo:{}", (Object)folderVo);
            if (Objects.nonNull(folderVo.getParentFolderId()) && StringUtils.isEmpty((String)(folderVo.getParentFolderId() + ""))) {
                folderVo.setParentFolderId(null);
            }
            if (Objects.isNull(folderVo.getId())) {
                if (Objects.isNull(folderVo.getLevel())) {
                    return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.FOLDER_LEVEL_NOT_EXISTS, (String)this.messageUtils.getMessage("error.message.folder.level.not.exists"));
                }
                if (Objects.nonNull(folderVo.getParentFolderId())) {
                    Folder parentFolder = (Folder)this.folderService.getBaseMapper().selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"obj_type", (Object)FolderTypeEnum.FINE_REPORT.getValue())).eq((Object)"id", (Object)folderVo.getParentFolderId()));
                    if (Objects.isNull(parentFolder)) {
                        return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.FOLDER_PARENT_NOT_EXISTS, (String)this.messageUtils.getMessage("error.message.folder.root.non.exists"));
                    }
                    if (FolderLevelEnum.THIRD.getValue().equals(parentFolder.getLevel())) {
                        return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.FOLDER_LEVEL_ERROR, (String)this.messageUtils.getMessage("error.message.folder.child.add.level"));
                    }
                }
                isNameExist = this.folderService.exists((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"obj_type", (Object)FolderTypeEnum.FINE_REPORT.getValue())).eq((Object)"name", (Object)folderVo.getName()));
            } else {
                isNameExist = this.folderService.exists((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"obj_type", (Object)FolderTypeEnum.FINE_REPORT.getValue())).eq((Object)"name", (Object)folderVo.getName())).ne((Object)"id", (Object)folderVo.getId()));
            }
            if (isNameExist) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.FOLDER_CHILD_CREATE_NAME_ERROR, (String)this.messageUtils.getMessage("error.message.folder.name.exists"));
            }
            Folder folder = (Folder)this.converter.convert((Object)folderVo, Folder.class);
            this.folderService.addOrModFolder(folder);
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            log.error("FineReporterController addOrModFolder exception", (Throwable)e);
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @DeleteMapping(value={"/delFolder"})
    public ResponseEntity<?> delFolder(@RequestBody @Valid DeleteFolderVo deleteFolderVo) {
        if (Objects.nonNull(deleteFolderVo.getParentFolderId()) && StringUtils.isEmpty((String)(deleteFolderVo.getParentFolderId() + ""))) {
            deleteFolderVo.setParentFolderId(null);
        }
        try {
            boolean isExistsRoot;
            log.info("FineReporterController delFolder deleteFolderVo:{}", (Object)JSONObject.toJSONString((Object)deleteFolderVo));
            if (Objects.isNull(deleteFolderVo.getParentFolderId()) && !(isExistsRoot = this.folderService.exists((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().isNull((Object)"parent_folder_id")).ne((Object)"id", (Object)deleteFolderVo.getId())).eq((Object)"obj_type", (Object)FolderTypeEnum.FINE_REPORT.getValue())))) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.folder.root.delete"));
            }
            this.folderService.delFolder(deleteFolderVo.getId(), FolderTypeEnum.FINE_REPORT.getValue().intValue());
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            log.error("FineReporterController delFolder exception", (Throwable)e);
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @PostMapping(value={"/moveFolder"})
    public ResponseEntity<BaseResultDTO<List<FolderViewVo>>> moveFolder(@RequestBody @Validated MoveFolderListVo moveFolderVoListVo) {
        try {
            log.info("FineReporterController moveFolder moveFolderVoListVo:{}", (Object)JSONObject.toJSONString((Object)moveFolderVoListVo));
            List moveFolderVoList = moveFolderVoListVo.getMoveFolderVoList();
            HashMap childrenFolderMap = Maps.newHashMap();
            moveFolderVoList.forEach(moveFolderVo -> this.buildChildFolderMap(childrenFolderMap, moveFolderVo.getChildren()));
            if (MapUtils.isNotEmpty((Map)childrenFolderMap)) {
                for (MoveFolderChildVo moveFolderChildVo : childrenFolderMap.values()) {
                    if (moveFolderChildVo.getLevel() <= FolderLevelEnum.THIRD.getValue()) continue;
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.FOLDER_LEVEL_ERROR, (String)this.messageUtils.getMessage("error.message.folder.not.same"));
                }
            }
            this.folderService.moveFolder(moveFolderVoList, (Map)childrenFolderMap);
            List ResponseEntityWrapperUtilUtil = this.fineReportService.qryFineReportFolder(BusinessSceneEnum.BACK_MANAGEMENT.getValue());
            return ResponseEntityWrapperUtil.wrapperOk((Object)ResponseEntityWrapperUtilUtil);
        }
        catch (Exception e) {
            log.error("FineReporterController moveFolder exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    private void buildChildFolderMap(Map<Long, MoveFolderChildVo> childrenFolderMap, List<MoveFolderChildVo> childrenFolderList) {
        if (CollectionUtils.isNotEmpty(childrenFolderList)) {
            childrenFolderList.forEach(childFolder -> {
                childrenFolderMap.put(childFolder.getId(), (MoveFolderChildVo)childFolder);
                this.buildChildFolderMap(childrenFolderMap, childFolder.getChildren());
            });
        }
    }

    @PostMapping(value={"/addOrModFineReport"})
    public ResponseEntity<?> addOrModFineReport(@RequestBody @Valid FineReportVo fineReportVo) {
        try {
            log.info("FineReporterController addOrModFineReport begin fineReportVo:{}", (Object)JSONObject.toJSONString((Object)fineReportVo));
            if (!this.isExistFolder(fineReportVo.getFolderId())) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.folder.non.exists"));
            }
            boolean existsName = this.fineReportService.isReportExist(1, fineReportVo);
            if (existsName) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.fineReport.name.exists"));
            }
            boolean existsUrl = this.fineReportService.isReportExist(2, fineReportVo);
            if (existsUrl) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.fineReport.url.exists"));
            }
            FineReport fineReport = (FineReport)this.converter.convert((Object)fineReportVo, FineReport.class);
            this.fineReportService.addOrModFineReport(fineReport, fineReportVo.getOrg(), fineReportVo.getRole(), fineReportVo.getUser());
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            log.error("FineReporterController addOrModFineReport exception", (Throwable)e);
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    private boolean isExistFolder(Long folderId) {
        return this.folderService.exists((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"obj_type", (Object)FolderTypeEnum.FINE_REPORT.getValue())).eq((Object)"id", (Object)folderId));
    }

    @PostMapping(value={"/moveFineReport"})
    public ResponseEntity<?> moveFineReport(@RequestBody @Valid MoveFineReportVo moveFineReportVo) {
        try {
            log.info("FineReporterController moveFineReport begin moveFineReportVo:{}", (Object)moveFineReportVo);
            boolean isFolderExist = this.folderService.exists((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"obj_type", (Object)FolderTypeEnum.FINE_REPORT.getValue())).in((Object)"id", Arrays.asList(moveFineReportVo.getSourceFolderId(), moveFineReportVo.getTargetFolderId())));
            if (!isFolderExist) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.folder.non.exists"));
            }
            if (Objects.equals(moveFineReportVo.getSourceFolderId(), moveFineReportVo.getTargetFolderId())) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.fineReport.folder"));
            }
            Integer maxOrder = this.fineReportService.queryMaxOrder(moveFineReportVo.getTargetFolderId(), AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            log.debug("FineReporterController target folder id:{}, report max order:{}", (Object)moveFineReportVo.getTargetFolderId(), (Object)maxOrder);
            FineReport fineReport = (FineReport)this.fineReportService.getBaseMapper().selectById((Serializable)moveFineReportVo.getId());
            fineReport.setFolderId(moveFineReportVo.getTargetFolderId());
            fineReport.setReportOrder(Integer.valueOf((maxOrder == null ? 0 : maxOrder) + 1));
            this.fineReportService.updateById((Object)fineReport);
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            log.error("FineReporterController moveFineReport exception, param:{}", (Object)JSONObject.toJSONString((Object)moveFineReportVo), (Object)e);
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @DeleteMapping(value={"/delFineReport/{id}"})
    public ResponseEntity<?> delFineReport(@PathVariable(value="id") @NotNull(message="{NotNull.Folder.id}") @Valid @NotNull(message="{NotNull.Folder.id}") @Valid Long id) {
        try {
            this.fineReportService.delFineReport(id);
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            log.error("FineReporterController delFineReport exception", (Throwable)e);
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @PostMapping(value={"/modFineReportAuth"})
    public ResponseEntity<?> modFineReportAuth(@RequestBody @Valid BizObjAuthRelBatchVo bizObjAuthRelBatchVo) {
        try {
            log.info("FineReporterController modFineReportAuth begin bizObjAuthRelBatchVo:{}", (Object)bizObjAuthRelBatchVo);
            this.bizObjAuthRelService.addBizObjectAuthRel(bizObjAuthRelBatchVo, BizObjectTypeEnum.FINE_REPORT.getValue().intValue());
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            log.error("FineReporterController modFineReportAuth exception", (Throwable)e);
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @PostMapping(value={"/saveReportUrlParam"})
    public ResponseEntity<BaseResultDTO<Boolean>> saveReportUrlParam(@RequestBody @Valid SaveReportUrlParamReq saveReportUrlParamReq) {
        try {
            log.info("FineReporterController saveReportUrlParam saveReportUrlParamReq:{}", (Object)JSONObject.toJSONString((Object)saveReportUrlParamReq));
            this.fineReportService.saveReportUrlParam(saveReportUrlParamReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)Boolean.TRUE);
        }
        catch (Exception e) {
            log.error("FineReporterController save report url param exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @PostMapping(value={"/changeFineReportAvailability/{availability}"})
    public ResponseEntity<?> changeFineReportAvailability(@PathVariable(value="availability") boolean availability) {
        try {
            this.cacheService.cache("FineReport-Availability:" + AppAuthContextHolder.getContext().getAuthoredUser().getTenantId(), String.valueOf(availability), CacheServiceImpl.DEFAULT_DURATION);
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            log.error("FineReporterController changeFineReportAvailability exception", (Throwable)e);
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @GetMapping(value={"/qryFineReportAvailability"})
    public ResponseEntity<BaseResultDTO<Boolean>> qryFineReportAvailability() {
        try {
            Object result = this.cacheService.get("FineReport-Availability:" + AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            return ResponseEntityWrapperUtil.wrapperOk((Object)(Objects.isNull(result) ? true : Boolean.parseBoolean(result.toString())));
        }
        catch (Exception e) {
            log.error("FineReporterController qryFineReportAvailability exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @PostMapping(value={"/queryReportByKey"})
    public ResponseEntity<BaseResultDTO<List<FineReportVo>>> queryReportByCondition(@RequestBody @Valid QueryReportReq queryReportReq) {
        try {
            List reportList;
            List keyList = queryReportReq.getKeyList().stream().distinct().collect(Collectors.toList());
            QueryWrapper reportParam = new QueryWrapper();
            reportParam.or(x -> keyList.forEach(key -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)x.or()).like((Object)"name", key);
            }));
            QueryWrapper folderParam = new QueryWrapper();
            folderParam.eq((Object)"obj_type", (Object)FolderTypeEnum.FINE_REPORT.getValue());
            folderParam.and(x -> keyList.forEach(key -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)x.or()).like((Object)"name", key);
            }));
            List folderList = this.folderService.getBaseMapper().selectList((Wrapper)folderParam);
            if (CollectionUtils.isNotEmpty((Collection)folderList)) {
                List folderIdList = folderList.stream().map(Folder::getId).collect(Collectors.toList());
                ((QueryWrapper)reportParam.or()).in((Object)"folder_id", folderIdList);
            }
            QueryWrapper authRelParam = new QueryWrapper();
            authRelParam.eq((Object)"biz_obj_type", (Object)FolderTypeEnum.FINE_REPORT.getValue());
            authRelParam.and(x -> keyList.forEach(key -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)x.or()).like((Object)"auth_name", key);
            }));
            List authRelList = this.bizObjAuthRelService.getBaseMapper().selectList((Wrapper)authRelParam);
            if (CollectionUtils.isNotEmpty((Collection)authRelList)) {
                List objIdList = authRelList.stream().map(BizObjAuthRel::getBizObjId).collect(Collectors.toList());
                ((QueryWrapper)reportParam.or()).in((Object)"id", objIdList);
            }
            if (CollectionUtils.isEmpty((Collection)(reportList = this.fineReportService.getBaseMapper().selectList((Wrapper)reportParam)))) {
                return ResponseEntityWrapperUtil.wrapperOk((Object)Lists.newArrayList());
            }
            List folderIdList = reportList.stream().map(FineReport::getFolderId).distinct().collect(Collectors.toList());
            List reportFolderList = this.folderService.getBaseMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"obj_type", (Object)FolderTypeEnum.FINE_REPORT.getValue())).in((Object)"id", folderIdList));
            List fineReportVoList = this.fineReportService.buildFineReportVoList(reportFolderList, reportList);
            return ResponseEntityWrapperUtil.wrapperOk((Object)fineReportVoList);
        }
        catch (Exception e) {
            log.error("FineReporterController query report by key occur exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @PostMapping(value={"/pageQuery"})
    public ResultPageBean pageQueryReport(@Valid @RequestBody FineReportQueryReq reportPageQueryReq) {
        log.info("/semc/fineReport/pageQuery param: reportPageQueryReq:{}", (Object)JSON.toJSONString((Object)reportPageQueryReq));
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        ArrayList fineReportVoList = new ArrayList();
        if (StringUtils.isEmpty((String)reportPageQueryReq.getQryCondition())) {
            return ResultPageBean.success((ResponseBody)ResponseBody.getInstance(fineReportVoList, (PageInfo)PageInfo.getPageInfo((Integer)reportPageQueryReq.getPageNum(), (Integer)reportPageQueryReq.getPageSize(), (Integer)0)));
        }
        try {
            return this.fineReportService.fineReportSearch(tenantId, reportPageQueryReq);
        }
        catch (BizException bizException) {
            return ResultPageBean.bizException((BizException)BizException.getDefaultBizException((Integer)ErrorCodeConstant.ADAPT_SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.report.open-error")));
        }
        catch (Exception e) {
            log.error("/semc/fineReport/pageQuery exception", (Throwable)e);
            ResultPageBean resultPageBean = ResultPageBean.sysException((ServiceException)new ServiceException(ErrorCodeConstant.SYSTEM_ERROR, this.messageUtils.getMessage("error.message.common.system-error")));
            return resultPageBean;
        }
    }

    @GetMapping(value={"/queryReportById"})
    public ResponseEntity<BaseResultDTO<FineReport>> queryFineReportById(@RequestParam Long reportId, @RequestParam Integer scene) {
        try {
            FineReport fineReport = this.fineReportService.queryFineReportById(reportId, scene);
            return ResponseEntityWrapperUtil.wrapperOk((Object)fineReport);
        }
        catch (Exception e) {
            log.error("FineReporterController query fine report by id exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }
}

