/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.enums.BizAuthTypeEnum;
import com.digiwin.athena.semc.common.enums.ImportTypeEnum;
import com.digiwin.athena.semc.common.enums.VirtualApplicationEnum;
import com.digiwin.athena.semc.controller.BasicController;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.dto.portal.UserLabelAuthReq;
import com.digiwin.athena.semc.entity.common.ImportRecord;
import com.digiwin.athena.semc.entity.portal.LabelSystemAuth;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;
import com.digiwin.athena.semc.entity.portal.LabelSystemPre;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.iam.service.model.RoleDTO;
import com.digiwin.athena.semc.service.portal.IImportRecordService;
import com.digiwin.athena.semc.service.portal.LabelSystemAuthService;
import com.digiwin.athena.semc.service.portal.LabelSystemCustomService;
import com.digiwin.athena.semc.service.portal.LabelSystemPreService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.common.ImportRecordResp;
import com.digiwin.athena.semc.vo.portal.ImportExcelResp;
import com.digiwin.athena.semc.vo.portal.ImportLabelExcelVo;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.google.common.collect.Lists;
import java.io.File;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/import"})
public class ImportLabelSystemController
extends BasicController<IImportRecordService, ImportRecord> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportLabelSystemController.class);
    @Resource
    private IImportRecordService importRecordService;
    @Resource
    private LabelSystemCustomService labelSystemCustomService;
    @Resource
    private LabelSystemPreService labelSystemPreService;
    @Resource
    private LabelSystemAuthService labelSystemAuthService;
    @Resource
    private IamService iamService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private EnvProperties envProperties;
    private static final Integer MAX_LABEL_IMPORT_COUNT = 1000;

    @PostMapping(value={"/queryFileId"})
    public ResponseEntity<BaseResultDTO<String>> queryFileId() {
        try {
            String labelFileId = this.envProperties.getLabelFileId();
            log.info("envProperties | get label file id:{}", (Object)labelFileId);
            return ResponseEntityWrapperUtil.wrapperOk((Object)labelFileId);
        }
        catch (Exception e) {
            log.error("query file id error.", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/import/queryFileId, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/importLabel"})
    public ResponseEntity<BaseResultDTO<ImportExcelResp>> importLabel(@RequestBody @Valid UserLabelAuthReq userLabelAuthReq) {
        ImportExcelResp excelResp = new ImportExcelResp();
        try {
            List excelVoList = this.importRecordService.readLabelExcel(userLabelAuthReq.getFileId());
            if (CollectionUtils.isEmpty((Collection)excelVoList)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.user.label.import.not.empty"));
            }
            if (excelVoList.size() > MAX_LABEL_IMPORT_COUNT) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)("\u6570\u636e\u91cf\u4e0d\u80fd\u8d85\u8fc7" + MAX_LABEL_IMPORT_COUNT + "\u6761"));
            }
            ArrayList excelStr = Lists.newArrayList();
            List userList = this.iamService.queryAllUserList();
            Map<String, RoleDTO> userIdMap = userList.stream().collect(Collectors.toMap(RoleDTO::getId, y -> y, (a, b) -> a));
            List roleList = this.iamService.queryAllRoleList();
            Map<String, RoleDTO> roleIdMap = roleList.stream().collect(Collectors.toMap(RoleDTO::getId, y -> y, (a, b) -> a));
            List customList = this.labelSystemCustomService.getBaseMapper().selectList((Wrapper)Wrappers.emptyWrapper());
            Map<String, LabelSystemCustom> customNameMap = customList.stream().collect(Collectors.toMap(LabelSystemCustom::getNameZh, y -> y, (a, b) -> a));
            List preList = this.labelSystemPreService.initPreData(Constants.ClientTypeEnum.PC.getValue());
            Map<String, LabelSystemPre> preNameMap = preList.stream().collect(Collectors.toMap(LabelSystemPre::getName, y -> y, (a, b) -> a));
            List labelAuthList = this.labelSystemAuthService.queryAuthListByCondition(Arrays.asList(BizAuthTypeEnum.USER.getValue(), BizAuthTypeEnum.ROLE.getValue()));
            Map<Long, Map<Integer, List<LabelSystemAuth>>> authMap = labelAuthList.stream().collect(Collectors.groupingBy(LabelSystemAuth::getAuthId, Collectors.groupingBy(LabelSystemAuth::getLabelType)));
            ArrayList userAuthRelList = Lists.newArrayList();
            int successNum = 0;
            ArrayList failList = Lists.newArrayList();
            int failNum = 0;
            String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
            for (ImportLabelExcelVo excelVo : excelVoList) {
                StringBuilder errorSb = this.validate(excelVo, userIdMap, roleIdMap, customNameMap, preNameMap, (List)excelStr);
                if (StringUtils.isNotBlank((String)errorSb.toString())) {
                    ++failNum;
                    excelVo.setFailDesc(errorSb.substring(0, errorSb.length() - 1));
                    failList.add(excelVo);
                    continue;
                }
                RoleDTO roleDTO = roleIdMap.get(excelVo.getRoleEmpId());
                RoleDTO userDTO = ObjectUtils.isEmpty((Object)userIdMap.get(excelVo.getRoleEmpId())) ? userIdMap.get(tenantId + "$" + excelVo.getRoleEmpId()) : userIdMap.get(excelVo.getRoleEmpId());
                ++successNum;
                LabelSystemAuth labelSystemAuth = new LabelSystemAuth();
                if (ObjectUtils.isNotEmpty((Object)roleDTO)) {
                    labelSystemAuth.setAuthId(Long.valueOf(roleDTO.getSid()));
                    labelSystemAuth.setAuthName(roleDTO.getName());
                    labelSystemAuth.setAuthType(BizAuthTypeEnum.ROLE.getValue());
                } else {
                    labelSystemAuth.setAuthId(Long.valueOf(userDTO.getSid()));
                    labelSystemAuth.setAuthName(userDTO.getName());
                    labelSystemAuth.setAuthType(BizAuthTypeEnum.USER.getValue());
                }
                if (Constants.LabelTypeEnum.SYSTEM_CUSTOM.getName().equals(excelVo.getLabelSource())) {
                    LabelSystemCustom labelSystemCustom = customNameMap.get(excelVo.getLabelName());
                    labelSystemAuth.setLabelId(labelSystemCustom.getId());
                    labelSystemAuth.setLabelType(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal());
                }
                if (Constants.LabelTypeEnum.SYSTEM_PRE.getName().equals(excelVo.getLabelSource())) {
                    LabelSystemPre labelSystemPre = preNameMap.get(excelVo.getLabelName());
                    labelSystemAuth.setLabelId(labelSystemPre.getId());
                    labelSystemAuth.setLabelType(Constants.LabelTypeEnum.SYSTEM_PRE.getVal());
                }
                if (MapUtils.isEmpty(authMap.get(labelSystemAuth.getAuthId()))) {
                    userAuthRelList.add(labelSystemAuth);
                    continue;
                }
                List<LabelSystemAuth> authList = authMap.get(labelSystemAuth.getAuthId()).get(labelSystemAuth.getLabelType());
                if (CollectionUtils.isEmpty(authList)) {
                    userAuthRelList.add(labelSystemAuth);
                    continue;
                }
                List labelIdList = authList.stream().map(LabelSystemAuth::getLabelId).collect(Collectors.toList());
                if (labelIdList.contains(labelSystemAuth.getLabelId())) continue;
                userAuthRelList.add(labelSystemAuth);
            }
            if (CollectionUtils.isNotEmpty((Collection)userAuthRelList)) {
                this.labelSystemAuthService.saveBatch((Collection)userAuthRelList);
            }
            ImportRecord importRecord = ImportRecord.builder().fileId(userLabelAuthReq.getFileId()).fileName(userLabelAuthReq.getFileName()).successCount(Integer.valueOf(successNum)).failCount(Integer.valueOf(failNum)).objType(ImportTypeEnum.USER_LABEL.getValue()).tenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId()).createUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName()).build();
            if (failNum > 0) {
                ShareInfo shareInfo = this.importRecordService.uploadExcel(this.write((List)failList));
                excelResp.setFailFileId(shareInfo.getFileId());
                excelResp.setFailFileName(shareInfo.getFileName());
                excelResp.setFailFileUrl(shareInfo.getUrl());
                importRecord.setFailFileId(shareInfo.getFileId());
                importRecord.setFailFileName(shareInfo.getFileName());
                importRecord.setFailFileUrl(shareInfo.getUrl());
            }
            this.importRecordService.insertImportRecord(importRecord);
            String resultCode = successNum > 0 && failNum == 0 ? "2001" : (successNum > 0 && failNum > 0 ? "2002" : (successNum == 0 && failNum > 0 ? "2003" : "2003"));
            excelResp.setResultCode(resultCode);
            excelResp.setFailCount(Integer.valueOf(failNum));
            excelResp.setSuccessCount(Integer.valueOf(successNum));
            return ResponseEntityWrapperUtil.wrapperOk((Object)excelResp);
        }
        catch (Exception e) {
            log.error("import label excel error. param:{}", (Object)userLabelAuthReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/import/importLabel, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    private StringBuilder validate(ImportLabelExcelVo excelVo, Map<String, RoleDTO> userIdMap, Map<String, RoleDTO> roleIdMap, Map<String, LabelSystemCustom> customNameMap, Map<String, LabelSystemPre> preNameMap, List<String> excelStr) {
        StringBuilder tenantId = new StringBuilder(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        StringBuilder errorSb = new StringBuilder();
        if (StringUtils.isBlank((String)excelVo.getRoleEmpId())) {
            errorSb.append("\u89d2\u8272ID\u6216\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a").append(",");
        }
        if (StringUtils.isBlank((String)excelVo.getLabelName())) {
            errorSb.append("\u7ec4\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a").append(",");
        }
        if (StringUtils.isBlank((String)excelVo.getLabelSource())) {
            errorSb.append("\u7ec4\u4ef6\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a").append(",");
        }
        if (StringUtils.isNotBlank((String)excelVo.getRoleEmpId()) && ObjectUtils.isEmpty((Object)roleIdMap.get(excelVo.getRoleEmpId())) && ObjectUtils.isEmpty((Object)userIdMap.get(excelVo.getRoleEmpId())) && ObjectUtils.isEmpty((Object)userIdMap.get(tenantId.append("$").append(excelVo.getRoleEmpId()).toString()))) {
            errorSb.append("\u89d2\u8272ID\u6216\u7528\u6237ID\u4e0d\u5b58\u5728").append(",");
        }
        if (StringUtils.isNotBlank((String)excelVo.getRoleEmpId()) && excelVo.getRoleEmpId().length() > 100) {
            errorSb.append("\u89d2\u8272ID\u6216\u7528\u6237ID\u7684\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u5b57").append(",");
        }
        if (StringUtils.isNotBlank((String)excelVo.getLabelName()) && excelVo.getLabelName().length() > 200) {
            errorSb.append("\u7ec4\u4ef6\u540d\u79f0\u7684\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7200\u4e2a\u5b57").append(",");
        }
        if (!Arrays.asList(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getName(), Constants.LabelTypeEnum.SYSTEM_PRE.getName()).contains(excelVo.getLabelSource())) {
            errorSb.append("\u7ec4\u4ef6\u6765\u6e90\u4e0d\u6b63\u786e").append(",");
        }
        if (Constants.LabelTypeEnum.SYSTEM_CUSTOM.getName().equals(excelVo.getLabelSource())) {
            if (StringUtils.isNotBlank((String)excelVo.getLabelName()) && ObjectUtils.isEmpty((Object)customNameMap.get(excelVo.getLabelName()))) {
                errorSb.append("\u7ec4\u4ef6\u540d\u79f0\u4e0d\u5b58\u5728").append(",");
            }
            if (StringUtils.isNotBlank((String)excelVo.getLabelName()) && ObjectUtils.isNotEmpty((Object)customNameMap.get(excelVo.getLabelName()))) {
                LabelSystemCustom systemCustom = customNameMap.get(excelVo.getLabelName());
                if (Constants.DataCategoryEnum.CATEGORY_COUNT.getVal().equals(systemCustom.getDataCategory())) {
                    errorSb.append("\u4e0d\u652f\u6301\u7edf\u8ba1\u7ec4\u4ef6\u5bfc\u5165").append(",");
                }
                if (Constants.DataCategoryEnum.BUSINESS_TODO.getVal().equals(systemCustom.getDataCategory())) {
                    errorSb.append("\u4e0d\u652f\u6301\u4e1a\u52a1\u5f85\u529e\u7ec4\u4ef6\u5bfc\u5165").append(",");
                }
                ArrayList<Long> systemIds = new ArrayList<Long>();
                systemIds.add(systemCustom.getId());
                List permSystemDataList = this.labelSystemCustomService.queryAthenaAppList(systemIds, VirtualApplicationEnum.ATHENA_APP.getPrimaryId());
                if (CollectionUtils.isNotEmpty((Collection)permSystemDataList)) {
                    errorSb.append("\u4e0d\u652f\u6301\u9f0e\u6377\u96c5\u5178\u5a1cAPP\u7ec4\u4ef6\u5bfc\u5165").append(",");
                }
            }
        }
        if (Constants.LabelTypeEnum.SYSTEM_PRE.getName().equals(excelVo.getLabelSource())) {
            if (StringUtils.isNotBlank((String)excelVo.getLabelName()) && ObjectUtils.isEmpty((Object)preNameMap.get(excelVo.getLabelName()))) {
                errorSb.append("\u7ec4\u4ef6\u540d\u79f0\u4e0d\u5b58\u5728").append(",");
            }
            if (StringUtils.isNotBlank((String)excelVo.getLabelName()) && ObjectUtils.isNotEmpty((Object)preNameMap.get(excelVo.getLabelName())) && Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal().equals(preNameMap.get(excelVo.getLabelName()).getDataType())) {
                errorSb.append("\u4e0d\u652f\u6301\u4e09\u65b9\u5f85\u529e\u7ec4\u4ef6\u5bfc\u5165").append(",");
            }
            if (StringUtils.isNotBlank((String)excelVo.getLabelName()) && ObjectUtils.isNotEmpty((Object)preNameMap.get(excelVo.getLabelName())) && Constants.DataTypeEnum.TYPE_TODO.getVal().equals(preNameMap.get(excelVo.getLabelName()).getDataType())) {
                errorSb.append("\u4e0d\u652f\u6301\u5f85\u529e\u7ec4\u4ef6\u5bfc\u5165").append(",");
            }
            if (StringUtils.isNotBlank((String)excelVo.getLabelName()) && ObjectUtils.isNotEmpty((Object)preNameMap.get(excelVo.getLabelName())) && Constants.DataTypeEnum.TYPE_CAROUSEL.getVal().equals(preNameMap.get(excelVo.getLabelName()).getDataType())) {
                errorSb.append("\u4e0d\u652f\u6301\u8f6e\u64ad\u56fe\u7ec4\u4ef6\u5bfc\u5165").append(",");
            }
        }
        if (StringUtils.isNotBlank((String)excelVo.getRoleEmpId()) && StringUtils.isNotBlank((String)excelVo.getLabelName()) && StringUtils.isNotBlank((String)excelVo.getLabelSource())) {
            StringBuilder str = new StringBuilder(excelVo.getRoleEmpId()).append(excelVo.getLabelName()).append(excelVo.getLabelSource());
            if (excelStr.contains(str.toString())) {
                errorSb.append("\u5b58\u5728\u91cd\u590d\u8bb0\u5f55\uff0c\u7528\u6237id:").append(excelVo.getRoleEmpId()).append(",\u7ec4\u4ef6\u540d\u79f0\uff1a").append(excelVo.getLabelName()).append(",\u7ec4\u4ef6\u6765\u6e90\uff1a").append(excelVo.getLabelSource()).append(",");
            }
            excelStr.add(str.toString());
        }
        return errorSb;
    }

    public File write(List<ImportLabelExcelVo> list) {
        File file = new File("\u6743\u9650\u5bfc\u5165\u6a21\u677f_\u9519\u8bef\u65e5\u5fd7.xlsx");
        EasyExcel.write((File)file, ImportLabelExcelVo.class).sheet("\u6743\u9650\u5bfc\u5165").doWrite(list);
        return file;
    }

    @PostMapping(value={"/queryImportLabelRecord"})
    public ResponseEntity<BaseResultDTO<PageInfoResp<ImportRecordResp>>> queryImportRecord(@RequestBody @Valid QueryImportRecordReq queryImportRecordReq) {
        try {
            if (StringUtils.isNotBlank((String)queryImportRecordReq.getStartTime()) && !DateUtils.validateDate((String)queryImportRecordReq.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss") || StringUtils.isNotBlank((String)queryImportRecordReq.getEndTime()) && !DateUtils.validateDate((String)queryImportRecordReq.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss")) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-illegal"));
            }
            PageInfoResp pageInfoResp = this.importRecordService.queryImportRecord(queryImportRecordReq, ImportTypeEnum.USER_LABEL.getValue());
            return ResponseEntityWrapperUtil.wrapperOk((Object)pageInfoResp);
        }
        catch (Exception e) {
            log.error("import label excel error. param:{}", (Object)queryImportRecordReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/import/queryImportLabelRecord, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

